/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.video_player.ui.custom_views;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Handler;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.players.video_player.util.FontUtils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.AbstractContentPanel;
import com.kidoz.sdk.api.ui_views.ItemVerticalRecycleViewAdapter;
import com.squareup.imagelib.Picasso;
import java.util.ArrayList;

public class RelatedContentPortraitContainer
extends RelativeLayout {
    private View mRootView;
    private TextView mVideoNameTextView;
    private TextView mRelatedContentLabelTextView;
    private ImageView mKidAvatarSimpleDraweeView;
    private LinearLayout mkidDetailsContainerLayout;
    private LinearLayout mVideoNameContainerLayout;
    private RecyclerView mRecyclerView;
    private GridLayoutManager mLayoutManager;
    private ItemVerticalRecycleViewAdapter mAdapter;
    private int mkidDetailsContainerLayoutHeight;
    private int mVideoNameContainerLayoutHeight;
    private int mPadding;
    private int itemOuterMargin;

    public RelatedContentPortraitContainer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    private void initView() {
        this.mRootView = RelatedContentPortraitContainer.inflate((Context)this.getContext(), (int)R.layout.related_content_portrait, null);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.mRootView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addView(this.mRootView);
        this.mVideoNameTextView = (TextView)this.mRootView.findViewById(R.id.videoNameTextView);
        this.mVideoNameTextView.setTypeface(FontUtils.getFont(this.getContext(), FontUtils.FONT_TYPE.DOSIS_BOLD.getValue()));
        this.mRelatedContentLabelTextView = (TextView)this.mRootView.findViewById(R.id.RelatedLabelTextView);
        this.mRelatedContentLabelTextView.setTypeface(FontUtils.getFont(this.getContext(), FontUtils.FONT_TYPE.DOSIS_BOLD.getValue()));
        this.mKidAvatarSimpleDraweeView = (ImageView)this.mRootView.findViewById(R.id.kidAvatarSimpleDraweeView);
        this.mkidDetailsContainerLayout = (LinearLayout)this.mRootView.findViewById(R.id.kidDetailsContainerLayout);
        this.mVideoNameContainerLayout = (LinearLayout)this.mRootView.findViewById(R.id.videoNameContainerLayout);
        this.initRecyclerView();
    }

    private void initRecyclerView() {
        this.mRecyclerView = (RecyclerView)this.mRootView.findViewById(R.id.RelatedContentRecyclerViewPortrait);
        this.mRootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT >= 16) {
                    RelatedContentPortraitContainer.this.mRootView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    RelatedContentPortraitContainer.this.mRootView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)-1, (int)0);
                int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)-2, (int)0);
                RelatedContentPortraitContainer.this.mVideoNameContainerLayout.measure(widthMeasureSpec, heightMeasureSpec);
                RelatedContentPortraitContainer.this.mkidDetailsContainerLayout.measure(widthMeasureSpec, heightMeasureSpec);
                RelatedContentPortraitContainer.this.mPadding = RelatedContentPortraitContainer.this.getResources().getDimensionPixelSize(R.dimen.VideoPlayerFragmentRelatedContentRecyclerViewPortraitPadding);
                RelatedContentPortraitContainer.this.mVideoNameContainerLayoutHeight = RelatedContentPortraitContainer.this.mVideoNameContainerLayout.getMeasuredHeight();
                RelatedContentPortraitContainer.this.mkidDetailsContainerLayoutHeight = RelatedContentPortraitContainer.this.mkidDetailsContainerLayout.getMeasuredHeight();
                int recyclerViewTopPadding = RelatedContentPortraitContainer.this.mkidDetailsContainerLayoutHeight + RelatedContentPortraitContainer.this.mVideoNameContainerLayoutHeight;
                RelatedContentPortraitContainer.this.mRecyclerView.setPadding(RelatedContentPortraitContainer.this.mPadding, recyclerViewTopPadding, RelatedContentPortraitContainer.this.mPadding, RelatedContentPortraitContainer.this.mPadding);
            }
        });
        this.mLayoutManager = new GridLayoutManager(this.getContext(), 2);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mLayoutManager);
        this.mRecyclerView.setHasFixedSize(true);
        this.mRecyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        this.mAdapter = new ItemVerticalRecycleViewAdapter(this.getContext(), 2);
        this.mAdapter.setFixedItemRatio(0.5f);
        this.itemOuterMargin = this.mAdapter.getItemOuterMargin();
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                RelatedContentPortraitContainer.this.scrollRelatedContent();
            }

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
            }
        });
        this.mRecyclerView.scrollToPosition(0);
        this.mkidDetailsContainerLayout.setTranslationY(0.0f);
        this.mVideoNameContainerLayout.setTranslationY(0.0f);
    }

    private void scrollRelatedContent() {
        View firstChild;
        if (this.mAdapter.getItemCount() > 0 && (firstChild = this.mRecyclerView.getChildAt(0)) != null) {
            int firstChildTop = this.mVideoNameContainerLayoutHeight + this.mkidDetailsContainerLayoutHeight + this.mPadding - firstChild.getTop() + this.itemOuterMargin;
            int firstVisiblePosition = this.mLayoutManager.findFirstVisibleItemPosition();
            if (firstVisiblePosition >= 0) {
                if (firstChildTop >= 0 && firstChildTop <= this.mVideoNameContainerLayoutHeight + this.mkidDetailsContainerLayoutHeight) {
                    this.mVideoNameContainerLayout.setVisibility(0);
                    this.mkidDetailsContainerLayout.setVisibility(0);
                    if (firstChildTop <= this.mkidDetailsContainerLayoutHeight + this.mVideoNameContainerLayoutHeight / 2) {
                        this.mVideoNameContainerLayout.setTranslationY((float)((int)((float)(-firstChildTop) * 0.5f)));
                    } else {
                        this.mVideoNameContainerLayout.setTranslationY((float)(-firstChildTop));
                    }
                    this.mkidDetailsContainerLayout.setTranslationY((float)(-firstChildTop));
                } else {
                    this.mVideoNameContainerLayout.setVisibility(4);
                    this.mkidDetailsContainerLayout.setVisibility(4);
                }
            }
        }
    }

    public void setContent(ArrayList<ContentItem> content) {
        if (this.mAdapter != null) {
            this.mAdapter.setContentData(content, false);
            this.mRecyclerView.scrollToPosition(0);
            this.mkidDetailsContainerLayout.setTranslationY(0.0f);
            this.mVideoNameContainerLayout.setTranslationY(0.0f);
            this.scrollRelatedContent();
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    RelatedContentPortraitContainer.this.mRecyclerView.scrollToPosition(0);
                    RelatedContentPortraitContainer.this.mkidDetailsContainerLayout.setTranslationY(0.0f);
                    RelatedContentPortraitContainer.this.mVideoNameContainerLayout.setTranslationY(0.0f);
                    RelatedContentPortraitContainer.this.scrollRelatedContent();
                }
            }, 300L);
        }
    }

    public void setKidAvatarURL(String avatarURL) {
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)-1, (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)-1, (int)0);
        this.mKidAvatarSimpleDraweeView.measure(widthMeasureSpec, heightMeasureSpec);
        Picasso.with(this.getContext()).load(avatarURL).into(this.mKidAvatarSimpleDraweeView);
    }

    public void setVideoName(String videoName) {
        this.mVideoNameTextView.setText((CharSequence)"");
        if (videoName != null) {
            if (videoName.startsWith("null")) {
                videoName = videoName.replace("null", "");
            }
            this.mVideoNameTextView.setText((CharSequence)videoName);
        }
    }

    public void setRelatedContentListener(AbstractContentPanel.IOnContentItemClickListener contentListener) {
        this.mAdapter.setOnItemClickListener(contentListener);
    }

    public void refresh() {
        this.mAdapter.notifyDataSetChanged();
    }

    public boolean getIsRelatedLoaded() {
        return this.mAdapter.getItemCount() > 0;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mAdapter.setSpanCount(2, newConfig.orientation);
        this.mLayoutManager = new GridLayoutManager(this.getContext(), 2);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mLayoutManager);
    }
}

