/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.video_player.ui.custom_views;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Handler;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.players.video_player.util.AnimationsUtils;
import com.kidoz.sdk.api.players.video_player.util.ScreenUtils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.AbstractContentPanel;
import com.kidoz.sdk.api.ui_views.ItemHorizontalRecycleViewAdapter;
import java.util.ArrayList;

public class RelatedContentLandscapeContainer
extends RelativeLayout {
    private View mRootView;
    private RelativeLayout mRecyclerViewContainer;
    private TextView mRelatedContentLabelTextView;
    private RecyclerView mRecyclerView;
    private LinearLayoutManager mLayoutManager;
    private ItemHorizontalRecycleViewAdapter mAdapter;
    private Handler mHandler;
    private int mTranslateDistance;
    private RelatedContentLandscapeContainerListener mRelatedContentLandscapeContainerListener;

    public RelatedContentLandscapeContainer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    private void initView() {
        this.mHandler = new Handler();
        this.mRootView = RelatedContentLandscapeContainer.inflate((Context)this.getContext(), (int)R.layout.related_content_landscape, null);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        this.mRootView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addView(this.mRootView);
        this.mRelatedContentLabelTextView = (TextView)this.mRootView.findViewById(R.id.LandscapeRelatedLabelTextView);
        this.initRecyclerView();
    }

    private void initRecyclerView() {
        float itemRatio;
        int numberOfItemsInARow;
        if (ScreenUtils.getIsTablet(this.getContext())) {
            numberOfItemsInARow = 2;
            itemRatio = 0.65f;
        } else {
            numberOfItemsInARow = 3;
            itemRatio = 0.8f;
        }
        int screenWidth = Math.min(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false));
        int itemWidth = screenWidth / numberOfItemsInARow;
        int itemHeight = (int)((float)itemWidth * itemRatio);
        int padding = this.getResources().getDimensionPixelSize(R.dimen.VideoPlayerFragmentRelatedContentRecyclerViewPortraitPadding);
        int layoutMargin = this.getResources().getDimensionPixelSize(R.dimen.RelatedItemCardMargin);
        int containerHeight = itemHeight + layoutMargin * 2 + padding * 2;
        this.mRecyclerViewContainer = (RelativeLayout)this.mRootView.findViewById(R.id.RecyclerViewContainer);
        this.mRecyclerViewContainer.getLayoutParams().height = containerHeight;
        this.mRecyclerView = (RecyclerView)this.mRootView.findViewById(R.id.RelatedContentRecyclerViewLandscape);
        this.mRecyclerView.setPadding(padding, padding, padding, 0);
        this.mLayoutManager = new LinearLayoutManager(this.getContext(), 0, false);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mLayoutManager);
        this.mRecyclerView.setHasFixedSize(true);
        this.mRecyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        this.mAdapter = new ItemHorizontalRecycleViewAdapter(this.getContext(), itemHeight);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mRecyclerView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (RelatedContentLandscapeContainer.this.mRelatedContentLandscapeContainerListener != null) {
                    RelatedContentLandscapeContainer.this.mRelatedContentLandscapeContainerListener.onInterceptTouchRequest();
                }
                return false;
            }
        });
    }

    public void setContent(ArrayList<ContentItem> content) {
        if (this.mAdapter != null) {
            this.mAdapter.setContentData(content, false);
        }
    }

    public void setRelatedContentListener(AbstractContentPanel.IOnContentItemClickListener contentListener) {
        this.mAdapter.setOnItemClickListener(contentListener);
    }

    public void animateEnter() {
        if (this.getResources().getConfiguration().orientation == 2 && this.mRecyclerView.getChildCount() > 0) {
            AnimationsUtils.animateRelatedContainerLandscapeSlideIn((View)this);
            if (this.mRelatedContentLandscapeContainerListener != null) {
                this.mRelatedContentLandscapeContainerListener.onRelatedPanelStateChanged(true);
            }
        }
    }

    public void animateExit() {
        if (this.getResources().getConfiguration().orientation == 2) {
            AnimationsUtils.animateRelatedContainerLandscapeSlideOut((View)this, this.mTranslateDistance);
            if (this.mRelatedContentLandscapeContainerListener != null) {
                this.mRelatedContentLandscapeContainerListener.onRelatedPanelStateChanged(false);
            }
        }
    }

    public void refresh() {
        this.mAdapter.notifyDataSetChanged();
    }

    public boolean getIsRelatedLoaded() {
        return this.mAdapter.getItemCount() > 0;
    }

    public void setTranslateDistance(int translateDistance) {
        this.mTranslateDistance = translateDistance;
    }

    public void setRelatedContentLandscapeContainerListener(RelatedContentLandscapeContainerListener relatedContentLandscapeContainerListener) {
        this.mRelatedContentLandscapeContainerListener = relatedContentLandscapeContainerListener;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mLayoutManager = new LinearLayoutManager(this.getContext(), 0, false);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mLayoutManager);
    }

    public static interface RelatedContentLandscapeContainerListener {
        public void onInterceptTouchRequest();

        public void onRelatedPanelStateChanged(boolean var1);
    }
}

