/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.video_player.ui.activities;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentTransaction;
import android.view.KeyEvent;
import com.kidoz.sdk.api.ContentExecutionHandler;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.players.video_player.logics.VideoPlayerListener;
import com.kidoz.sdk.api.players.video_player.ui.fragments.VideoPlayerFragment;
import com.kidoz.sdk.api.players.video_player.util.ScreenUtils;
import com.kidoz.sdk.api.players.video_player.util.YouTubeUtils;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.AbstractContentPanel;
import java.util.ArrayList;

public class YouTubePlayerActivity
extends FragmentActivity {
    private static final String TAG = YouTubePlayerActivity.class.getSimpleName();
    public static final String INTENT_EXTRA_VIDEO_ID = "INTENT_EXTRA_VIDEO_ID";
    public static final String INTENT_EXTRA_CONTENT_ITEM_ID = "INTENT_EXTRA_CONTENT_ITEM_ID";
    public static final String INTENT_EXTRA_VIDEO_NAME = "INTENT_EXTRA_VIDEO_NAME";
    public static final String INTENT_EXTRA_TOP_BAR_COLOR = "INTENT_EXTRA_TOP_BAR_COLOR";
    private VideoPlayerFragment mVideoPlayerFragment;
    private String mVideoID;
    private String mVideoName;
    private ArrayList<ContentItem> mContent;
    private Utils.StaticHandler mHandler = new Utils.StaticHandler();
    private int mCurrentOrientationState;

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        ScreenUtils.hideNavigationAndStatusBar(this.getWindow());
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mCurrentOrientationState = this.getResources().getConfiguration().orientation;
        this.setRequestedOrientation(4);
        this.setContentView(R.layout.youtube_player_activity);
        this.initActivity();
    }

    protected void onResume() {
        super.onResume();
        this.loadRelatedVideoItems();
    }

    private void initActivity() {
        ScreenUtils.hideNavigationAndStatusBar(this.getWindow());
        this.extractVideoParametersFromIntent();
        this.initVideoFragment();
    }

    private void extractVideoParametersFromIntent() {
        Intent intent = this.getIntent();
        if (intent != null && intent.hasExtra(INTENT_EXTRA_VIDEO_ID)) {
            this.mVideoID = intent.getStringExtra(INTENT_EXTRA_VIDEO_ID);
        }
        if (intent != null && intent.hasExtra(INTENT_EXTRA_VIDEO_NAME)) {
            this.mVideoName = this.mVideoName + intent.getStringExtra(INTENT_EXTRA_VIDEO_NAME);
        }
    }

    private void initVideoFragment() {
        this.mVideoPlayerFragment = new VideoPlayerFragment();
        this.mVideoPlayerFragment.setVideoID(this.mVideoID);
        this.mVideoPlayerFragment.setVideoName(this.mVideoName);
        this.mVideoPlayerFragment.setVideoPlayerListener(new VideoPlayerListener(){

            @Override
            public void onBuffering(boolean isBuffering) {
            }

            @Override
            public void onPaused() {
            }

            @Override
            public void onPlaying() {
            }

            @Override
            public void onSeekTo(int newPosition) {
            }

            @Override
            public void onStopped() {
            }

            @Override
            public void onError(String reason) {
            }

            @Override
            public void onFinishedLoading() {
            }

            @Override
            public void onLoading() {
            }

            @Override
            public void onVideoEnded() {
            }

            @Override
            public void onVideoStarted() {
            }

            @Override
            public void onNext() {
            }

            @Override
            public void onPlaylistEnded() {
            }

            @Override
            public void onPrevious() {
            }

            @Override
            public void onBackPressed() {
                YouTubePlayerActivity.this.finish();
            }

            @Override
            public void onLikeClicked() {
            }

            @Override
            public void onInfoClicked() {
            }

            @Override
            public void reloadRelatedContent() {
                YouTubePlayerActivity.this.loadRelatedVideoItems();
            }

            @Override
            public void onRelatedPanelStateChanged(boolean isOpened) {
            }
        });
        this.mVideoPlayerFragment.setRelatedContentItemListener(new AbstractContentPanel.IOnContentItemClickListener(){

            @Override
            public void onItemClick(ContentItem contentItem, int position) {
                if (contentItem != null && contentItem.getContentType() == ContentType.YOTUBE_VIDEO) {
                    YouTubePlayerActivity.this.mVideoID = YouTubeUtils.extractYouTubeVideoIDString(contentItem.getData());
                    YouTubePlayerActivity.this.mVideoName = contentItem.getName();
                    YouTubePlayerActivity.this.mVideoPlayerFragment.setVideoID(YouTubePlayerActivity.this.mVideoID);
                    YouTubePlayerActivity.this.mVideoPlayerFragment.setVideoName(YouTubePlayerActivity.this.mVideoName);
                } else {
                    ContentExecutionHandler.handleContentItemClick((Context)YouTubePlayerActivity.this, null, contentItem, position);
                }
            }
        });
        FragmentTransaction fragmentTransaction = this.getSupportFragmentManager().beginTransaction();
        fragmentTransaction.replace(R.id.FragmentContainerForYouTube, (Fragment)this.mVideoPlayerFragment, VideoPlayerFragment.TAG);
        fragmentTransaction.commitAllowingStateLoss();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean result = true;
        if (keyCode != 4) {
            result = super.onKeyDown(keyCode, event);
        }
        return result;
    }

    private void loadRelatedVideoItems() {
        if (!this.isFinishing() && (this.mContent == null || this.mContent.isEmpty())) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    String data = null;
                    String packageName = YouTubePlayerActivity.this.getPackageName();
                    if (packageName != null) {
                        if (packageName.equals("com.kidoz.swipethepanda")) {
                            data = Utils.readStringFromAssets((Context)YouTubePlayerActivity.this, "panda.json");
                        } else if (packageName.equals("com.kidoz.painter")) {
                            data = Utils.readStringFromAssets((Context)YouTubePlayerActivity.this, "painter.json");
                        }
                    }
                    ContentData contentData = null;
                    if (data != null) {
                        contentData = new ContentData();
                        contentData.decodeResponse(data);
                    }
                    if (contentData != null && contentData.isHasContentToShow()) {
                        YouTubePlayerActivity.this.mContent = contentData.getContentDataItems();
                        YouTubePlayerActivity.this.mVideoPlayerFragment.setRelatedContent(contentData.getContentDataItems());
                    }
                }
            }, 500L);
        }
    }

    protected void onStop() {
        super.onStop();
        this.mHandler.removeCallbacksAndMessages(null);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.setRequestedOrientation(this.mCurrentOrientationState);
    }
}

