/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.utils;

import android.net.Uri;
import android.support.annotation.Nullable;

public class UriUtil {
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final String LOCAL_FILE_SCHEME = "file";
    public static final String LOCAL_CONTENT_SCHEME = "content";
    public static final String LOCAL_ASSET_SCHEME = "asset";
    public static final String LOCAL_RESOURCE_SCHEME = "res";
    public static final String DATA_SCHEME = "data";

    public static boolean isNetworkUri(@Nullable Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return HTTPS_SCHEME.equals(scheme) || HTTP_SCHEME.equals(scheme);
    }

    public static boolean isLocalFileUri(@Nullable Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return LOCAL_FILE_SCHEME.equals(scheme);
    }

    public static boolean isLocalContentUri(@Nullable Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return LOCAL_CONTENT_SCHEME.equals(scheme);
    }

    public static boolean isLocalAssetUri(@Nullable Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return LOCAL_ASSET_SCHEME.equals(scheme);
    }

    public static boolean isLocalResourceUri(@Nullable Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return LOCAL_RESOURCE_SCHEME.equals(scheme);
    }

    public static boolean isDataUri(@Nullable Uri uri) {
        return DATA_SCHEME.equals(UriUtil.getSchemeOrNull(uri));
    }

    @Nullable
    public static String getSchemeOrNull(@Nullable Uri uri) {
        return uri == null ? null : uri.getScheme();
    }

    public static Uri parseUriOrNull(@Nullable String uriAsString) {
        return uriAsString != null ? Uri.parse((String)uriAsString) : null;
    }
}

