/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.utils;

import android.content.ContentValues;
import android.content.Context;
import android.util.Log;
import android.widget.Toast;
import java.util.Set;

public class SDKLogger {
    public static final String GENERAL_TAG = "[:Kidoz SDK:]";
    public static boolean IS_DEBBUG_MODE = true;

    public static final void printInfoLog(String msg) {
        if (IS_DEBBUG_MODE) {
            Log.i((String)GENERAL_TAG, (String)("[KIDOZ SDK] : " + msg));
        }
    }

    public static final void printInfoLog(String tag, String msg) {
        if (IS_DEBBUG_MODE) {
            Log.i((String)tag, (String)("[KIDOZ SDK] : " + msg));
        }
    }

    public static final void printWarningLog(String msg) {
        if (IS_DEBBUG_MODE) {
            Log.w((String)GENERAL_TAG, (String)("[KIDOZ SDK] : " + msg));
        }
    }

    public static final void printWarningLog(String tag, String msg) {
        if (IS_DEBBUG_MODE) {
            Log.w((String)tag, (String)("[KIDOZ SDK] : " + msg));
        }
    }

    public static final void printErrorLog(String msg) {
        if (IS_DEBBUG_MODE) {
            Log.e((String)GENERAL_TAG, (String)("[KIDOZ SDK] : " + msg));
        }
    }

    public static final void printErrorLog(String tag, String msg) {
        if (IS_DEBBUG_MODE) {
            Log.e((String)tag, (String)("[KIDOZ SDK] : " + msg));
        }
    }

    public static final void printDebbugLog(String msg) {
        if (IS_DEBBUG_MODE) {
            Log.d((String)GENERAL_TAG, (String)("[KIDOZ SDK] : " + msg));
        }
    }

    public static final void printDebugToast(Context context, String msg) {
        if (IS_DEBBUG_MODE) {
            Toast.makeText((Context)context, (CharSequence)msg, (int)0).show();
        }
    }

    public static final void printDebbugLog(String tag, String msg) {
        if (IS_DEBBUG_MODE) {
            Log.d((String)tag, (String)msg);
        }
    }

    public static final void printGetRequestDebugLog(String url, ContentValues contentValues, String requestType) {
        if (IS_DEBBUG_MODE && contentValues != null) {
            StringBuilder sb = new StringBuilder("|\n|\n|\n");
            sb.append("| \n<<<<< |KIDOZ SDK| **[REQUEST]** API : [GET] , RequestType :  [" + requestType + "] >>>>>\n\n");
            sb.append("[WEBSITE_URL] :" + url + "\n");
            sb.append("[PARAMETERS] : \n");
            Set set = contentValues.keySet();
            if (set.size() > 0) {
                for (String key : set) {
                    sb.append("-- " + key + " = " + contentValues.getAsString(key));
                    sb.append("\n");
                }
            }
            sb.append("\n|\n|\n|\n");
            Log.d((String)GENERAL_TAG, (String)sb.toString());
        }
    }

    public static final void printPostRequestDebugLog(String url, ContentValues contentValues, String requestType) {
        if (IS_DEBBUG_MODE && contentValues != null) {
            StringBuilder sb = new StringBuilder("|\n|\n|\n");
            sb.append("\n<<<<< |KIDOZ SDK| **[REQUEST]** API : [POST] , RequestType :  [" + requestType + "] >>>>>\n\n");
            sb.append("[WEBSITE_URL] :" + url + "\n");
            sb.append("[PARAMETERS] : \n");
            Set set = contentValues.keySet();
            if (set.size() > 0) {
                for (String key : set) {
                    sb.append("-- " + key + " = " + contentValues.getAsString(key));
                    sb.append("\n");
                }
            }
            sb.append("\n|\n|\n|\n");
            Log.d((String)GENERAL_TAG, (String)sb.toString());
        }
    }

    public static final void printResponce(String responce, String requestType) {
        if (IS_DEBBUG_MODE) {
            StringBuilder sb = new StringBuilder("|\n|\n|\n");
            sb.append(" \n\n<<<<< |KIDOZ SDK| **[RESPONCE]** API : [POST] , RequestType :  [" + requestType + "] >>>>>\n\n");
            sb.append("[RESPONCE STRING] : \n");
            sb.append(" " + responce);
            sb.append("|\n|\n|\n");
            Log.d((String)GENERAL_TAG, (String)sb.toString());
        }
    }

    public static final void printToast(Context context, String msg) {
        if (IS_DEBBUG_MODE) {
            Toast.makeText((Context)context, (CharSequence)msg, (int)0).show();
        }
    }
}

