/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.custom_views;

import android.animation.Animator;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.players.video_player.util.ScreenUtils;
import com.kidoz.sdk.api.players.web_player.KidozWebView;

public class KidozBottomBar
extends LinearLayout {
    public static final float BACKGROUND_RATIO = 0.061458334f;
    public static final float KIDOZ_LOGO_RATIO = 1.2952381f;
    public static final float KIDOZ_LOGO_AND_BACKGROUND_RATIO = 1.6949153f;
    private RelativeLayout mRootView;
    private ImageView mBackgroundImageView;
    private Utils.StaticHandler mStaticHandler = new Utils.StaticHandler();
    private FrameLayout mAboutKidozContainer;
    private int[] mAboutKidozPivot;
    private boolean mIsOrientationPortrait;
    private KidozWebView mKidozWebView;
    private boolean mIsNeedToCloseWebViewOnClick = true;

    public KidozBottomBar(Context context) {
        super(context);
        this.initView();
    }

    public KidozBottomBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    private void initView() {
        this.mIsOrientationPortrait = this.getContext().getResources().getConfiguration().orientation == 1;
        this.initRootView();
        this.initBackground();
        this.initAboutKidoz();
    }

    private void initAboutKidoz() {
        ImageView KidozLogoImageView = (ImageView)this.mRootView.findViewById(R.id.KidozLogoImageView);
        KidozLogoImageView.getLayoutParams().height = (int)((float)this.mBackgroundImageView.getLayoutParams().height * 1.6949153f);
        KidozLogoImageView.getLayoutParams().width = (int)((float)KidozLogoImageView.getLayoutParams().height / 1.2952381f);
        this.mAboutKidozPivot = new int[2];
        this.mAboutKidozPivot[0] = KidozLogoImageView.getLayoutParams().width / 2;
        this.mAboutKidozPivot[1] = KidozLogoImageView.getLayoutParams().height;
        this.mKidozWebView = (KidozWebView)this.mRootView.findViewById(R.id.AboutKidozWebView);
        this.mKidozWebView.getSettings().setUseWideViewPort(true);
        this.mKidozWebView.getSettings().setLoadWithOverviewMode(true);
        this.mKidozWebView.getSettings().setSupportZoom(false);
        this.mKidozWebView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                KidozBottomBar.this.mIsNeedToCloseWebViewOnClick = false;
                if (url.startsWith("mailto:")) {
                    Intent mailIntent = new Intent("android.intent.action.SENDTO", Uri.parse((String)url));
                    KidozBottomBar.this.getContext().startActivity(mailIntent);
                } else {
                    view.loadUrl(url);
                }
                return true;
            }
        });
        this.mKidozWebView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                boolean result = false;
                if (event.getAction() == 1) {
                    KidozBottomBar.this.mRootView.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (KidozBottomBar.this.mIsNeedToCloseWebViewOnClick && KidozBottomBar.this.mAboutKidozContainer.getVisibility() == 0) {
                                KidozBottomBar.this.hideAboutView();
                            }
                            KidozBottomBar.this.mIsNeedToCloseWebViewOnClick = true;
                        }
                    }, 150L);
                } else {
                    if (event.getAction() == 2) {
                        KidozBottomBar.this.mIsNeedToCloseWebViewOnClick = false;
                    }
                    if (KidozBottomBar.this.mIsOrientationPortrait) {
                        result = event.getAction() == 2;
                    }
                }
                return result;
            }
        });
        this.mKidozWebView.setLongClickable(true);
        this.mKidozWebView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return true;
            }
        });
        this.mKidozWebView.loadUrl("http://kidoz.net/v3policy/");
        this.mAboutKidozContainer = (FrameLayout)this.mRootView.findViewById(R.id.AboutKidozContainer);
        this.mAboutKidozContainer.setVisibility(4);
        this.mRootView.findViewById(R.id.AboutKidozParentContainer).setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                boolean result = false;
                if (KidozBottomBar.this.mAboutKidozContainer.getVisibility() == 0) {
                    KidozBottomBar.this.hideAboutView();
                    result = true;
                }
                return result;
            }
        });
        this.mRootView.findViewById(R.id.KidozLogoImageView).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                KidozBottomBar.this.mIsNeedToCloseWebViewOnClick = true;
                KidozBottomBar.this.mAboutKidozContainer.setVisibility(0);
                GenAnimator.playPopInFromRightBottom((View)KidozBottomBar.this.mAboutKidozContainer, KidozBottomBar.this.mAboutKidozPivot, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                        KidozBottomBar.this.mAboutKidozContainer.setVisibility(0);
                    }

                    public void onAnimationEnd(Animator animation) {
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
            }
        });
        this.mRootView.findViewById(R.id.ExitAboutKidozButtonImageView).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GenAnimator.clickItemAnimation(v, 100, new GenAnimator.ViewAnimationListener(){

                    @Override
                    public void onAnimationEnd() {
                        KidozBottomBar.this.hideAboutView();
                    }

                    @Override
                    public void onAnimationStart() {
                    }
                });
            }
        });
    }

    public void hideAboutView() {
        GenAnimator.playPopOutToRightBottom((View)this.mAboutKidozContainer, this.mAboutKidozPivot, new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                KidozBottomBar.this.mAboutKidozContainer.setVisibility(4);
                KidozBottomBar.this.mKidozWebView.goBack();
            }

            public void onAnimationCancel(Animator animation) {
                KidozBottomBar.this.mAboutKidozContainer.setVisibility(4);
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    public boolean isAboutViewVisible() {
        return this.mAboutKidozContainer.getVisibility() == 0;
    }

    private void initRootView() {
        this.mRootView = (RelativeLayout)KidozBottomBar.inflate((Context)this.getContext(), (int)R.layout.bottom_bar, null);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -2);
        this.addView((View)this.mRootView, params);
    }

    private void initBackground() {
        int screenMaxSize = Math.max(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false));
        this.mBackgroundImageView = (ImageView)this.mRootView.findViewById(R.id.BottomBarBackground);
        this.mBackgroundImageView.getLayoutParams().width = screenMaxSize;
        this.mBackgroundImageView.getLayoutParams().height = (int)((float)screenMaxSize * 0.061458334f);
    }

    public void setBottomBarBackgroundColor(int color2) {
    }

    public void setImageUri(Uri imageUri) {
    }

    public void setBackgroundURI() {
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mIsOrientationPortrait = this.getContext().getResources().getConfiguration().orientation == 1;
        this.mKidozWebView.scrollTo(0, 0);
    }
}

