/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.analytics;

import android.content.Context;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;
import com.kidoz.sdk.api.analytics.GoogleAnalyticsTracker;
import com.kidoz.sdk.api.analytics.KidozEvent;
import com.kidoz.sdk.api.analytics.KidozEventManager;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.Utils;

public class LogEventHelper {
    public static final String TAG = LogEventHelper.class.getSimpleName();

    public static void logEvent(Context context, String type, String category, String action, String label) {
        LogEventHelper.logGoogleEvent(context, type, category, action, label);
        LogEventHelper.logSDKEvent(context, type, category, action, label);
    }

    private static void logGoogleEvent(Context context, String type, String category, String action, String label) {
        SDKLogger.printDebbugLog(TAG, ">>>logEvent<<<");
        if (context != null) {
            try {
                HitBuilders.EventBuilder eventBuilder = new HitBuilders.EventBuilder();
                GoogleAnalyticsTracker googleAnalyticsTracker = new GoogleAnalyticsTracker(context);
                Tracker tracker = googleAnalyticsTracker.getTracker();
                if (tracker != null) {
                    String referral;
                    if (type != null) {
                        SDKLogger.printDebbugLog(TAG, ">>>logEvent type = " + type);
                        eventBuilder = (HitBuilders.EventBuilder)eventBuilder.setCustomDimension(1, type);
                    }
                    if (category != null) {
                        SDKLogger.printDebbugLog(TAG, ">>>logEvent category = " + category);
                        eventBuilder = eventBuilder.setCategory(category);
                    }
                    if (action != null) {
                        SDKLogger.printDebbugLog(TAG, ">>>logEvent action = " + action);
                        eventBuilder = eventBuilder.setAction(action);
                    }
                    if (label != null) {
                        SDKLogger.printDebbugLog(TAG, ">>>logEvent label = " + label);
                        eventBuilder = eventBuilder.setLabel(label);
                    }
                    if ((referral = Utils.getDeviceReferral(context)) != null) {
                        SDKLogger.printDebbugLog(TAG, ">>>logEvent referral = " + referral);
                        eventBuilder = (HitBuilders.EventBuilder)eventBuilder.setCustomDimension(7, referral);
                    }
                    tracker.send(eventBuilder.build());
                }
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Error when trying to log google analytics: " + ex.getMessage());
            }
        }
    }

    private static void logSDKEvent(Context context, String type, String category, String action, String label) {
        if (context != null) {
            try {
                KidozEvent kidozEvent = new KidozEvent();
                if (type != null) {
                    kidozEvent.addParameterToJsonObject("Type", type);
                }
                if (category != null) {
                    kidozEvent.addParameterToJsonObject("Category", category);
                }
                if (action != null) {
                    kidozEvent.addParameterToJsonObject("Action", action);
                }
                if (label != null) {
                    kidozEvent.addParameterToJsonObject("Label", label);
                }
                KidozEventManager.logEvent(context, kidozEvent);
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Error when trying to log SDK event: " + ex.getMessage());
            }
        }
    }

    public static void logEventForSponsoredContent(Context context, String type, String category, String action, String label, String itemID) {
        LogEventHelper.logGoogleEventForImpression(context, type, category, action, label, itemID);
        LogEventHelper.logSDKEventForImpression(context, type, category, action, label, itemID);
    }

    private static void logGoogleEventForImpression(Context context, String type, String category, String action, String label, String itemID) {
        SDKLogger.printDebbugLog(TAG, ">>>logEvent<<<");
        if (context != null) {
            try {
                HitBuilders.EventBuilder eventBuilder = new HitBuilders.EventBuilder();
                GoogleAnalyticsTracker googleAnalyticsTracker = new GoogleAnalyticsTracker(context);
                Tracker tracker = googleAnalyticsTracker.getTracker();
                if (tracker != null) {
                    String referral;
                    if (type != null) {
                        SDKLogger.printDebbugLog(TAG, ">>>logEvent type = " + type);
                        eventBuilder = (HitBuilders.EventBuilder)eventBuilder.setCustomDimension(1, type);
                    }
                    if (category != null) {
                        SDKLogger.printDebbugLog(TAG, ">>>logEvent category = " + category);
                        eventBuilder = eventBuilder.setCategory(category);
                    }
                    if (action != null) {
                        SDKLogger.printDebbugLog(TAG, ">>>logEvent action = " + action);
                        eventBuilder = eventBuilder.setAction(action);
                    }
                    if (label != null) {
                        SDKLogger.printDebbugLog(TAG, ">>>logEvent label = " + label);
                        eventBuilder = eventBuilder.setLabel(label);
                    }
                    if ((referral = Utils.getDeviceReferral(context)) != null) {
                        SDKLogger.printDebbugLog(TAG, ">>>logEvent referral = " + referral);
                        eventBuilder = (HitBuilders.EventBuilder)eventBuilder.setCustomDimension(7, referral);
                    }
                    if (itemID != null) {
                        SDKLogger.printDebbugLog(TAG, ">>>logEvent itemID = " + itemID);
                        eventBuilder = (HitBuilders.EventBuilder)eventBuilder.setCustomDimension(9, itemID);
                    }
                    tracker.send(eventBuilder.build());
                }
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Error when trying to log google analytics: " + ex.getMessage());
            }
        }
    }

    private static void logSDKEventForImpression(Context context, String type, String category, String action, String label, String itemID) {
        SDKLogger.printDebbugLog(TAG, ">>>EventBuilder <<logGoogleEvent>>");
        if (context != null) {
            try {
                KidozEvent kidozEvent = new KidozEvent();
                if (type != null) {
                    kidozEvent.addParameterToJsonObject("Type", type);
                }
                if (category != null) {
                    kidozEvent.addParameterToJsonObject("Category", category);
                }
                if (action != null) {
                    kidozEvent.addParameterToJsonObject("Action", action);
                }
                if (label != null) {
                    kidozEvent.addParameterToJsonObject("Label", label);
                }
                if (itemID != null) {
                    kidozEvent.addParameterToJsonObject("ItemID", itemID);
                }
                KidozEventManager.logEvent(context, kidozEvent);
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Error when trying to log google analytics: " + ex.getMessage());
            }
        }
    }
}

