/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.ContentLogicLoader;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.enums.UiStyleType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.ui_views.ContentHorizontalPanelView;

public class SliderPanelView
extends RelativeLayout {
    private static final String TAG = SliderPanelView.class.getSimpleName();
    private static final float CONTENT_PANEL_DEFAULT_RATION = 0.25f;
    private Utils.StaticHandler mStaticHandler = new Utils.StaticHandler();
    private RelativeLayout mRootView;
    private RelativeLayout mHandleVisibleContainer;
    private LinearLayout mContentView;
    private LinearLayout mHandleView;
    private boolean mPanelShown = false;
    private boolean mIsAnimating = false;
    private boolean mIsHandleVisible = true;
    private ContentHorizontalPanelView mContentHorizontalPanelView;
    private ContentLogicLoader mContentLogicLoader;
    private int mHandleGravity = 3;
    private int mContentBackgroundColor = 0;
    private int mContentBackgroundResource = -1;
    private int mContentViewHeight = -1;
    private int mHandleViewResourceId = -1;

    public SliderPanelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initPanelView(attrs);
    }

    public SliderPanelView(Context context) {
        super(context);
        this.initPanelView(null);
    }

    public SliderPanelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initPanelView(attrs);
    }

    public void initPanelView(AttributeSet attrs) {
        this.checkAndSetAttributesIfExists(attrs);
        this.initContentLogicLoader();
        this.createSliderViewStructure();
        this.mContentHorizontalPanelView = new ContentHorizontalPanelView(this.getContext());
        this.mContentView.addView((View)this.mContentHorizontalPanelView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.applyAttributesAndInitValues();
        Utils.setOnGlobalLayoutFinishListener(this.getRootView(), new Utils.OnGlobalLayoutFinishedListener(){

            @Override
            public void onLayoutFinished() {
                GenAnimator.playSlideDownAnimation((View)SliderPanelView.this.mRootView, SliderPanelView.this.mContentViewHeight, 0, null, null);
                SliderPanelView.this.mPanelShown = false;
            }
        });
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void checkAndSetAttributesIfExists(AttributeSet attrs) {
        if (this.isInEditMode() || attrs == null) {
            return;
        }
        if (attrs != null) {
            TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.SlidePanelView);
            if (ta != null) {
                this.mContentViewHeight = ta.getDimensionPixelSize(R.styleable.SlidePanelView_panelHeight, -1);
                this.mContentBackgroundColor = ta.getInt(R.styleable.SlidePanelView_panelBackgroundColor, -1);
                this.mContentBackgroundResource = ta.getResourceId(R.styleable.SlidePanelView_panelBackgroundResource, -1);
                this.mHandleViewResourceId = ta.getResourceId(R.styleable.SlidePanelView_panelHandleView, -1);
                String gavityStr = ta.getString(R.styleable.SlidePanelView_panelHandleGravity);
                if (gavityStr != null) {
                    if (gavityStr.equals("left")) {
                        this.mHandleGravity = 3;
                    } else if (gavityStr.equals("right")) {
                        this.mHandleGravity = 5;
                    }
                }
            }
            ta.recycle();
        }
        float density = this.getContext().getResources().getDisplayMetrics().density;
        if (this.mContentViewHeight != -1) {
            this.mContentViewHeight = (int)((float)this.mContentViewHeight * density + 0.5f);
        }
    }

    private void applyAttributesAndInitValues() {
        if (this.mContentBackgroundColor != -1) {
            this.setSliderContentBackgroundColor(this.mContentBackgroundColor);
        }
        if (this.mHandleGravity != -1) {
            this.setGravity(this.mHandleGravity);
        }
        if (this.mContentBackgroundResource != -1) {
            this.setSliderContentBackgroundResource(this.mContentBackgroundResource);
        }
        if (this.mHandleViewResourceId != -1) {
            this.setCustomHandleView(this.findViewById(this.mHandleViewResourceId), this.mHandleGravity);
        } else {
            Button button = new Button(this.getContext());
            button.setText((CharSequence)"TAP");
            this.setCustomHandleView((View)button, this.mHandleGravity);
            this.initTapHandleClickListener((View)button);
        }
    }

    private void createSliderViewStructure() {
        Point point = Utils.getScreenSize(this.getContext());
        int size = Math.max(point.x, point.y);
        if (this.mContentViewHeight == -1) {
            this.mContentViewHeight = (int)((float)size * 0.25f);
        }
        this.mRootView = new RelativeLayout(this.getContext());
        this.mContentView = new LinearLayout(this.getContext());
        this.mContentView.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, this.mContentViewHeight);
        params.addRule(12);
        this.mRootView.addView((View)this.mContentView, (ViewGroup.LayoutParams)params);
        this.mContentView.setVisibility(4);
        this.mHandleVisibleContainer = new RelativeLayout(this.getContext());
        this.mHandleVisibleContainer.setId(Utils.generateViewId());
        params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(2, this.mContentView.getId());
        this.mRootView.addView((View)this.mHandleVisibleContainer, (ViewGroup.LayoutParams)params);
        this.mHandleView = new LinearLayout(this.getContext());
        params = new RelativeLayout.LayoutParams(-2, -2);
        if (this.mHandleGravity == 3) {
            params.addRule(9);
        } else {
            params.addRule(11);
        }
        params.addRule(15);
        this.mHandleVisibleContainer.addView((View)this.mHandleView, (ViewGroup.LayoutParams)params);
        params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(12);
        this.addView((View)this.mRootView, (ViewGroup.LayoutParams)params);
    }

    private void initTapHandleClickListener(View view) {
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!SliderPanelView.this.mIsAnimating) {
                    if (SliderPanelView.this.mPanelShown) {
                        SliderPanelView.this.collapseView();
                    } else {
                        SliderPanelView.this.loadContent();
                        SliderPanelView.this.expandView();
                    }
                }
            }
        });
    }

    private void initContentLogicLoader() {
        this.mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback(){

            @Override
            public void onDataReady(ContentData contentData) {
                if (contentData.isHasContentToShow()) {
                    SliderPanelView.this.mContentHorizontalPanelView.setContent(contentData.getContentDataItems());
                }
            }
        });
    }

    private void loadContent() {
        if (this.mContentHorizontalPanelView != null && this.mContentHorizontalPanelView.isEmpty()) {
            this.mContentLogicLoader.loadContent(this.getContext(), UiStyleType.RELATED_PANEL_STYLE);
        }
    }

    public void expandView() {
        if (this.mContentViewHeight != 0 && !this.mPanelShown) {
            GenAnimator.playSlideUpAnimation((View)this.mRootView, this.mContentViewHeight, 240, (TimeInterpolator)new DecelerateInterpolator(), new Animator.AnimatorListener(){

                public void onAnimationStart(Animator arg0) {
                    SliderPanelView.this.mIsAnimating = true;
                    SliderPanelView.this.mContentView.setVisibility(0);
                }

                public void onAnimationRepeat(Animator arg0) {
                }

                public void onAnimationEnd(Animator arg0) {
                    SliderPanelView.this.mPanelShown = true;
                    SliderPanelView.this.mIsAnimating = false;
                }

                public void onAnimationCancel(Animator arg0) {
                }
            });
        }
    }

    private void collapseView() {
        if (this.mContentViewHeight != 0 && this.mPanelShown) {
            GenAnimator.playSlideDownAnimation((View)this.mRootView, this.mContentViewHeight, 210, (TimeInterpolator)new AccelerateInterpolator(), new Animator.AnimatorListener(){

                public void onAnimationStart(Animator arg0) {
                    SliderPanelView.this.mIsAnimating = true;
                }

                public void onAnimationRepeat(Animator arg0) {
                }

                public void onAnimationEnd(Animator arg0) {
                    SliderPanelView.this.mPanelShown = false;
                    SliderPanelView.this.mIsAnimating = false;
                    SliderPanelView.this.mContentView.setVisibility(4);
                }

                public void onAnimationCancel(Animator arg0) {
                }
            });
        }
    }

    public void hideHandleView() {
        if (this.mIsHandleVisible) {
            if (this.mHandleGravity == 3) {
                GenAnimator.playSlideOutLeftAnimation((View)this.mHandleVisibleContainer, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator arg0) {
                    }

                    public void onAnimationRepeat(Animator arg0) {
                    }

                    public void onAnimationEnd(Animator arg0) {
                        SliderPanelView.this.mHandleView.setVisibility(4);
                        SliderPanelView.this.mIsHandleVisible = false;
                    }

                    public void onAnimationCancel(Animator arg0) {
                    }
                }, 500);
            }
            if (this.mHandleGravity == 5) {
                GenAnimator.playSlideOutRightAnimation((View)this.mHandleVisibleContainer, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator arg0) {
                    }

                    public void onAnimationRepeat(Animator arg0) {
                    }

                    public void onAnimationEnd(Animator arg0) {
                        SliderPanelView.this.mHandleView.setVisibility(4);
                        SliderPanelView.this.mIsHandleVisible = false;
                    }

                    public void onAnimationCancel(Animator arg0) {
                    }
                }, 500);
            }
        }
    }

    public void showHandleView() {
        if (!this.mIsHandleVisible) {
            if (this.mHandleGravity == 3) {
                GenAnimator.playBounceInRightAnimation((View)this.mHandleVisibleContainer, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator arg0) {
                        SliderPanelView.this.mHandleView.setVisibility(0);
                    }

                    public void onAnimationRepeat(Animator arg0) {
                    }

                    public void onAnimationEnd(Animator arg0) {
                        SliderPanelView.this.mIsHandleVisible = true;
                    }

                    public void onAnimationCancel(Animator arg0) {
                    }
                }, 500);
            } else if (this.mHandleGravity == 3) {
                GenAnimator.playBounceInLeftAnimation((View)this.mHandleVisibleContainer, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator arg0) {
                    }

                    public void onAnimationRepeat(Animator arg0) {
                    }

                    public void onAnimationEnd(Animator arg0) {
                        SliderPanelView.this.mHandleView.setVisibility(0);
                        SliderPanelView.this.mIsHandleVisible = true;
                    }

                    public void onAnimationCancel(Animator arg0) {
                    }
                }, 500);
            }
        }
    }

    public void setCustomHandleView(View view, int gravity) {
        if (view != null) {
            this.mHandleView.removeAllViews();
            this.mHandleView.addView(view);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
            if (gravity == 5) {
                params.addRule(11);
            } else {
                params.addRule(9);
            }
            params.addRule(8);
            this.mHandleView.setLayoutParams((ViewGroup.LayoutParams)params);
            this.initTapHandleClickListener(view);
        }
    }

    public void setSliderContentBackgroundColor(int color) {
        if (this.mContentView != null) {
            this.mContentView.setBackgroundColor(color);
        }
    }

    public void setSliderContentBackgroundDrawable(Drawable drawable2) {
        if (this.mContentView != null) {
            if (Build.VERSION.SDK_INT < 16) {
                this.mContentView.setBackgroundDrawable(drawable2);
            } else {
                this.mContentView.setBackground(drawable2);
            }
        }
    }

    public void setSliderContentBackgroundResource(int resource) {
        if (this.mContentView != null) {
            this.mContentView.setBackgroundResource(resource);
        }
    }
}

