/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.support.v4.app.FragmentManager;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.players.video_player.ui.activities.YouTubeActivityWithoutRelated;
import com.kidoz.sdk.api.players.video_player.util.YouTubeUtils;
import com.kidoz.sdk.api.players.web_player.WebPlayerActivity;
import com.kidoz.sdk.api.players.web_player.WebPlayerFragmentDialog;
import com.kidoz.sdk.api.players.web_player.WebPlayerType;
import com.kidoz.sdk.api.structure.ContentItem;
import java.io.Serializable;
import java.util.List;

public class ContentExecutionHandler {
    public static final String TAG = ContentExecutionHandler.class.getSimpleName();

    public static void handleContentItemClick(final Context context, final FragmentManager fragmentManager, final ContentItem contentItem, final int position) {
        switch (contentItem.getContentType()) {
            case GOOGLE_PLAY_APPLICATION: {
                boolean isLockActive;
                boolean bl = isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(context, "PARENTAL_LOCK_ACTIVE_KEY") != null;
                if (isLockActive) {
                    ParentalLockDialog parentalLockDialog = new ParentalLockDialog(context, true);
                    parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener(){

                        @Override
                        public void onPasswordEntered(boolean isPasswordCorrect) {
                            if (isPasswordCorrect) {
                                ContentExecutionHandler.onGooglePlayApp(context, fragmentManager, contentItem, position);
                            } else {
                                EventManager.getInstance().LogEvent(context, EventManager.LOG_NORMAL_LEVEL, null, "SDK", "Incorrect Password", contentItem.getId());
                            }
                        }
                    });
                    parentalLockDialog.show();
                    break;
                }
                ContentExecutionHandler.onGooglePlayApp(context, fragmentManager, contentItem, position);
                break;
            }
            case PROMOTED_PLAY_APPLICATION: {
                boolean isLockActive;
                if (context != null && contentItem != null) {
                    SharedPreferencesUtils.removeSharedPreferencesData(context, "PROMOTED_APP_PACKAGE_NAME");
                    SharedPreferencesUtils.saveSharedPreferencesData(context, "PROMOTED_APP_PACKAGE_NAME", contentItem.getId());
                }
                boolean bl = isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(context, "PARENTAL_LOCK_ACTIVE_KEY") != null;
                if (isLockActive) {
                    ParentalLockDialog parentalLockDialog = new ParentalLockDialog(context, true);
                    parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener(){

                        @Override
                        public void onPasswordEntered(boolean isPasswordCorrect) {
                            if (isPasswordCorrect) {
                                ContentExecutionHandler.onPromotedAppItemClick(context, fragmentManager, contentItem, position);
                            } else {
                                EventManager.getInstance().LogEvent(context, EventManager.LOG_NORMAL_LEVEL, null, "Sponsored Content", "Incorrect Password", contentItem.getId());
                            }
                        }
                    });
                    parentalLockDialog.show();
                    break;
                }
                ContentExecutionHandler.onPromotedAppItemClick(context, fragmentManager, contentItem, position);
                break;
            }
            case WEB_GAME_URL: {
                ContentExecutionHandler.onlineGameItemClick(context, fragmentManager, contentItem, position);
                break;
            }
            case WEBSITE_URL: {
                ContentExecutionHandler.onUrlItemClick(context, fragmentManager, contentItem, position);
                break;
            }
            case YOTUBE_VIDEO: {
                ContentExecutionHandler.onYouTubeVideolItemClick(context, fragmentManager, contentItem, position);
                break;
            }
        }
    }

    protected static void onPromotedAppItemClick(Context context, FragmentManager fragmentManager, ContentItem contentItem, int position) {
        if (contentItem.getData() != null && contentItem.getData().startsWith("market://") || contentItem.getData().startsWith("https://play.google.com") || contentItem.getData().startsWith("http://play.google.com")) {
            try {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)contentItem.getData()));
                List otherApps = context.getPackageManager().queryIntentActivities(intent, 0);
                EventManager.getInstance().logSponsoredContentClickEvent(context, contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position);
                for (ResolveInfo otherApp : otherApps) {
                    if (!otherApp.activityInfo.applicationInfo.packageName.equals("com.android.vending")) continue;
                    ActivityInfo otherAppActivity = otherApp.activityInfo;
                    ComponentName componentName = new ComponentName(otherAppActivity.applicationInfo.packageName, otherAppActivity.name);
                    intent.setFlags(0x10200000);
                    intent.setComponent(componentName);
                    context.startActivity(intent);
                }
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Error when trying to open google play for promoted app: \n" + ex.getMessage());
            }
        } else {
            ContentExecutionHandler.onUrlItemClick(context, fragmentManager, contentItem, position);
        }
    }

    protected static void onGooglePlayApp(Context context, FragmentManager fragmentManager, ContentItem contentItem, int position) {
        EventManager.getInstance().logClickEvent(context, "Feed Click", "Google Play App", contentItem.getId(), position);
        Intent googlePlayIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + contentItem.getId())));
        googlePlayIntent.addFlags(0x10000000);
        googlePlayIntent.addFlags(32768);
        context.startActivity(googlePlayIntent);
    }

    protected static void onlineGameItemClick(Context context, FragmentManager fragmentManager, ContentItem contentItem, int position) {
        EventManager.getInstance().logClickEvent(context, "Feed Click", "Online Game", contentItem.getId(), position);
        if (fragmentManager != null) {
            WebPlayerFragmentDialog webPlayerFragmentDialog = WebPlayerFragmentDialog.newInstance(contentItem, WebPlayerType.ONLINE_GAME);
            webPlayerFragmentDialog.openDialog(fragmentManager);
        } else {
            Intent webPlayerActivity = new Intent(context, WebPlayerActivity.class);
            webPlayerActivity.putExtra("EXTRA_CONTENT_ITEM_KEY", (Serializable)contentItem);
            webPlayerActivity.putExtra("EXTRA_WEB_PLAYER_TYPE_KEY", (Serializable)((Object)WebPlayerType.ONLINE_GAME));
            context.startActivity(webPlayerActivity);
        }
    }

    protected static void onUrlItemClick(Context context, FragmentManager fragmentManager, ContentItem contentItem, int position) {
        EventManager.getInstance().logClickEvent(context, "Feed Click", "URL", contentItem.getId(), position);
        if (fragmentManager != null) {
            WebPlayerType webPlayerType = WebPlayerType.WEB_BROWSER;
            if (contentItem != null && contentItem.getContentType() == ContentType.PROMOTED_PLAY_APPLICATION) {
                webPlayerType = WebPlayerType.EXTERNAL_LINK;
            }
            WebPlayerFragmentDialog webPlayerFragmentDialog = WebPlayerFragmentDialog.newInstance(contentItem, webPlayerType);
            webPlayerFragmentDialog.openDialog(fragmentManager);
        } else {
            Intent webPlayerActivity = new Intent(context, WebPlayerActivity.class);
            webPlayerActivity.putExtra("EXTRA_CONTENT_ITEM_KEY", (Serializable)contentItem);
            webPlayerActivity.putExtra("EXTRA_WEB_PLAYER_TYPE_KEY", (Serializable)((Object)WebPlayerType.WEB_BROWSER));
            context.startActivity(webPlayerActivity);
        }
    }

    protected static void onYouTubeVideolItemClick(Context context, FragmentManager fragmentManager, ContentItem contentItem, int position) {
        if (context != null && contentItem != null && contentItem.getData() != null) {
            EventManager.getInstance().logClickEvent(context, "Feed Click", "Youtube", contentItem.getId(), position);
            Intent youtubeActivity = new Intent(context, YouTubeActivityWithoutRelated.class);
            youtubeActivity.putExtra("INTENT_EXTRA_VIDEO_ID", YouTubeUtils.extractYouTubeVideoIDString(contentItem.getData()));
            youtubeActivity.putExtra("INTENT_EXTRA_VIDEO_NAME", contentItem.getName());
            youtubeActivity.putExtra("INTENT_EXTRA_CONTENT_ITEM_ID", contentItem.getId());
            context.startActivity(youtubeActivity);
        }
    }
}

