/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.events;

import com.kidoz.events.Event;
import com.kidoz.events.EventLogger;
import com.kidoz.sdk.api.analytics.EventsBulk;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class EventBulk {
    private final String TAG = EventsBulk.class.getSimpleName();
    private final String KEY_DEVICE_PARAMS = "DeviceParams";
    private final String KEY_EVENT_PARAMS = "EventParams";
    private final String KEY_ENTRIES = "Entries";
    private JSONObject mDeviceParamsJSONObject;
    private ArrayList<Event> mEventArrayList;

    public void setDeviceParamsJSONObject(JSONObject deviceParamsJSONObject) {
        this.mDeviceParamsJSONObject = deviceParamsJSONObject;
    }

    public JSONObject getDeviceParamsJSONObject() {
        return this.mDeviceParamsJSONObject;
    }

    public void setEventArrayList(ArrayList<Event> eventArrayList) {
        this.mEventArrayList = eventArrayList;
    }

    public ArrayList<Event> getEventArrayList() {
        return this.mEventArrayList;
    }

    private String convertToJson() {
        String result = null;
        if (this.mDeviceParamsJSONObject != null && this.mEventArrayList != null && this.mEventArrayList.size() > 0) {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("DeviceParams", (Object)this.mDeviceParamsJSONObject);
                JSONArray jSONArray = new JSONArray();
                for (Event nextKidozEvent : this.mEventArrayList) {
                    JSONObject nextJsonObject = new JSONObject();
                    nextJsonObject.put("EventParams", (Object)nextKidozEvent.getJSONObject());
                    jSONArray.put((Object)nextJsonObject);
                }
                jSONObject.put("Entries", (Object)jSONArray);
                result = jSONObject.toString();
            }
            catch (Exception ex) {
                EventLogger.printErrorLog(this.TAG, "Error when trying to create JSONObject from Bulk : " + ex.getMessage());
            }
        }
        return result;
    }

    public String toString() {
        return this.convertToJson();
    }
}

