package com.kidoz.sdk.api.structure;

import android.content.Context;

import com.kidoz.sdk.api.general.utils.SDKLogger;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.HashMap;

/**
 * Created by roni on 8/23/2015.
 */
public class LockIconData
{
    private final String TAG = LockIconData.class.getSimpleName();

    private String mName;
    private String mIconURL;

    public LockIconData()
    {

    }

    public LockIconData(JSONArray jSONArray, HashMap<String, Integer> keys)
    {
        if (jSONArray != null && keys != null)
        {
            try
            {
                mName = jSONArray.getString(keys.get("name"));
                mIconURL = jSONArray.getString(keys.get("icon"));
            }
            catch (Exception ex)
            {
                SDKLogger.printErrorLog(TAG, "Error creating lock icon data: " + ex.getMessage());
            }
        }
    }

    public LockIconData(Context context, JSONObject jSONObject)
    {
        if (jSONObject != null)
        {
            try
            {
                if (jSONObject.has("LockIconOnFS") == true && jSONObject.isNull("LockIconOnFS") == false)
                {
                    mIconURL = jSONObject.getString("LockIconOnFS");
                }
                if (jSONObject.has("LockIconName") == true && jSONObject.isNull("LockIconName") == false)
                {
                    mName = jSONObject.getString("LockIconName");
                }
            }
            catch (Exception ex)
            {
                SDKLogger.printErrorLog(TAG, "Error creating lock icon data: " + ex.getMessage());
            }
        }
    }

    public void setIconURL(String iconURL)
    {
        mIconURL = iconURL;
    }

    public String getIconURL()
    {
        return mIconURL;
    }

    public void setName(String name)
    {
        mName = name;
    }

    public String getName()
    {
        return mName;
    }
}
