package com.kidoz.sdk.api.players.web_player;

import android.app.Dialog;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.structure.ContentItem;



/**
 * Created by orikam on 7/15/15.
 */
public class WebPlayerFragmentDialog extends DialogFragment
{

    private static final String TAG = WebPlayerFragmentDialog.class.getSimpleName();

    private ContentItem mContentItem;
    private WebPlayerType mWebPlayerType;
    private WebPlayerView mWebPlayerView;

    private int mCurrentOrientationState;

    private long mEventID;

    private static final int mWebPlayerResourceID = 1;


    public static WebPlayerFragmentDialog newInstance(ContentItem contentItem, WebPlayerType webPlayerType)
    {
        WebPlayerFragmentDialog f = new WebPlayerFragmentDialog();
        f.mContentItem = contentItem;
        f.mWebPlayerType = webPlayerType;
        return f;
    }

    @Override public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);

        int style = DialogFragment.STYLE_NO_FRAME;
        int theme = android.R.style.Theme_Black_NoTitleBar_Fullscreen;
        if (mWebPlayerType != null && mWebPlayerType == WebPlayerType.EXTERNAL_LINK)
        {
            theme = android.R.style.Theme_Translucent_NoTitleBar_Fullscreen;
        }
        setStyle(style, theme);

        //getWindow().requestFeature(Window.FEATURE_PROGRESS);
        setCancelable(true);
    }

    @Override public Dialog onCreateDialog(Bundle savedInstanceState)
    {
        mCurrentOrientationState = getResources().getConfiguration().orientation;
        getActivity().setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR);

        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.getWindow().getAttributes().windowAnimations = R.style.FullViewInOutAnimation;
        return dialog;
    }

    @Override public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState)
    {
        mWebPlayerView = new WebPlayerView(getActivity(), mWebPlayerType);
        mWebPlayerView.loadWebUrl(mContentItem.getData(), mContentItem.getId(), mContentItem.getName());

        mWebPlayerView.setOnCloseButtonClickListenr(new View.OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                closeDialog(getFragmentManager());
            }
        });

        mWebPlayerView.setOnRemoveViewRequestListener(new WebPlayerView.IOnRemoveViewRequestListener()
        {
            @Override
            public void onRemoveView()
            {
                closeDialog(getFragmentManager());
            }
        });
        return mWebPlayerView;
    }


    /**
     * Show dialog view Set
     *
     * @param fragmentManager support fragment manager
     */
    public void openDialog(final FragmentManager fragmentManager)
    {
        new Handler().post(new Runnable()
        {
            public void run()
            {
                try
                {
                    FragmentTransaction ft = fragmentManager.beginTransaction();
                    ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                    Fragment prev = fragmentManager.findFragmentByTag(TAG);
                    if (prev != null)
                    {
                        ft.remove(prev);
                    } else
                    {
                        if (isAdded() == false)
                        {
                            ft.addToBackStack(null);
                            show(fragmentManager, TAG);
                        }
                    }
                } catch (Exception ex)
                {
                    SDKLogger.printDebbugLog(TAG, "Error when trying to open dialog: " + ex.getMessage());
                }
            }
        });
    }

    /**
     * Dismiss dialog view
     *
     * @param fragmentManager support fragment manager
     */
    public void closeDialog(FragmentManager fragmentManager)
    {
        FragmentTransaction ft = fragmentManager.beginTransaction();
        ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_CLOSE);
        Fragment prev = fragmentManager.findFragmentByTag(TAG);
        if (prev != null)
        {
            ft.remove(prev);
        }

        if (this != null)
        {
            this.dismissAllowingStateLoss();
        }
    }

    @Override public void onDetach()
    {
        super.onDetach();

        getActivity().setRequestedOrientation(mCurrentOrientationState);

        if (mWebPlayerView != null)
        {
            try
            {
                mWebPlayerView.releseAndcloseView();
            }
            catch (Exception ex)
            {
                SDKLogger.printDebbugLog(TAG, "Error when trying to onDetach: " + ex.getMessage());
            }
        }
    }

    @Override public void onResume()
    {
        super.onResume();

        String activityName="";
        String action = "";
        switch (mWebPlayerType)
        {
            case EXTERNAL_LINK:
                activityName = "Web Player External Link";
                action = EventParameters.ACTION_EXTERNAL_LINK_VIEW;
                break;
            case ONLINE_GAME:
                activityName = "Web Player Online Game";
                action = EventParameters.ACTION_GAME_VIEW;
                break;
            case WEB_BROWSER:
                activityName = "Web Player Web Browser";
                action = EventParameters.ACTION_WEBSITE_VIEW;
                break;
        }
        mEventID = EventManager.getInstance().activityStart(this.getContext(),EventManager.LOG_CRITICAL_LEVEL,activityName);
        EventManager.getInstance().logEventWithDuration(this.getContext(), EventManager.LOG_NORMAL_LEVEL, mWebPlayerResourceID,
                EventManager.LOG_CLOSE_RESOURCE_LEVEL, EventParameters.CATEGORY_WEB_PLAYER,
                action, mContentItem.getName(), mContentItem.getId());
    }

    @Override public void onPause()
    {
        EventManager.getInstance().activityEnd(this.getContext(), EventManager.LOG_CRITICAL_LEVEL, mEventID);
        EventManager.getInstance().logEventWithDurationEnd(this.getContext(), mWebPlayerResourceID);
        super.onPause();
    }


}
