package com.kidoz.sdk.api.players.web_player;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.view.View;
import android.view.WindowManager;

/**
 * Created by orikam on 7/15/15.
 */

public class BaseDialog extends Dialog
{

    private boolean mIsHideImmersive;
    public BaseDialog(Context context)
    {
        super(context);
    }

    public BaseDialog(Context context, boolean cancelable, OnCancelListener cancelListener)
    {
        super(context, cancelable, cancelListener);
    }

    public BaseDialog(Context context, int theme)
    {
        super(context, theme);
    }

    protected void initDialog()
    {
       // setKitKatDimBarsListener();

        //getWindow().setFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE, WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE);
    }

    protected void openDialog()
    {

        show();
        getWindow().clearFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE);
    }

    protected void closeDialog()
    {
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE, WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE);
        dismiss();
    }

    @Override
    public void onDetachedFromWindow() {
        // TODO Auto-generated method stub
        super.onDetachedFromWindow();


        getWindow().setFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE, WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE);
    }

    @SuppressLint("NewApi")
    private void setKitKatDimBarsListener()
    {

    }

    @Override
    public void onAttachedToWindow() {
        // TODO Auto-generated method stub
        super.onAttachedToWindow();

        getWindow().clearFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE);
        trigerImmersiveUi();
    }


    public interface IOnDismissRequestListener {
        public void onRequestDissmis();
    }


    private void trigerImmersiveUi() {
        if (android.os.Build.VERSION.SDK_INT >= 19)
        {
            //oooOri todo: check OnSystemUiVisibilityChangeListener
//            getWindow().getDecorView().setOnSystemUiVisibilityChangeListener(new OnSystemUiVisibilityChangeListener()
//            {
//                @Override
//                public void onSystemUiVisibilityChange(int visibility)
//                {
//                    if(mIsHideImmersive == true) {
//                        getWindow().getDecorView().setSystemUiVisibility(
//                                View.SYSTEM_UI_FLAG_LAYOUT_STABLE
//                                        | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
//                                        | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
//                                        | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION // hide nav bar
//                                        | View.SYSTEM_UI_FLAG_FULLSCREEN // hide status bar
//                                        | View.SYSTEM_UI_FLAG_IMMERSIVE);
//                    }
//				    /*else {
//						getWindow().getDecorView().setSystemUiVisibility(
//					            View.SYSTEM_UI_FLAG_LAYOUT_STABLE
//					            | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
//					            | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN);
//				    }	*/
//                }
//            });

            if(mIsHideImmersive == true) {
                getWindow().getDecorView().setSystemUiVisibility(
                        View.SYSTEM_UI_FLAG_LAYOUT_STABLE
                                | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
                                | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                                | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION // hide nav bar
                                | View.SYSTEM_UI_FLAG_FULLSCREEN // hide status bar
                                | View.SYSTEM_UI_FLAG_IMMERSIVE);
            }
		   /* else {
				getWindow().getDecorView().setSystemUiVisibility(
			            View.SYSTEM_UI_FLAG_LAYOUT_STABLE
			            | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
			            | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN);
		    }	*/
        }
    }

    public void setHideImmersive(boolean hide) {
        mIsHideImmersive = hide;
    }
}
