package com.kidoz.sdk.api.players.video_player.util;

import android.content.Context;
import android.graphics.Typeface;

import java.util.HashMap;

/**
 * Created by roni on 7/15/2015.
 */
public class FontUtils
{
    private static HashMap<String, Typeface> sFontHashMap = new HashMap<String, Typeface>();

    public static Typeface getFont(Context context, String fontAssetPath)
    {
        Typeface result = null;
        if (sFontHashMap == null)
        {
            sFontHashMap = new HashMap<String, Typeface>();
        }

        if (sFontHashMap.containsKey(fontAssetPath) && sFontHashMap.get(fontAssetPath) != null)
        {
            result = sFontHashMap.get(fontAssetPath);
        }
        else
        {
            Typeface typeface = Typeface.createFromAsset(context.getAssets(), fontAssetPath);
            if (typeface != null)
            {
                sFontHashMap.put(fontAssetPath, typeface);
            }
            result = typeface;
        }
        return result;
    }

    public enum FONT_TYPE
    {
        DOSIS_MEDIUM("font/dosis/Dosis-Medium.ttf"), DOSIS_BOLD("font/dosis/Dosis-Bold.ttf");

        private String mValue;

        private FONT_TYPE(String value)
        {
            mValue = value;
        }

        public String getValue()
        {
            return mValue;
        }
    }
}
