package com.kidoz.sdk.api.players.video_player.util;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;

/**
 * Created by roni on 7/7/2015.
 */
public class AnimationsUtils
{
    public static final int ENTER_ANIMATION_TIME = 100;
    public static final int EXIT_ANIMATION_TIME = 150;
    public static final int TOUCH_DELAY_ANIMATION_TIME = 2500;

    public static void animateClick(final View view, final Animator.AnimatorListener animatorListener)
    {
        if (view.getMeasuredHeight() == 0 || view.getMeasuredWidth() == 0)
        {
            int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(ViewGroup.LayoutParams.MATCH_PARENT, View.MeasureSpec.UNSPECIFIED);
            int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(ViewGroup.LayoutParams.WRAP_CONTENT, View.MeasureSpec.UNSPECIFIED);
            view.measure(widthMeasureSpec, heightMeasureSpec);
        }

        AnimatorSet animatorSetScaleDown = new AnimatorSet();
        animatorSetScaleDown.playTogether(ObjectAnimator.ofFloat(view, "scaleY", 1, 0.85f), ObjectAnimator.ofFloat(view, "scaleX", 1, 0.85f));
        animatorSetScaleDown.setDuration(ENTER_ANIMATION_TIME);
        animatorSetScaleDown.setInterpolator(new DecelerateInterpolator());
        animatorSetScaleDown.addListener(new Animator.AnimatorListener()
        {
            @Override public void onAnimationStart(Animator animation)
            {

            }

            @Override public void onAnimationEnd(Animator animation)
            {
                AnimatorSet animatorSetScaleUp = new AnimatorSet();
                animatorSetScaleUp.playTogether(ObjectAnimator.ofFloat(view, "scaleY", 0.85f, 1), ObjectAnimator.ofFloat(view, "scaleX", 0.85f, 1));
                animatorSetScaleUp.setDuration(EXIT_ANIMATION_TIME);
                animatorSetScaleUp.setInterpolator(new AccelerateInterpolator());
                if (animatorListener != null)
                {
                    animatorSetScaleUp.addListener(animatorListener);
                }
                animatorSetScaleUp.start();
            }

            @Override public void onAnimationCancel(Animator animation)
            {

            }

            @Override public void onAnimationRepeat(Animator animation)
            {

            }
        });
        animatorSetScaleDown.start();
    }

    public static void animateFade(final View view, boolean isFadeIn, long duration, final Animator.AnimatorListener animatorListener)
    {
        AnimatorSet animatorSet = new AnimatorSet();
        if (isFadeIn == true)
        {
            animatorSet.playTogether(ObjectAnimator.ofFloat(view, "alpha", 0, 1));
            animatorSet.setInterpolator(new DecelerateInterpolator());
            animatorSet.setDuration(duration);
            animatorSet.addListener(animatorListener);
            animatorSet.start();
        }
        else
        {
            animatorSet.playTogether(ObjectAnimator.ofFloat(view, "alpha", 1, 0));
            animatorSet.setInterpolator(new AccelerateInterpolator());
            animatorSet.setDuration(duration);
            animatorSet.addListener(animatorListener);
            animatorSet.start();
        }
    }

    public static void animateTopBarSlideIn(final View view)
    {
        view.animate().translationY(0).setDuration(ENTER_ANIMATION_TIME).setInterpolator(new DecelerateInterpolator());
    }

    public static void animateTopBarSlideOut(final View view)
    {
        view.animate().translationY(-1 * view.getMeasuredHeight()).setDuration(EXIT_ANIMATION_TIME).setInterpolator(new AccelerateInterpolator());
    }

    public static void animateRelatedContainerLandscapeSlideIn(final View view)
    {
        view.animate().translationY(0).setDuration(ENTER_ANIMATION_TIME).setInterpolator(new DecelerateInterpolator());
    }

    public static void animateRelatedContainerLandscapeSlideOut(final View view, int translateDistance)
    {
        view.animate().translationY(translateDistance).setDuration(EXIT_ANIMATION_TIME).setInterpolator(new AccelerateInterpolator());
    }

    public static void animateRotate(View view)
    {
        RotateAnimation rotateAnimation = new RotateAnimation(0, 360, Animation.RELATIVE_TO_SELF, 0.5f, Animation.RELATIVE_TO_SELF, 0.5f);
        rotateAnimation.setDuration(EXIT_ANIMATION_TIME * 3);
        rotateAnimation.setRepeatCount(Animation.INFINITE);
        rotateAnimation.setInterpolator(new LinearInterpolator());
        view.startAnimation(rotateAnimation);
    }
}
