package com.kidoz.sdk.api.players.video_player.ui.dialogs;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

import com.google.android.youtube.player.YouTubeInitializationResult;
import com.google.android.youtube.player.YouTubePlayer;
import com.google.android.youtube.player.YouTubePlayerSupportFragment;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.players.video_player.ui.custom_views.InterceptableTouchEventRelativeLayout;


/**
 * Created by roni on 7/23/2015.
 */
public class VideoPlayerDialogFragment extends DialogFragment implements YouTubePlayer.OnInitializedListener
{
    public static final String TAG = VideoPlayerDialogFragment.class.getSimpleName();
    private InterceptableTouchEventRelativeLayout mRootView;
    private FrameLayout mFragmentContainer;
    private YouTubePlayerSupportFragment mYouTubePlayerSupportFragment;
    private YouTubePlayer mYouTubePlayer;
    private String mVideoID;

    public void setVideoID(String videoID)
    {
        mVideoID = videoID;
    }

    public static VideoPlayerDialogFragment newInstance()
    {
        return new VideoPlayerDialogFragment();
    }

    private void initFragmentDialog()
    {
        setStyle(DialogFragment.STYLE_NO_FRAME, android.R.style.Theme_Translucent_NoTitleBar_Fullscreen);
        setCancelable(false);
        mRootView = new InterceptableTouchEventRelativeLayout(getActivity());
        mRootView.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
        mRootView.setIsInterceptTouchEvent(true);

        mFragmentContainer = new FrameLayout(getActivity());
        mFragmentContainer.setLayoutParams(new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT));
        mRootView.addView(mFragmentContainer);

        mYouTubePlayerSupportFragment = YouTubePlayerSupportFragment.newInstance();
        mYouTubePlayerSupportFragment.initialize("AIzaSyCO0ANo6o7l286UdA4LHBvzTZ6Aza79lTc", this);
    }

    @Override public void onInitializationSuccess(YouTubePlayer.Provider provider, YouTubePlayer youTubePlayer, boolean restored)
    {
        mYouTubePlayer = youTubePlayer;
        mYouTubePlayer.setPlayerStyle(YouTubePlayer.PlayerStyle.MINIMAL);
        if (restored == false && mVideoID != null)
        {
            mYouTubePlayer.loadVideo(mVideoID);
        }
    }

    @Override public void onInitializationFailure(YouTubePlayer.Provider provider, YouTubeInitializationResult result)
    {
        mYouTubePlayer = null;
    }


    @Nullable @Override public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState)
    {
        //        initFragmentDialog();
        View rootView = inflater.inflate(R.layout.youtube_player_activity, container, false);

        mYouTubePlayerSupportFragment.initialize("AIzaSyCO0ANo6o7l286UdA4LHBvzTZ6Aza79lTc", this);

        return rootView;
    }

    //    @NonNull @Override public Dialog onCreateDialog(Bundle savedInstanceState)
    //    {
    //        return new Dialog(getActivity(), android.R.style.Theme_Translucent_NoTitleBar_Fullscreen)
    //        {
    //            @Override public void onBackPressed()
    //            {
    //                removeVideoFragment();
    //                dismiss();
    //            }
    //        };
    //    }

    @Override public void onResume()
    {
        super.onResume();
        if (mYouTubePlayer != null)
        {
            mYouTubePlayer.play();
        }
    }

    @Override public void onPause()
    {
        super.onPause();
        if (mYouTubePlayer != null)
        {
            mYouTubePlayer.pause();
        }
    }

    @Override public void onDestroy()
    {
        super.onDestroy();
        if (mYouTubePlayer != null)
        {
            mYouTubePlayer.pause();
            mYouTubePlayer.release();
            mYouTubePlayer = null;
        }
    }
}
