package com.kidoz.sdk.api.players.video_player.ui.custom_views;

import android.animation.Animator;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.Rect;
import android.os.Handler;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.general.custom_views.KidozTopBar;
import com.kidoz.sdk.api.players.video_player.util.AnimationsUtils;
import com.kidoz.sdk.api.players.video_player.util.ScreenUtils;

import java.util.ArrayList;

/**
 * Created by roni on 7/8/2015.
 */
public class VideoPlayerTopBar extends RelativeLayout
{
    //    public static final float TOP_BAR_HEIGHT_PERCENTAGE = 0.057f;
    private View mRootView;
    private TextView mTitleTextView;
    private TextView mNumberOfLikesTextView;
    private ImageView mLikeIndicationImageView;
    private VideoPlayerTopBarListener mVideoPlayerTopBarListener;
    private Handler mHandler;
    private ArrayList<View> mTopBarViewsArrayList;

    @Override protected void onConfigurationChanged(Configuration newConfig)
    {
        super.onConfigurationChanged(newConfig);
        if (getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT)
        {
            mHandler.removeCallbacksAndMessages(null);
        }
    }

    public VideoPlayerTopBar(Context context)
    {
        super(context);
        initView();
    }

    public VideoPlayerTopBar(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        initView();
    }

    private void initView()
    {
//        mTopBarViewsArrayList = new ArrayList<View>();
//        mHandler = new Handler();
//        mRootView = inflate(getContext(), R.layout.video_player_top_bar, null);
//
//        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
//        mRootView.setLayoutParams(params);
//        addView(mRootView);
//        mTitleTextView = (TextView) mRootView.findViewById(R.id.TopBarTitleTextView);
//        mTitleTextView.setTextColor(Color.WHITE);
//        mTitleTextView.setShadowLayer(1.1f, 1, 1, Color.DKGRAY);
//        mTitleTextView.setTextSize(TypedValue.COMPLEX_UNIT_SP, getTitleTextSizeByScreenLayout(getContext()));
//        mTitleTextView.setEllipsize(TextUtils.TruncateAt.END);

//        int screenMaxSize = Math.max(ScreenUtils.getScreenSize(getContext(), true), (ScreenUtils.getScreenSize(getContext(), false)));
//        View exitButtonContainer = mRootView.findViewById(R.id.BackButtonContainerFrameLayout);
//        exitButtonContainer.getLayoutParams().height = (int) (screenMaxSize * KidozTopBar.BACKGROUND_RATIO);
//        exitButtonContainer.getLayoutParams().width = exitButtonContainer.getLayoutParams().height;

//        View LockIconContainer = mRootView.findViewById(R.id.LockIconContainerFrameLayout);
//        LockIconContainer.getLayoutParams().height = (int) (screenMaxSize * KidozTopBar.BACKGROUND_RATIO);
//        LockIconContainer.getLayoutParams().width = LockIconContainer.getLayoutParams().height;
//        LockIconContainer.setVisibility(View.INVISIBLE);

        // Set correct icon size
//        int size = (int)(screenMaxSize * KidozTopBar.BACKGROUND_RATIO * KidozTopBar.TOP_ICONS_RELATIVE_SIZE);
//        ImageView closeBtnImgRes = (ImageView) mRootView.findViewById(R.id.BackButtonImageView);
//        closeBtnImgRes.getLayoutParams().height = size;
//        closeBtnImgRes.getLayoutParams().width = size;
//        closeBtnImgRes.setImageResource(R.drawable.inner_back_button);

//        ImageView parentalBtnImgRes = (ImageView) mRootView.findViewById(R.id.parentalImageView);
//        parentalBtnImgRes.getLayoutParams().height = size;
//        parentalBtnImgRes.getLayoutParams().width = size;

//        mRootView.findViewById(R.id.BackButtonContainerFrameLayout).setOnClickListener(new View.OnClickListener()
//        {
//            @Override public void onClick(View v)
//            {
//                View viewToAnimate = mRootView.findViewById(R.id.BackButtonImageView);
//                AnimationsUtils.animateClick(viewToAnimate, new Animator.AnimatorListener()
//                {
//                    @Override public void onAnimationStart(Animator animation)
//                    {
//
//                    }
//
//                    @Override public void onAnimationEnd(Animator animation)
//                    {
//                        if (mVideoPlayerTopBarListener != null)
//                        {
//                            mVideoPlayerTopBarListener.onBackPressed();
//                        }
//                    }
//
//                    @Override public void onAnimationCancel(Animator animation)
//                    {
//
//                    }
//
//                    @Override public void onAnimationRepeat(Animator animation)
//                    {
//
//                    }
//                });
//            }
//        });

//        mRootView.findViewById(R.id.LikeButtonContainerFrameLayout).setOnClickListener(new View.OnClickListener()
        //        {
        //            @Override public void onClick(View v)
        //            {
//                View viewToAnimate = mRootView.findViewById(R.id.LikeButtonImageView);
//                AnimationsUtils.animateClick(viewToAnimate, new Animator.AnimatorListener()
//                {
//                    @Override public void onAnimationStart(Animator animation)
//                    {
//
//                    }
//
//                    @Override public void onAnimationEnd(Animator animation)
//                    {
//                        if (mVideoPlayerTopBarListener != null)
//                        {
//                            mVideoPlayerTopBarListener.onLikeClicked();
//                        }
//                    }
//
//                    @Override public void onAnimationCancel(Animator animation)
//                    {
//
//                    }
//
//                    @Override public void onAnimationRepeat(Animator animation)
//                    {
//
//                    }
//                });
//            }
//        });

//        mRootView.findViewById(R.id.InfoButtonContainerFrameLayout).setOnClickListener(new View.OnClickListener()
//        {
//            @Override public void onClick(View v)
//            {
//                View viewToAnimate = mRootView.findViewById(R.id.InfoButtonImageView);
//                AnimationsUtils.animateClick(viewToAnimate, new Animator.AnimatorListener()
//                {
//                    @Override public void onAnimationStart(Animator animation)
//                    {
//
//                    }
//
//                    @Override public void onAnimationEnd(Animator animation)
//                    {
//                        if (mVideoPlayerTopBarListener != null)
//                        {
//                            mVideoPlayerTopBarListener.onInfoClicked();
//                        }
//                    }
//
//                    @Override public void onAnimationCancel(Animator animation)
//                    {
//
//                    }
//
//                    @Override public void onAnimationRepeat(Animator animation)
//                    {
//
//                    }
//                });
//            }
//        });

//        mTopBarViewsArrayList.add(mRootView.findViewById(R.id.BackButtonContainerFrameLayout));
//        mTopBarViewsArrayList.add(mRootView.findViewById(R.id.LikeButtonContainerFrameLayout));
//        mTopBarViewsArrayList.add(mRootView.findViewById(R.id.InfoButtonContainerFrameLayout));

        initBackground();
    }

    private void initBackground()
    {
        int screenMaxSize = Math.max(ScreenUtils.getScreenSize(getContext(), true), (ScreenUtils.getScreenSize(getContext(), false)));
        View backgroundMainView = mRootView.findViewById(R.id.MainBackground);
        backgroundMainView.getLayoutParams().height = (int) (screenMaxSize * KidozTopBar.BACKGROUND_RATIO);
    }

    public void setVideoPlayerTopBarListener(VideoPlayerTopBarListener videoPlayerTopBarListener)
    {
        mVideoPlayerTopBarListener = videoPlayerTopBarListener;
    }

    public void setTopBarTitle(String title)
    {
        if (mTitleTextView != null)
        {
            mTitleTextView.setText(title);
        }
    }

    public void setNumberOfLikesTextView(String numberOfLikes)
    {
        if (mNumberOfLikesTextView != null)
        {
            mNumberOfLikesTextView.setText(numberOfLikes);
        }
    }

    public void setLikeIndicationStatus(boolean isLiked)
    {
        if (mLikeIndicationImageView != null)
        {
            mLikeIndicationImageView.setSelected(isLiked);
        }
    }

    public void animateEnter()
    {
        if (getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE)
        {
            AnimationsUtils.animateTopBarSlideIn(this);
        }
    }

    public void animateExit()
    {
        if (getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE)
        {
            AnimationsUtils.animateTopBarSlideOut(this);
        }
    }


    public interface VideoPlayerTopBarListener
    {
        public void onBackPressed();

        public void onLikeClicked();

        public void onInfoClicked();

    }

    public void performClickIfNeeded(int x, int y)
    {
        if (mTopBarViewsArrayList != null && mTopBarViewsArrayList.isEmpty() == false)
        {
            for (View nextView : mTopBarViewsArrayList)
            {
                if (nextView != null && nextView.getVisibility() == View.VISIBLE)
                {
                    int[] locationOnScreen = new int[2];
                    nextView.getLocationOnScreen(locationOnScreen);
                    int width = nextView.getWidth();
                    int height = nextView.getHeight();
                    Rect rect = new Rect(locationOnScreen[0], locationOnScreen[1], locationOnScreen[0] + width, locationOnScreen[1] + height);
                    if (rect.contains(x, y))
                    {
                        nextView.performClick();
                        break;
                    }
                }
            }
        }
    }

    private static int getTitleTextSizeByScreenLayout(Context context)
    {

        int size = 17;
        int screenLayout = context.getResources().getConfiguration().screenLayout;
        screenLayout &= Configuration.SCREENLAYOUT_SIZE_MASK;

        switch (screenLayout)
        {
            case Configuration.SCREENLAYOUT_SIZE_SMALL:
            {
                size = 15;
                break;
            }

            case Configuration.SCREENLAYOUT_SIZE_NORMAL:
            {
                size = 18;
                break;
            }

            case Configuration.SCREENLAYOUT_SIZE_LARGE:
            {
                size = 23;
                break;
            }

            case Configuration.SCREENLAYOUT_SIZE_XLARGE:
            {
                size = 27;
                break;
            }
        }
        return size;
    }
}
