package com.kidoz.sdk.api.players.video_player.ui.custom_views;

import android.animation.Animator;
import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;


import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.players.video_player.util.AnimationsUtils;
import com.kidoz.sdk.api.players.video_player.util.ScreenUtils;

import java.util.Formatter;
import java.util.Locale;


/**
 * Created by roni on 7/13/2015.
 */
public class SeekBarController extends RelativeLayout
{
    private final String TAG = SeekBarController.class.getSimpleName();
    public static final int SEEK_BAR_MAX_PROGRESS_VALUE = 100;
    private final int UPDATE_PROGRESS = 1;

    private Activity mActivity;
    private View mRootView;
    private SeekBar mSeekBar;
    private RotateVideoButton mRotateVideoButton;
    private TextView mCurrentTimeTextView;
    private TextView mTotalTimeTextView;
    private StringBuilder mStringBuilder;
    private Formatter mFormatter;
    private SeekBarHandler mSeekBarHandler;
    private SeekBar.OnSeekBarChangeListener mOnSeekBarChangeListener;
    private SeekBarControllerListener mSeekBarControllerListener;

    public SeekBarController(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        initView();
    }

    private void initView()
    {
        mSeekBarHandler = new SeekBarHandler();
        mStringBuilder = new StringBuilder();
        mFormatter = new Formatter(mStringBuilder, Locale.getDefault());
        mRootView = inflate(getContext(), R.layout.seek_bar_layout, null);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mRootView.setLayoutParams(params);
        addView(mRootView);
        initSeekBar();
        initTimeTextView();
        initRotateVideoButton();
    }

    private void initTimeTextView()
    {
        mCurrentTimeTextView = (TextView) mRootView.findViewById(R.id.CurrentTimeTextView);
        mTotalTimeTextView = (TextView) mRootView.findViewById(R.id.TotalTimeTextView);

        mCurrentTimeTextView.setText(convertTime(0));
        mTotalTimeTextView.setText(convertTime(0));
    }

    private void initRotateVideoButton()
    {
        mRotateVideoButton = (RotateVideoButton) mRootView.findViewById(R.id.RotateVideoButton);
        mRotateVideoButton.setOnClickListener(new OnClickListener()
        {
            @Override
            public void onClick(View view)
            {
                AnimationsUtils.animateClick(view, new Animator.AnimatorListener()
                {
                    @Override public void onAnimationStart(Animator animation)
                    {

                    }

                    @Override public void onAnimationEnd(Animator animation)
                    {
                        if (mActivity != null)
                        {
                            if (mRotateVideoButton.getIsOpenInFullScreen() == true)
                            {
                                ScreenUtils.setScreenOrientation((Activity) mActivity, ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
                            }
                            else
                            {
                                ScreenUtils.setScreenOrientation((Activity) mActivity, ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
                            }
                        }
                    }

                    @Override public void onAnimationCancel(Animator animation)
                    {

                    }

                    @Override public void onAnimationRepeat(Animator animation)
                    {

                    }
                });
            }
        });
    }

    private void initSeekBar()
    {
        mSeekBar = (SeekBar) mRootView.findViewById(R.id.SeekBarController);
        mSeekBar.setMax(SEEK_BAR_MAX_PROGRESS_VALUE);
    }

    public void setActivity(Activity activity)
    {
        mActivity = activity;
    }

    public void setOnSeekBarChangeListener(SeekBar.OnSeekBarChangeListener onSeekBarChangeListener)
    {
        mOnSeekBarChangeListener = onSeekBarChangeListener;
        mSeekBar.setOnSeekBarChangeListener(mOnSeekBarChangeListener);
    }

    public void updateDuration(long currentTimeInMilliseconds, long totalTimeInMilliseconds)
    {
        if (totalTimeInMilliseconds > 0)
        {
            float currentProgress = (float) currentTimeInMilliseconds / (float) totalTimeInMilliseconds * SEEK_BAR_MAX_PROGRESS_VALUE;
            mSeekBar.setProgress((int) currentProgress);
        }
        mCurrentTimeTextView.setText(convertTime(currentTimeInMilliseconds));
        mTotalTimeTextView.setText(convertTime(totalTimeInMilliseconds));
    }

    public void animateEnter()
    {
        mSeekBarHandler.sendEmptyMessage(UPDATE_PROGRESS);
        AnimationsUtils.animateRelatedContainerLandscapeSlideIn(this);
    }

    public void animateExit()
    {
        AnimationsUtils.animateRelatedContainerLandscapeSlideOut(this, getMeasuredHeight());
        mSeekBarHandler.removeCallbacksAndMessages(null);
    }

    public void stopProgressUpdate()
    {
        mSeekBarHandler.removeCallbacksAndMessages(null);
    }


    private String convertTime(long timeInMilliseconds)
    {
        String result = "00:00";
        if (timeInMilliseconds > 0)
        {
            try
            {
                int totalSeconds = (int) timeInMilliseconds / 1000;
                int seconds = totalSeconds % 60;
                int minutes = (totalSeconds / 60) % 60;
                int hours = totalSeconds / 3600;
                mStringBuilder.setLength(0);
                if (hours > 0)
                {
                    result = mFormatter.format("%d:%02d:%02d", hours, minutes, seconds).toString();
                }
                else
                {
                    result = mFormatter.format("%02d:%02d", minutes, seconds).toString();
                }
            }
            catch (Exception ex)
            {
            }
        }

        return result;
    }

    private class SeekBarHandler extends Handler
    {
        @Override
        public void handleMessage(Message message)
        {
            if (message != null)
            {
                switch (message.what)
                {
                    case UPDATE_PROGRESS:
                    {
                        if (mSeekBarControllerListener != null)
                        {
                            mSeekBarControllerListener.onRequestProgressUpdate();
                        }
                        mSeekBarHandler.sendEmptyMessageDelayed(UPDATE_PROGRESS, 1000);
                        break;
                    }
                }
            }
        }
    }

    public void setSeekBarControllerListener(SeekBarControllerListener seekBarControllerListener)
    {
        mSeekBarControllerListener = seekBarControllerListener;
    }

    public void refreshRotateOnClickStatus()
    {
        mRotateVideoButton.refreshRotateOnClickStatus();
    }


    public interface SeekBarControllerListener
    {
        public void onRequestProgressUpdate();
    }
}
