package com.kidoz.sdk.api.players.video_player.ui.activities;

import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentTransaction;
import android.view.KeyEvent;

import com.kidoz.sdk.api.ContentExecutionHandler;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.utils.Utils;

import com.kidoz.sdk.api.players.video_player.logics.VideoPlayerListener;
import com.kidoz.sdk.api.players.video_player.ui.fragments.VideoPlayerFragment;
import com.kidoz.sdk.api.players.video_player.util.ScreenUtils;
import com.kidoz.sdk.api.players.video_player.util.YouTubeUtils;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.ContentPanelView;

import java.util.ArrayList;


/**
 * Created by roni on 7/26/2015.
 */
public class YouTubePlayerActivity extends FragmentActivity
{
    private static final String TAG = YouTubePlayerActivity.class.getSimpleName();
    public static final String INTENT_EXTRA_VIDEO_ID = "INTENT_EXTRA_VIDEO_ID";
    public static final String INTENT_EXTRA_CONTENT_ITEM_ID = "INTENT_EXTRA_CONTENT_ITEM_ID";
    public static final String INTENT_EXTRA_VIDEO_NAME = "INTENT_EXTRA_VIDEO_NAME";
    public static final String INTENT_EXTRA_TOP_BAR_COLOR = "INTENT_EXTRA_TOP_BAR_COLOR";

    private VideoPlayerFragment mVideoPlayerFragment;
    private String mVideoID;
    private String mVideoName;
    private ArrayList<ContentItem> mContent;

    private com.kidoz.sdk.api.general.utils.Utils.StaticHandler mHandler = new com.kidoz.sdk.api.general.utils.Utils.StaticHandler();

    private int mCurrentOrientationState;

    @Override public void onConfigurationChanged(Configuration newConfig)
    {
        super.onConfigurationChanged(newConfig);
        ScreenUtils.hideNavigationAndStatusBar(getWindow());
    }

    @Override protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);

        mCurrentOrientationState = getResources().getConfiguration().orientation;
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR);

        setContentView(R.layout.youtube_player_activity);
        initActivity();
    }

    @Override protected void onResume()
    {
        super.onResume();
        loadRelatedVideoItems();
    }

    private void initActivity()
    {
        ScreenUtils.hideNavigationAndStatusBar(getWindow());
        extractVideoParametersFromIntent();
        initVideoFragment();
    }

    private void extractVideoParametersFromIntent()
    {
        Intent intent = getIntent();
        if (intent != null && intent.hasExtra(INTENT_EXTRA_VIDEO_ID) == true)
        {
            mVideoID = intent.getStringExtra(INTENT_EXTRA_VIDEO_ID);
        }
        if (intent != null && intent.hasExtra(INTENT_EXTRA_VIDEO_NAME) == true)
        {
            mVideoName += intent.getStringExtra(INTENT_EXTRA_VIDEO_NAME);
        }
    }

    private void initVideoFragment()
    {
        mVideoPlayerFragment = new VideoPlayerFragment();
        mVideoPlayerFragment.setVideoID(mVideoID);
        mVideoPlayerFragment.setVideoName(mVideoName);
        mVideoPlayerFragment.setVideoPlayerListener(new VideoPlayerListener()
        {
            @Override public void onBuffering(boolean isBuffering)
            {

            }

            @Override public void onPaused()
            {

            }

            @Override public void onPlaying()
            {
            }

            @Override public void onSeekTo(int newPosition)
            {

            }

            @Override public void onStopped()
            {

            }

            @Override public void onError(String reason)
            {

            }

            @Override public void onFinishedLoading()
            {

            }

            @Override public void onLoading()
            {

            }

            @Override public void onVideoEnded()
            {
            }

            @Override public void onVideoStarted()
            {

            }

            @Override public void onNext()
            {

            }

            @Override public void onPlaylistEnded()
            {

            }

            @Override public void onPrevious()
            {

            }

            @Override public void onBackPressed()
            {
                finish();
            }

            @Override public void onLikeClicked()
            {

            }

            @Override public void onInfoClicked()
            {

            }

            @Override public void reloadRelatedContent()
            {
                loadRelatedVideoItems();
            }

            @Override public void onRelatedPanelStateChanged(boolean isOpened)
            {

            }
        });
        mVideoPlayerFragment.setRelatedContentItemListener(new ContentPanelView.IOnContentItemClickListener()
        {
            @Override public void onItemClick(ContentItem contentItem, int position)
            {
                if (contentItem != null && contentItem.getContentType() == ContentType.YOTUBE_VIDEO)
                {
                    mVideoID = YouTubeUtils.extractYouTubeVideoIDString(contentItem.getData());
                    mVideoName = contentItem.getName();
                    mVideoPlayerFragment.setVideoID(mVideoID);
                    mVideoPlayerFragment.setVideoName(mVideoName);
                }
                else
                {
                    ContentExecutionHandler.handleContentItemClick(YouTubePlayerActivity.this, null, contentItem,position);
                    // finish();
                }
            }
        });
        FragmentTransaction fragmentTransaction = getSupportFragmentManager().beginTransaction();
        fragmentTransaction.replace(R.id.FragmentContainerForYouTube, mVideoPlayerFragment, VideoPlayerFragment.TAG);
        fragmentTransaction.commitAllowingStateLoss();
    }

    @Override public boolean onKeyDown(int keyCode, KeyEvent event)
    {
        boolean result = true;
        if (keyCode != KeyEvent.KEYCODE_BACK)
        {
            result = super.onKeyDown(keyCode, event);
        }

        return result;
    }

    private void loadRelatedVideoItems()
    {
        if (isFinishing() == false && (mContent == null || mContent.isEmpty() == true))
        {
           /* KidozSDK.getApiManager().loadPanda(UiStyleType.FEED_VIEW_STYLE, new ApiResultCallback<ContentData>()
            {
                @Override public void onServerResult(ResultData<?> result)
                {
                    if (result != null && result.getData() != null)
                    {
                        ContentData contentData = (ContentData) result.getData();
                        if (contentData.isHasContentToShow())
                        {
                            mContent = contentData.getContentDataItems();
                            mVideoPlayerFragment.setRelatedContent(contentData.getContentDataItems());
                        }
                    }
                }

                @Override public void onFailed()
                {
                }
            });*/


            mHandler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    String data = null;
                    String packageName = getPackageName();
                    if (packageName != null) {
                        if (packageName.equals("com.kidoz.swipethepanda")) {
                            data = Utils.readStringFromAssets(YouTubePlayerActivity.this, "panda.json");
                        } else if (packageName.equals("com.kidoz.painter")) {
                            data = Utils.readStringFromAssets(YouTubePlayerActivity.this, "painter.json");
                        }
                    }

                    ContentData contentData = null;
                    if (data != null) {
                        contentData = new ContentData();
                        contentData.decodeResponse(data);
                    }


                    if (contentData != null) {
                        if (contentData.isHasContentToShow()) {
                            mContent = contentData.getContentDataItems();
                            mVideoPlayerFragment.setRelatedContent(contentData.getContentDataItems());
                        }
                    }
                }
            }, 500);
        }
    }



    @Override
    protected void onStop() {
        super.onStop();
        mHandler.removeCallbacksAndMessages(null);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();

        setRequestedOrientation(mCurrentOrientationState);
    }
}
