package com.kidoz.sdk.api.picasso_related;

import android.content.Context;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.imagelib.OkHttpDownloader;
import com.squareup.imagelib.Picasso;


/**
 * Created by Eugine on 8/12/2015.
 */
public class PicassoOk {

    private static Picasso mPicassoInstance;

    public static Picasso getPicasso(Context context) {
        if (mPicassoInstance == null) {
            mPicassoInstance = new Picasso
                    .Builder(context)
                    .loggingEnabled(com.kidoz.sdk.api.general.utils.SDKLogger.IS_DEBBUG_MODE)
                    .downloader(new OkHttpDownloader(new OkHttpClient())).build();
        }
        return mPicassoInstance;
    }

}
