package com.kidoz.sdk.api.general.custom_views;

import android.animation.Animator;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Typeface;
import android.os.Build;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.FontManagerUtil;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.players.video_player.util.ScreenUtils;

/**
 * Created by roni on 7/26/2015.
 */
public class KidozTopBar extends LinearLayout
{
    public static final float BACKGROUND_RATIO = 118f / 1920f;
    public static final float BACKGROUND_DEKO_RATIO = 118f / 450f;
    public static final float CLOUDS_RATIO_AGAINST_TOP_BAR = 108f / 118f;
    public static final float CLOUDS_RATIO = 108f / 777f;
    public static final float TOP_ICONS_RELATIVE_SIZE = 0.5f;

    private RelativeLayout mRootView;
    private TextView mTitleTextView;
    private KidozTopBarListener mKidozTopBarListener;
    private TopBarCloseMode mTopBarCloseMode = TopBarCloseMode.BACK_BUTTON;
    private ImageView mLockIconImageView;
    private ImageView mExitIconImageView;
    private boolean mIsParentalLockVisible;

    public enum TopBarCloseMode
    {
        CLOSE_BUTTON, BACK_BUTTON
    }

    public KidozTopBar(Context context, TopBarCloseMode topBarCloseMode)
    {
        super(context);
        mTopBarCloseMode = topBarCloseMode;
        initView();
    }

    public KidozTopBar(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        initView();
    }

    private void initView()
    {
        initRootView();
        initBackground();
        initTitle();
        initExitButton();
        initLockButton();
    }

    private void initRootView()
    {
        mRootView = (RelativeLayout) inflate(getContext(), R.layout.video_player_top_bar, null);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        addView(mRootView, params);

        mRootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener()
        {
            @Override public void onGlobalLayout()
            {
                if (Build.VERSION.SDK_INT < 16)
                {
                    mRootView.getViewTreeObserver().removeGlobalOnLayoutListener(this);
                }
                else
                {
                    mRootView.getViewTreeObserver().removeOnGlobalLayoutListener(this);
                }

                mLockIconImageView.setVisibility(View.INVISIBLE);
                if (mIsParentalLockVisible)
                {
                    mLockIconImageView.postDelayed(new Runnable()
                    {
                        @Override public void run()
                        {
                            GenAnimator.playDropAnimation(mLockIconImageView, new Animator.AnimatorListener()
                            {
                                @Override public void onAnimationStart(Animator animation)
                                {
                                    mLockIconImageView.setVisibility(View.VISIBLE);
                                }

                                @Override public void onAnimationEnd(Animator animation)
                                {

                                }

                                @Override public void onAnimationCancel(Animator animation)
                                {

                                }

                                @Override public void onAnimationRepeat(Animator animation)
                                {

                                }
                            });
                        }
                    }, 370);
                }
                mExitIconImageView.setVisibility(View.INVISIBLE);
                mExitIconImageView.postDelayed(new Runnable()
                {
                    @Override public void run()
                    {
                        GenAnimator.playDropAnimation(mExitIconImageView, new Animator.AnimatorListener()
                        {
                            @Override public void onAnimationStart(Animator animation)
                            {
                                mExitIconImageView.setVisibility(View.VISIBLE);
                            }

                            @Override public void onAnimationEnd(Animator animation)
                            {

                            }

                            @Override public void onAnimationCancel(Animator animation)
                            {

                            }

                            @Override public void onAnimationRepeat(Animator animation)
                            {

                            }
                        });
                    }
                }, 290);
            }
        });
    }

    private void initBackground()
    {
        int screenMaxSize = Math.max(ScreenUtils.getScreenSize(getContext(), true), (ScreenUtils.getScreenSize(getContext(), false)));
        View backgroundMainView = mRootView.findViewById(R.id.MainBackground);
        backgroundMainView.getLayoutParams().height = (int) (screenMaxSize * BACKGROUND_RATIO);
    }

    private void initTitle()
    {
        mTitleTextView = (TextView) mRootView.findViewById(R.id.TopBarTitleTextView);
        mTitleTextView.setTextColor(getResources().getColor(R.color.TopBarTitle));
        mTitleTextView.setShadowLayer(2.0f, 1, 1, getResources().getColor(R.color.TopBarTitleShadow));
        mTitleTextView.setTextSize(TypedValue.COMPLEX_UNIT_SP, getTitleTextSizeByScreenLayout(getContext()));
        mTitleTextView.setEllipsize(TextUtils.TruncateAt.END);
        mTitleTextView.setTypeface(FontManagerUtil.getFont(getContext(), FontManagerUtil.FONT_TYPE.BARIO_BOLD.getValue()));
    }


    private void initLockButton()
    {
        mIsParentalLockVisible = true;
        mLockIconImageView = (ImageView) mRootView.findViewById(R.id.LockCloudButton);
        boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
        if (isLockActive == true)
        {
            mLockIconImageView.setImageResource(R.drawable.lock_cloud);
        }
        else
        {
            mLockIconImageView.setImageResource(R.drawable.lock_cloud_open);
        }
        mLockIconImageView.setOnClickListener(new OnClickListener()
        {
            @Override public void onClick(View view)
            {
                GenAnimator.playStandUpAnimation(view, new Animator.AnimatorListener()
                {
                    @Override public void onAnimationStart(Animator animation)
                    {

                    }

                    @Override public void onAnimationEnd(Animator animation)
                    {
                        int lockStatus = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? 0 : 1;
                        EventManager.getInstance().LogEventWithIntField(getContext(), EventManager.LOG_NORMAL_LEVEL, EventParameters.CATEGORY_PARENTAL_LOCK, EventParameters.ACTION_CLICK, EventParameters.LABEL_PARENTAL_LOCK_BUTTON, lockStatus);
                        ParentalLockDialog parentalLockDialog = new ParentalLockDialog(getContext(), false);
                        parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener()
                        {
                            @Override public void onPasswordEntered(boolean isPasswordCorrect)
                            {
                                boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
                                if (isLockActive == true)
                                {
                                    mLockIconImageView.setImageResource(R.drawable.lock_cloud);
                                }
                                else
                                {
                                    mLockIconImageView.setImageResource(R.drawable.lock_cloud_open);
                                }
                            }
                        });
                        parentalLockDialog.show();
                    }

                    @Override public void onAnimationCancel(Animator animation)
                    {

                    }

                    @Override public void onAnimationRepeat(Animator animation)
                    {

                    }
                });
            }
        });
    }

    private void initExitButton()
    {
        mExitIconImageView = (ImageView) mRootView.findViewById(R.id.ExitCloudButton);
        mExitIconImageView.setOnClickListener(new OnClickListener()
        {
            @Override public void onClick(View v)
            {
                GenAnimator.playStandUpAnimation(v, new Animator.AnimatorListener()
                {
                    @Override public void onAnimationStart(Animator animation)
                    {

                    }

                    @Override public void onAnimationEnd(Animator animation)
                    {
                        EventManager.getInstance().LogEvent(getContext(),
                                EventManager.LOG_NORMAL_LEVEL, null, EventParameters.CATEGORY_SDK,
                                EventParameters.ACTION_CLICK,
                                EventParameters.LABEL_BACK_BUTTON);
                        if (mKidozTopBarListener != null)
                        {
                            mKidozTopBarListener.onExitClicked(null);
                        }
                    }

                    @Override public void onAnimationCancel(Animator animation)
                    {

                    }

                    @Override public void onAnimationRepeat(Animator animation)
                    {

                    }
                });
            }
        });
        switch (mTopBarCloseMode)
        {
            case BACK_BUTTON:
            {
                mExitIconImageView.setImageResource(R.drawable.back_cloud);
                break;
            }

            case CLOSE_BUTTON:
            {
                mExitIconImageView.setImageResource(R.drawable.exit_cloud);
                break;
            }
        }
    }

    public void setKidozTopBarListener(KidozTopBarListener kidozTopBarListener)
    {
        mKidozTopBarListener = kidozTopBarListener;
    }

    public void setTitle(String title)
    {
        if (mTitleTextView != null)
        {
            SpannableString spannableString = new SpannableString(title);
            spannableString.setSpan(new StyleSpan(Typeface.BOLD), 0, spannableString.length(), 0);
            mTitleTextView.setText(spannableString);
            invalidate();
        }
    }

    public void setTopBarBackgroundColor(int color)
    {
        //        if (mRootView != null)
        //        {
        //            mRootView.setBackgroundColor(color);
        //            invalidate();
        //        }
    }

    public interface KidozTopBarListener
    {
        public void onExitClicked(View view);
    }


    private static int getTitleTextSizeByScreenLayout(Context context)
    {
        int size = 20;
        int screenLayout = context.getResources().getConfiguration().screenLayout;
        screenLayout &= Configuration.SCREENLAYOUT_SIZE_MASK;

        switch (screenLayout)
        {
            case Configuration.SCREENLAYOUT_SIZE_SMALL:
            {
                size = 18;
                break;
            }

            case Configuration.SCREENLAYOUT_SIZE_NORMAL:
            {
                size = 21;
                break;
            }

            case Configuration.SCREENLAYOUT_SIZE_LARGE:
            {
                size = 26;
                break;
            }

            case Configuration.SCREENLAYOUT_SIZE_XLARGE:
            {
                size = 30;
                break;
            }
        }
        return size;
    }

    public void showParentalLockIcon(boolean show)
    {
        mIsParentalLockVisible = show;
        if (mIsParentalLockVisible)
        {
            mLockIconImageView.setVisibility(View.VISIBLE);
        }
        else
        {
            mLockIconImageView.setVisibility(View.INVISIBLE);
        }
    }
}
