package com.kidoz.sdk.api.general.custom_views;

import android.content.Context;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;

import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.server_connect.GifDrawableCallback;

import pl.droidsonroids.gif.GifDrawable;

/**
 * Created by Eugine on 8/17/2015.
 */
public class AnimatableGifImageView extends ImageView {

    private GifDrawable mAnimatedGifDrawable = null;
    private boolean mIsPlaying = false;

    public AnimatableGifImageView(Context context) {
        super(context);
    }

    public AnimatableGifImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AnimatableGifImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }


    public void setAnimatedGif(Uri uri,IOnAnimatedGifReadyListener listener) {
        if (getId() == -1) {
            setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        }

        if (mAnimatedGifDrawable != null) {
            KidozSDK.getApiManager(getContext()).cancelGifLoadingRequest(getId() + "");
            mAnimatedGifDrawable.recycle();
            mAnimatedGifDrawable = null;
            setImageDrawable(null);
        }

       // int padding = Utils.dpTOpx(getContext(), INNER_PADDING);
       // setPadding(padding,padding,padding,padding);

        loadGifImage(uri,listener);
    }

    private void loadGifImage(Uri uri,final IOnAnimatedGifReadyListener listener) {
        if (uri != null) {
            KidozSDK.getApiManager(getContext()).loadGifImage(getContext(), uri, getId() + "", new GifDrawableCallback() {
                @Override
                public void onGifDrawableLoaded(GifDrawable gifDrawable) {
                    mAnimatedGifDrawable = gifDrawable;
                    if (gifDrawable != null && gifDrawable.isRecycled() == false) {
                        setImageDrawable(gifDrawable);
                        gifDrawable.start();

                        if(listener != null) {
                            listener.onGifReady();
                        }
                    }
                }
            });
        }
    }

    public void startGifAnimation() {
        if (mAnimatedGifDrawable != null) {
            mAnimatedGifDrawable.stop();
        }
    }

    public void stopGifAnimation() {
        if (mAnimatedGifDrawable != null) {
            mAnimatedGifDrawable.start();
        }
    }

    public void pauseGifAnimation() {
        if (mAnimatedGifDrawable != null) {
            if (mAnimatedGifDrawable.canPause()) {
                mAnimatedGifDrawable.pause();
            }
        }
    }


    @Override
    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);


    }

    @Override
    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);

        if (mAnimatedGifDrawable != null && mAnimatedGifDrawable.isRecycled() == false && mAnimatedGifDrawable.isPlaying()) {
            if (visibility == View.VISIBLE) {
                if (mIsPlaying) {
                    mAnimatedGifDrawable.start();
                    mIsPlaying = false;
                }
            } else {
                mIsPlaying = true;
                mAnimatedGifDrawable.stop();
            }
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();

        if (mAnimatedGifDrawable != null && mAnimatedGifDrawable.isRecycled() == false) {
            mAnimatedGifDrawable.recycle();
            mAnimatedGifDrawable = null;
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }


    public interface IOnAnimatedGifReadyListener {
        public void onGifReady();
    }
}
