package com.kidoz.sdk.api.analytics;

import android.app.IntentService;
import android.content.Intent;

import com.kidoz.sdk.api.KidozSDK;

import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.server_connect.ResultData;

public class SyncEventService extends IntentService
{
	public static final String TAG = SyncEventService.class.getSimpleName();

	public SyncEventService()
	{
		super("LogIntentService");
	}

	private static final int NUM_OF_RETRIES_IN_CASE_FAILED = 1;
	private static final int MAX_TIME_TO_ALLOW_SYNC_TO_RUN = 1000 * 60 * 15; // Safety mechanize to shutdown the sync thread if it runs too long ,witch means that something is wrong

	private Intent mIntent;
	private boolean mSyncRunning = false;
	private boolean mContinueSyncProcces;

	private int munOfRetriesInCaseFailedCount = NUM_OF_RETRIES_IN_CASE_FAILED;
	private long mServiceSyncStartTime;

	@Override
	protected void onHandleIntent(Intent intent)
	{
		SDKLogger.printDebbugLog(TAG, ">>>> SyncEventService : onHandleIntent");
		if (intent != null && intent.hasExtra(KidozEventManager.STOP_SERVICE_EXTRA))
		{
			mSyncRunning = false;
			mContinueSyncProcces = false;
		}

		if (mSyncRunning == false)
		{
			SDKLogger.printWarningLog(" ----------------------  ******************************  ----------------------");
			SDKLogger.printWarningLog(" -----------------  START SYNCHRONIZATION OF LOG EVENTS DATA  V3.0 ----------------------");
			SDKLogger.printWarningLog(" ----------------------  ******************************  ----------------------");

			mSyncRunning = true;
			mContinueSyncProcces = true;
			mServiceSyncStartTime = System.currentTimeMillis();

			while (KidozEventManager.getIsCanSendLog(this) && isAllowedToRunTimeFrame() && mContinueSyncProcces)
			{
				SDKLogger.printDebbugLog(TAG, ">>>> SyncEventService : sending logs");
				EventsBulk bulk = KidozEventManager.getNextBulk(this);
				if (bulk != null)
				{
					String json = bulk.toString();
					if (json != null)
					{
						ResultData<Boolean> resultCallback = KidozSDK.getApiManager(SyncEventService.this).sendKidozEventsToServerNotAsync(json);
						if (resultCallback != null && resultCallback.getResponseStatus().getIsSuccessful())
						{
							KidozEventManager.removeBulkFromDB(this, bulk);
							munOfRetriesInCaseFailedCount = NUM_OF_RETRIES_IN_CASE_FAILED;
						}
						else
						{
							if (munOfRetriesInCaseFailedCount > 0)
							{
								SDKLogger.printInfoLog(TAG, "Log Events Sync Info : Server responce failed ! Trying again...");
								munOfRetriesInCaseFailedCount--;
							}
							else
							{
								break;
							}
						}
					}
					else
					{
						SDKLogger.printErrorLog(TAG, "Log Events Sync Error : Couldnt create JSON representation of an Events BULK !");
						break;
					}
				}
				else
				{
					SDKLogger.printErrorLog(TAG, "Log Events Sync Error : Events BULK object is NULL !");
					break;
				}
			}
		}

		mSyncRunning = false;
	}

	public boolean isAllowedToRunTimeFrame()
	{
		if ((System.currentTimeMillis() - mServiceSyncStartTime) < MAX_TIME_TO_ALLOW_SYNC_TO_RUN)
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	@Override
	public void onDestroy()
	{
		mContinueSyncProcces = false;
		super.onDestroy();
	}
}
