package com.kidoz.sdk.api.analytics;

import android.content.Context;

import com.google.android.gms.analytics.HitBuilders.EventBuilder;
import com.google.android.gms.analytics.Tracker;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.Utils;

public class LogEventHelper
{
    public static final String TAG = LogEventHelper.class.getSimpleName();

    public static void logEvent(Context context, String type, String category, String action, String label)
    {
        logGoogleEvent(context, type, category, action, label);
        logSDKEvent(context, type, category, action, label);
    }

    private static void logGoogleEvent(Context context, String type, String category, String action, String label)
    {
        SDKLogger.printDebbugLog(TAG, ">>>logEvent<<<");
        if (context != null)
        {
            try
            {
                EventBuilder eventBuilder = new EventBuilder();
                GoogleAnalyticsTracker googleAnalyticsTracker = new GoogleAnalyticsTracker(context);
                Tracker tracker = googleAnalyticsTracker.getTracker();
                if (tracker != null)
                {
                    if (type != null)
                    {
                        SDKLogger.printDebbugLog(TAG, ">>>logEvent type = " + type);
                        eventBuilder = eventBuilder.setCustomDimension(GoogleAnalyticsTracker.TYPE, type);

                    }
                    if (category != null)
                    {
                        SDKLogger.printDebbugLog(TAG, ">>>logEvent category = " + category);
                        eventBuilder = eventBuilder.setCategory(category);
                    }
                    if (action != null)
                    {
                        SDKLogger.printDebbugLog(TAG, ">>>logEvent action = " + action);
                        eventBuilder = eventBuilder.setAction(action);
                    }
                    if (label != null)
                    {
                        SDKLogger.printDebbugLog(TAG, ">>>logEvent label = " + label);
                        eventBuilder = eventBuilder.setLabel(label);
                    }
                    String referral = Utils.getDeviceReferral(context);
                    if (referral != null)
                    {
                        SDKLogger.printDebbugLog(TAG, ">>>logEvent referral = " + referral);
                        eventBuilder = eventBuilder.setCustomDimension(GoogleAnalyticsTracker.REFERRAL, referral);
                    }
                    tracker.send(eventBuilder.build());
                }
            }
            catch (Exception ex)
            {
                SDKLogger.printErrorLog(TAG, "Error when trying to log google analytics: " + ex.getMessage());
            }
        }
    }

    private static void logSDKEvent(Context context, String type, String category, String action, String label)
    {
        if (context != null)
        {
            try
            {
                KidozEvent kidozEvent = new KidozEvent();
                if (type != null)
                {
                    kidozEvent.addParameterToJsonObject(LogParameters.TYPE, type);
                }
                if (category != null)
                {
                    kidozEvent.addParameterToJsonObject(LogParameters.CATEGORY, category);
                }
                if (action != null)
                {
                    kidozEvent.addParameterToJsonObject(LogParameters.ACTION, action);
                }
                if (label != null)
                {
                    kidozEvent.addParameterToJsonObject(LogParameters.LABEL, label);
                }
                KidozEventManager.logEvent(context, kidozEvent);
            }
            catch (Exception ex)
            {
                SDKLogger.printErrorLog(TAG, "Error when trying to log SDK event: " + ex.getMessage());
            }
        }
    }

    public static void logEventForSponsoredContent(Context context, String type, String category, String action, String label, String itemID)
    {
        logGoogleEventForImpression(context, type, category, action, label, itemID);
        logSDKEventForImpression(context, type, category, action, label, itemID);
    }

    private static void logGoogleEventForImpression(Context context, String type, String category, String action, String label, String itemID)
    {
        SDKLogger.printDebbugLog(TAG, ">>>logEvent<<<");
        if (context != null)
        {
            try
            {
                EventBuilder eventBuilder = new EventBuilder();
                GoogleAnalyticsTracker googleAnalyticsTracker = new GoogleAnalyticsTracker(context);
                Tracker tracker = googleAnalyticsTracker.getTracker();
                if (tracker != null)
                {
                    if (type != null)
                    {
                        SDKLogger.printDebbugLog(TAG, ">>>logEvent type = " + type);
                        eventBuilder = eventBuilder.setCustomDimension(GoogleAnalyticsTracker.TYPE, type);
                    }
                    if (category != null)
                    {
                        SDKLogger.printDebbugLog(TAG, ">>>logEvent category = " + category);
                        eventBuilder = eventBuilder.setCategory(category);
                    }
                    if (action != null)
                    {
                        SDKLogger.printDebbugLog(TAG, ">>>logEvent action = " + action);
                        eventBuilder = eventBuilder.setAction(action);
                    }
                    if (label != null)
                    {
                        SDKLogger.printDebbugLog(TAG, ">>>logEvent label = " + label);
                        eventBuilder = eventBuilder.setLabel(label);
                    }
                    String referral = Utils.getDeviceReferral(context);
                    if (referral != null)
                    {
                        SDKLogger.printDebbugLog(TAG, ">>>logEvent referral = " + referral);
                        eventBuilder = eventBuilder.setCustomDimension(GoogleAnalyticsTracker.REFERRAL, referral);
                    }
                    if (itemID != null)
                    {
                        SDKLogger.printDebbugLog(TAG, ">>>logEvent itemID = " + itemID);
                        eventBuilder = eventBuilder.setCustomDimension(GoogleAnalyticsTracker.ITEM_ID, itemID);
                    }
                    tracker.send(eventBuilder.build());
                }
            }
            catch (Exception ex)
            {
                SDKLogger.printErrorLog(TAG, "Error when trying to log google analytics: " + ex.getMessage());
            }
        }
    }

    private static void logSDKEventForImpression(Context context, String type, String category, String action, String label, String itemID)
    {
        SDKLogger.printDebbugLog(TAG, ">>>EventBuilder <<logGoogleEvent>>");
        if (context != null)
        {
            try
            {
                KidozEvent kidozEvent = new KidozEvent();
                if (type != null)
                {
                    kidozEvent.addParameterToJsonObject(LogParameters.TYPE, type);
                }
                if (category != null)
                {
                    kidozEvent.addParameterToJsonObject(LogParameters.CATEGORY, category);
                }
                if (action != null)
                {
                    kidozEvent.addParameterToJsonObject(LogParameters.ACTION, action);
                }
                if (label != null)
                {
                    kidozEvent.addParameterToJsonObject(LogParameters.LABEL, label);
                }
                if (itemID != null)
                {
                    kidozEvent.addParameterToJsonObject(LogParameters.ITEM_ID, itemID);
                }
                KidozEventManager.logEvent(context, kidozEvent);
            }
            catch (Exception ex)
            {
                SDKLogger.printErrorLog(TAG, "Error when trying to log google analytics: " + ex.getMessage());
            }
        }
    }
}