package com.kidoz.sdk.api.analytics;

import android.content.Context;

import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.Logger.LogLevel;
import com.google.android.gms.analytics.Tracker;

import com.kidoz.sdk.api.R;

import com.kidoz.sdk.api.general.utils.SDKLogger;

public class GoogleAnalyticsTracker
{
	private static GoogleAnalyticsTracker mGoogleAnalyticsTracker;

	private Tracker mTracker;
	public static final int TYPE = 1;
	public static final int CALLING_SCREEN = 2;
	public static final int SCREEN_ORIENTATION = 3;
	public static final int SECURITY_LEVEL = 4;
	public static final int CONTENT_TYPE = 5;
	public static final int INDEX = 6;
	public static final int REFERRAL = 7;
	public static final int APP_VERSION = 8;
	public static final int ITEM_ID = 9;
	public static final int DURATION = 10;

	public GoogleAnalyticsTracker(Context context)
	{
		GoogleAnalytics googleAnalytics = GoogleAnalytics.getInstance(context);
		if (SDKLogger.IS_DEBBUG_MODE == true)
		{
			googleAnalytics.getLogger().setLogLevel(LogLevel.VERBOSE);
		}

		mTracker = googleAnalytics.newTracker(R.xml.google_analytics_tracker);
	}

	protected static synchronized GoogleAnalyticsTracker getGoogleAnalyticsTracker(Context context)
	{
		if (mGoogleAnalyticsTracker == null)
		{
			mGoogleAnalyticsTracker = new GoogleAnalyticsTracker(context);
		}
		return mGoogleAnalyticsTracker;
	}

	public Tracker getTracker()
	{
		return mTracker;
	}
}
