package com.kidoz.sdk.api.analytics;



import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.server_connect.ResponseStatus;
import com.kidoz.sdk.api.server_connect.ResultData;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

/**
 * This class represents a bulk of events ready to be sent to server.
 * 
 * @author roni
 * 
 */
public class EventsBulk
{
	private final String TAG = EventsBulk.class.getSimpleName();
	public static final int SUCCESS = 1000;

	private final String KEY_DEVICE_PARAMS = "DeviceParams";
	private final String KEY_EVENT_PARAMS = "EventParams";
	private final String KEY_ENTRIES = "Entries";

	private JSONObject mDeviceParamsJSONObject;
	private ArrayList<KidozEvent> mKidozEventArrayList;

	public void setDeviceParamsJSONObject(JSONObject deviceParamsJSONObject)
	{
		mDeviceParamsJSONObject = deviceParamsJSONObject;
	}

	public JSONObject getDeviceParamsJSONObject()
	{
		return mDeviceParamsJSONObject;
	}

	public void setKidozEventArrayList(ArrayList<KidozEvent> kidozEventArrayList)
	{
		mKidozEventArrayList = kidozEventArrayList;
	}

	public ArrayList<KidozEvent> getKidozEventArrayList()
	{
		return mKidozEventArrayList;
	}

	/**
	 * This method return a ready to be sent JSON. The result JSON contains the device params and all the events in a JSON array. The full JSON format can be found in KIDOZ V3 documentation.
	 * 
	 * @return
	 */
	private String convertToJson()
	{
		String result = null;
		if (mDeviceParamsJSONObject != null && mKidozEventArrayList != null && mKidozEventArrayList.size() > 0)
		{
			try
			{
				JSONObject jSONObject = new JSONObject();

				// 1. Insert device params.
				jSONObject.put(KEY_DEVICE_PARAMS, mDeviceParamsJSONObject);

				// 2. Insert log array.
				JSONArray jSONArray = new JSONArray();
				for (KidozEvent nextKidozEvent : mKidozEventArrayList)
				{
					JSONObject nextJsonObject = new JSONObject();
					nextJsonObject.put(KEY_EVENT_PARAMS, nextKidozEvent.getJSONObject());
					jSONArray.put(nextJsonObject);
				}
				jSONObject.put(KEY_ENTRIES, jSONArray);
				result = jSONObject.toString();
			}
			catch (Exception ex)
			{
				SDKLogger.printErrorLog(TAG, "Error when trying to create JSONObject from Bulk : " + ex.getMessage());
			}
		}
		return result;
	}

	@Override
	public String toString()
	{
		return convertToJson();
	}

	public static ResultData<Boolean> parseResultSuccsesStatus(String data)
	{
		ResultData<Boolean> result = new ResultData<Boolean>();
		if (data != null)
		{
			ResponseStatus responseStatus = parseResposneStatus(data);
			result.setResponseStatus(responseStatus);
			if (result.getResponseStatus().getErrorCode() != null && result.getResponseStatus().getErrorCode().equals(String.valueOf(SUCCESS)))
			{
				result.setData(true);
			}
			else
			{
				result.setData(false);
			}
		}
		return result;
	}

	protected static ResponseStatus parseResposneStatus(String data)
	{
		ResponseStatus responseStatus = new ResponseStatus();
		if (data != null)
		{
			try
			{
				JSONArray jsonArray = new JSONArray(data);
				if (jsonArray != null && jsonArray.length() > 0)
				{
					JSONObject object = jsonArray.getJSONObject(0);
					if (object != null)
					{
						if (!object.isNull("success"))
						{
							responseStatus.setIsSuccessful(object.getBoolean("success"));
						}
						if (object.has("messageCode") == true && object.isNull("messageCode") == false)
						{
							responseStatus.setErrorCode(object.getString("messageCode"));
						}
						else if (object.has("errorMessage") == true && object.isNull("errorMessage") == false)
						{
							responseStatus.setErrorCode(object.getString("errorMessage"));
						}
					}
				}
			}
			catch (JSONException ex)
			{
				SDKLogger.printErrorLog("Error parsing response status: " + ex.getMessage());
				return new ResponseStatus();
			}
		}
		return responseStatus;
	}
}
