package com.kidoz.sdk.api;


import android.content.Context;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.View;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.general.enums.UiStyleType;
import com.kidoz.sdk.api.interfaces.IOnInterstitialViewEventListener;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;

import java.util.ArrayList;

/**
 * Created by Evgeny on 16/07/2015.
 */
public class InterstitialView
{
    private static final String TAG = InterstitialView.class.getSimpleName();

    private Builder mBuilder;
    private FeedVeiwFragmentDialog mFeedVeiwFragmentDialog;
    protected ContentLogicLoader mContentLogicLoader;

    private IOnInterstitialViewEventListener mOnInterstitialViewEventListener;

    private InterstitialView(Builder builder)
    {
        mBuilder = builder;
        Fragment existingDialog = mBuilder.mFragmentManager.findFragmentByTag(FeedVeiwFragmentDialog.TAG);
        if (existingDialog != null && existingDialog instanceof FeedVeiwFragmentDialog)
        {
            mFeedVeiwFragmentDialog = (FeedVeiwFragmentDialog) existingDialog;
        }
        else
        {
            mFeedVeiwFragmentDialog = FeedVeiwFragmentDialog.newInstance();
        }

        mFeedVeiwFragmentDialog.setOnCloseButtonClickListenr(new View.OnClickListener()
        {
            @Override public void onClick(View view)
            {
                dismissView();
            }
        });

        initContentLogicLoader();
    }

    /**
     * Initiate  content loader logic ,that handles all the logic for loading content
     **/
    private void initContentLogicLoader()
    {
        mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback()
        {
            @Override public void onDataReady(ContentData contentData)
            {

                int servedCounter = 0;
                if (contentData != null )
                {
                    ArrayList<ContentItem> contentItems = contentData.getContentDataItems();
                    if (contentItems != null && contentItems.isEmpty() == false)
                    {
                        for (ContentItem nextContentItem : contentItems)
                        {
                            if (nextContentItem.isPromoted() == true)
                            {
                                servedCounter++;
                            }
                        }
                    }
                    EventManager.getInstance().LogEventWithIntField(mBuilder.mContext,EventManager.LOG_CRITICAL_LEVEL,
                            EventParameters.CATEGORY_SPONSORED_CONTENT,EventParameters.ACTION_IMPRESSION_SERVED,null,servedCounter);
                }
                mFeedVeiwFragmentDialog.setContentData(contentData);
                if (mOnInterstitialViewEventListener != null)
                {
                    mOnInterstitialViewEventListener.onReadyToShow();
                }
                mFeedVeiwFragmentDialog.openDialog(mBuilder.mFragmentManager);
            }
        });
    }

    /**
     * Show feed interstitial view (Will be shown when content is ready
     **/
    public void showView()
    {
        mContentLogicLoader.loadContent(mBuilder.mContext, UiStyleType.FEED_VIEW_STYLE);
    }

    /**
     * Dissmis view
     **/
    public void dismissView()
    {
        mFeedVeiwFragmentDialog.closeDialog(mBuilder.mFragmentManager);
        if (mOnInterstitialViewEventListener != null)
        {
            mOnInterstitialViewEventListener.onDismissView();
        }
    }

    /**
     * Set on view event listener
     *
     * @param listener
     **/
    public void setOnInterstitialViewEventListener(IOnInterstitialViewEventListener listener)
    {
        mOnInterstitialViewEventListener = listener;
    }

    public static class Builder
    {
        private FragmentManager mFragmentManager;
        private Context mContext;

        public Builder(Context context, FragmentManager fragmentManager)
        {
            mFragmentManager = fragmentManager;
            mContext = context;
        }

        public InterstitialView build()
        {
            return new InterstitialView(this);
        }
    }
}
