package com.kidoz.sdk.api;

import android.content.Context;

import com.kidoz.sdk.api.general.enums.UiStyleType;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.structure.ContentData;

/**
 * Created by Eugine on 8/9/2015.
 */
class ContentLogicLoader
{
    IOnContentDataReadyCallback mDataReadyCallback;

    public ContentLogicLoader(IOnContentDataReadyCallback dataReadyCallback)
    {
        mDataReadyCallback = dataReadyCallback;
    }

    protected void loadContent(Context context, UiStyleType view_style)
    {
        KidozSDK.getApiManager(context).loadContent(context,view_style, new ApiResultCallback<ContentData>()
        {
            @Override public void onServerResult(ResultData<?> result)
            {
                if (result != null && result.getData() != null)
                {
                    ContentData contentData = (ContentData) result.getData();
                    if (contentData.isHasContentToShow())
                    {
                        if (mDataReadyCallback != null)
                        {
                            mDataReadyCallback.onDataReady(contentData);
                        }
                    }
                }
            }

            @Override public void onFailed()
            {
            }
        });
    }


    protected void loadRefreshebleContent(UiStyleType view_style)
    {
        // TODO to add futere support for refreshable content
    }


    public interface IOnContentDataReadyCallback
    {
        public void onDataReady(ContentData contentData);
    }
}

