package com.kidoz.sdk.api;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.support.v4.app.FragmentManager;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.players.video_player.ui.activities.YouTubeActivityWithoutRelated;
import com.kidoz.sdk.api.players.video_player.ui.activities.YouTubePlayerActivity;
import com.kidoz.sdk.api.players.video_player.util.YouTubeUtils;
import com.kidoz.sdk.api.players.web_player.WebPlayerActivity;
import com.kidoz.sdk.api.players.web_player.WebPlayerFragmentDialog;
import com.kidoz.sdk.api.players.web_player.WebPlayerType;
import com.kidoz.sdk.api.structure.ContentItem;

import java.util.List;


/**
 * Created by Eugine on 7/20/2015.
 */
public class ContentExecutionHandler
{
    public static final String TAG = ContentExecutionHandler.class.getSimpleName();

    /**
     * @param fragmentManager
     * @param contentItem
     */
    public static void handleContentItemClick(final Context context, final FragmentManager fragmentManager,
                                              final ContentItem contentItem, final int position)
    {
        switch (contentItem.getContentType())
        {
            case GOOGLE_PLAY_APPLICATION:
            {
                boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(context, ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
                if (isLockActive == true)
                {
                    ParentalLockDialog parentalLockDialog = new ParentalLockDialog(context, true);
                    parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener()
                    {
                        @Override public void onPasswordEntered(boolean isPasswordCorrect)
                        {
                            if (isPasswordCorrect == true)
                            {
                                onGooglePlayApp(context, fragmentManager, contentItem,position);
                            }
                            else
                            {
                                EventManager.getInstance().LogEvent(context, EventManager.LOG_NORMAL_LEVEL, null,
                                        EventParameters.CATEGORY_SDK, EventParameters.ACTION_PARENTAL_INCORRECT_PASSWORD,
                                        contentItem.getId());
                            }
                        }
                    });
                    parentalLockDialog.show();
                }
                else
                {
                    onGooglePlayApp(context, fragmentManager, contentItem,position);
                }
                break;
            }

            case PROMOTED_PLAY_APPLICATION:
            {
                if (context != null && contentItem != null)
                {
                    SharedPreferencesUtils.removeSharedPreferencesData(context, SharedPreferencesUtils.PROMOTED_APP_PACKAGE_NAME);
                    SharedPreferencesUtils.saveSharedPreferencesData(context, SharedPreferencesUtils.PROMOTED_APP_PACKAGE_NAME, contentItem.getId());
//                    LogEventHelper.logEventForSponsoredContent(context, LogParameters.TYPE_CLICK, LogParameters.CATEGORY_SPONSORED_CONTENT, LogParameters.ACTION_CLICK, contentItem.getName(), contentItem.getId());

                }

                boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(context, ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
                if (isLockActive == true)
                {
                    ParentalLockDialog parentalLockDialog = new ParentalLockDialog(context, true);
                    parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener()
                    {
                        @Override public void onPasswordEntered(boolean isPasswordCorrect)
                        {
                            if (isPasswordCorrect == true)
                            {
                                onPromotedAppItemClick(context, fragmentManager, contentItem,position);
                            }
                            else
                            {
                                EventManager.getInstance().LogEvent(context, EventManager.LOG_NORMAL_LEVEL, null,
                                            EventParameters.CATEGORY_SPONSORED_CONTENT, EventParameters.ACTION_PARENTAL_INCORRECT_PASSWORD,
                                            contentItem.getId());
                            }
                        }
                    });
                    parentalLockDialog.show();
                }
                else
                {
                    onPromotedAppItemClick(context, fragmentManager, contentItem, position);
                }
                break;
            }

            case WEB_GAME_URL:
            {
//                if (context != null && contentItem != null)
//                {
//                    EventManager.getInstance().logEvent(context,EventManager.LOG_NORMAL_LEVEL, EventParameters.CATEGORY_ONLINE_GAMES, EventParameters.ACTION_GAME_PLAY, contentItem.getName());
//                }

                onlineGameItemClick(context, fragmentManager, contentItem, position);
                break;
            }

            case WEBSITE_URL:
            {
//                if (context != null && contentItem != null)
//                {
////                    LogEventHelper.logEvent(context, LogParameters.TYPE_VIEW, LogParameters.CATEGORY_WEBSITE_BROWSER, LogParameters.ACTION_WEBSITE_PLAYER_VIEW, contentItem.getName());
//                    EventManager.getInstance().logEvent(context,EventManager.LOG_NORMAL_LEVEL, EventParameters.CATEGORY_WEBSITE_BROWSER, EventParameters.ACTION_WEBSITE_PLAYER_VIEW, contentItem.getName());
//                }

                onUrlItemClick(context, fragmentManager, contentItem,position);
                break;
            }

            case YOTUBE_VIDEO:
            {
//                if (context != null && contentItem != null)
//                {
////                    LogEventHelper.logEvent(context, LogParameters.TYPE_VIEW, LogParameters.CATEGORY_VIDEO_PLAYER, LogParameters.ACTION_VIDEO_PLAY, contentItem.getName());
//                    EventManager.getInstance().logEvent(context,EventManager.LOG_NORMAL_LEVEL, EventParameters.CATEGORY_VIDEO_PLAYER, EventParameters.ACTION_VIDEO_PLAY, contentItem.getName());
//                }

                onYouTubeVideolItemClick(context, fragmentManager, contentItem, position);
                break;
            }

            case STREAMING_VIDEO:
            {

                break;
            }
        }
    }


    /**
     * Handle click on application type
     *
     * @param contentItem
     */
    protected static void onPromotedAppItemClick(Context context, FragmentManager fragmentManager,
                                                 ContentItem contentItem, int position)
    {
        if (contentItem.getData() != null && contentItem.getData().startsWith("market://") || contentItem.getData().startsWith("https://play.google.com") || contentItem.getData().startsWith("http://play.google.com"))
        {
            try
            {
                /*Intent intent = new Intent(Intent.ACTION_VIEW);
                ComponentName comp = new ComponentName("com.android.vending", "com.google.android.finsky.activities.LaunchUrlHandlerActivity"); // package name and activity
                intent.setComponent(comp);
                intent.setData(Uri.parse(contentItem.getData()));
                //intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                //intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK);
                context.startActivity(intent);*/

                Intent intent = new Intent(Intent.ACTION_VIEW);
                intent.setData(Uri.parse(contentItem.getData()));
                // find all applications able to handle our rateIntent
                final List<ResolveInfo> otherApps = context.getPackageManager().queryIntentActivities(intent, 0);
                EventManager.getInstance().logSponsoredContentClickEvent(context,contentItem.getName(),contentItem.getAdvertiserID(),contentItem.getId(),position); //todo: ask Rony
                for (ResolveInfo otherApp : otherApps)
                {
                    // look for Google Play application
                    if (otherApp.activityInfo.applicationInfo.packageName.equals("com.android.vending"))
                    {

                        ActivityInfo otherAppActivity = otherApp.activityInfo;
                        ComponentName componentName = new ComponentName(otherAppActivity.applicationInfo.packageName, otherAppActivity.name);
                        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_RESET_TASK_IF_NEEDED);
                        intent.setComponent(componentName);
                        context.startActivity(intent);
                        break;
                    }
                }

            }
            catch (Exception ex)
            {
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to open google play for promoted app: \n" + ex.getMessage());
            }
        }
        else
        {
            onUrlItemClick(context, fragmentManager, contentItem,position);
        }
    }


    /**
     * Handle click on google play application type
     *
     * @param contentItem
     */
    protected static void onGooglePlayApp(Context context, FragmentManager fragmentManager, ContentItem contentItem, int position)
    {
        // Google account exists ,Lounch Google Play Store
        EventManager.getInstance().logClickEvent(context, EventParameters.ACTION_FEED_ITEM_CLICK, EventParameters.LABEL_CONTENT_TYPE_GOOGLE_PLAY_APP, contentItem.getId(), position);
        Intent googlePlayIntent = new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + contentItem.getId()));
        googlePlayIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        googlePlayIntent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK);
        context.startActivity(googlePlayIntent);
    }

    /**
     * Handle click on content type Online game
     *
     * @param contentItem
     */
    protected static void onlineGameItemClick(Context context, FragmentManager fragmentManager,
                                              ContentItem contentItem,int position)
    {
        EventManager.getInstance().logClickEvent(context, EventParameters.ACTION_FEED_ITEM_CLICK, EventParameters.LABEL_CONTENT_TYPE_ONLINE_GAME, contentItem.getId(), position);
        if (fragmentManager != null)
        {
            WebPlayerFragmentDialog webPlayerFragmentDialog = WebPlayerFragmentDialog.newInstance(contentItem, WebPlayerType.ONLINE_GAME);
            webPlayerFragmentDialog.openDialog(fragmentManager);
        }
        else
        {
            Intent webPlayerActivity = new Intent(context, WebPlayerActivity.class);
            webPlayerActivity.putExtra(WebPlayerActivity.EXTRA_CONTENT_ITEM_KEY, contentItem);
            webPlayerActivity.putExtra(WebPlayerActivity.EXTRA_WEB_PLAYER_TYPE_KEY, WebPlayerType.ONLINE_GAME);
            context.startActivity(webPlayerActivity);
        }
    }

    /**
     * Handle click on content type Url game
     *
     * @param contentItem
     */
    protected static void onUrlItemClick(Context context, FragmentManager fragmentManager,
                                         ContentItem contentItem, int position)
    {
        EventManager.getInstance().logClickEvent(context,EventParameters.ACTION_FEED_ITEM_CLICK, EventParameters.LABEL_CONTENT_TYPE_URL, contentItem.getId(), position);
        if (fragmentManager != null)
        {
            WebPlayerType webPlayerType = WebPlayerType.WEB_BROWSER;
            if (contentItem != null && contentItem.getContentType() == ContentType.PROMOTED_PLAY_APPLICATION)
            {
                webPlayerType = WebPlayerType.EXTERNAL_LINK;
            }

            WebPlayerFragmentDialog webPlayerFragmentDialog = WebPlayerFragmentDialog.newInstance(contentItem, webPlayerType);
            webPlayerFragmentDialog.openDialog(fragmentManager);

        }
        else
        {
            Intent webPlayerActivity = new Intent(context, WebPlayerActivity.class);
            webPlayerActivity.putExtra(WebPlayerActivity.EXTRA_CONTENT_ITEM_KEY, contentItem);
            webPlayerActivity.putExtra(WebPlayerActivity.EXTRA_WEB_PLAYER_TYPE_KEY, WebPlayerType.WEB_BROWSER);
            context.startActivity(webPlayerActivity);
        }
    }


    /**
     * Handle click on content type Video game
     *
     * @param contentItem
     */
    protected static void onYouTubeVideolItemClick(Context context, FragmentManager fragmentManager, ContentItem contentItem, int position)
    {
        if (context != null && contentItem != null && contentItem.getData() != null)
        {
            EventManager.getInstance().logClickEvent(context, EventParameters.ACTION_FEED_ITEM_CLICK,EventParameters.LABEL_CONTENT_TYPE_YOUTUBE, contentItem.getId(), position);
            Intent youtubeActivity = new Intent(context, YouTubeActivityWithoutRelated.class);
            youtubeActivity.putExtra(YouTubePlayerActivity.INTENT_EXTRA_VIDEO_ID, YouTubeUtils.extractYouTubeVideoIDString(contentItem.getData()));
            youtubeActivity.putExtra(YouTubePlayerActivity.INTENT_EXTRA_VIDEO_NAME, contentItem.getName());
            youtubeActivity.putExtra(YouTubePlayerActivity.INTENT_EXTRA_CONTENT_ITEM_ID, contentItem.getId());
            context.startActivity(youtubeActivity);
        }
    }
}

  /* Intent lounchIntent = null;
                if (context != null) {
                    // Check if application is already installed on device
                    lounchIntent = context.getPackageManager().getLaunchIntentForPackage(contentItem.getId());
                }*/

//Otherwise check if Google Account is exists ,At least one
//if(Utils.isManifetsPermissionExists(context,"android.permission.GET_ACCOUNTS")) {
//
//}else {
//
//}
//
//
//if(Utils.isDeviceHasGoogleAccount(context)) {
//// Google account exists ,Lounch Google Play Store
//Intent googlePlayIntent = new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + contentItem.getId()));
//googlePlayIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
//googlePlayIntent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK);
//context.startActivity(googlePlayIntent);
//}else {
//Log.e("[KIDOZ SDK]","User doesn't have a valid Google Account Login on the device!");
//}