/*
 * Decompiled with CFR 0.152.
 */
package com.khubla.pragmatach.plugin.json;

import com.google.gson.Gson;
import com.khubla.pragmatach.framework.api.PragmatachException;
import com.khubla.pragmatach.framework.controller.PragmatachController;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;

public class PragmaticControllerSerializer {
    public static void deserialize(PragmatachController pragmatachController, InputStream inputStream) throws PragmatachException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)baos);
            PragmaticControllerSerializer.deserialize(pragmatachController, baos.toString());
        }
        catch (Exception e) {
            throw new PragmatachException("Exception in deserialize", e);
        }
    }

    public static void deserialize(PragmatachController pragmatachController, String json) throws PragmatachException {
        try {
            JSONObject jSONObject = new JSONObject(json);
            String[] names = JSONObject.getNames((JSONObject)jSONObject);
            if (null != names) {
                for (String name : names) {
                    Class type = PropertyUtils.getPropertyType((Object)pragmatachController, (String)name);
                    if (null == type) continue;
                    String value = jSONObject.getString(name);
                    Object fieldValue = PragmaticControllerSerializer.deserializeField(value, type);
                    PropertyUtils.setProperty((Object)pragmatachController, (String)name, (Object)fieldValue);
                }
            }
        }
        catch (Exception e) {
            throw new PragmatachException("Exception in deserialize", e);
        }
    }

    private static Object deserializeField(String json, Class<?> type) throws PragmatachException {
        try {
            Gson gson = new Gson();
            return gson.fromJson(json, type);
        }
        catch (Exception e) {
            throw new PragmatachException("Exception in deserializeField", e);
        }
    }

    public static String serialize(PragmatachController pragmatachController) throws PragmatachException {
        try {
            JSONObject jSONObject = new JSONObject();
            for (Field field : pragmatachController.getClass().getDeclaredFields()) {
                String fieldValue = PragmaticControllerSerializer.serializeField(PropertyUtils.getProperty((Object)pragmatachController, (String)field.getName()));
                jSONObject.put(field.getName(), (Object)fieldValue);
            }
            return jSONObject.toString();
        }
        catch (Exception e) {
            throw new PragmatachException("Exception in serialize", e);
        }
    }

    public static void serialize(PragmatachController pragmatachController, OutputStream outputStream) throws PragmatachException {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(PragmaticControllerSerializer.serialize(pragmatachController).getBytes());
            IOUtils.copy((InputStream)bais, (OutputStream)outputStream);
        }
        catch (Exception e) {
            throw new PragmatachException("Exception in serialize", e);
        }
    }

    private static String serializeField(Object object) throws PragmatachException {
        try {
            Gson gson = new Gson();
            return gson.toJson(object);
        }
        catch (Exception e) {
            throw new PragmatachException("Exception in serializeField", e);
        }
    }
}

