/*
 * Decompiled with CFR 0.152.
 */
package com.khubla.antlr.antlr4test;

import com.khubla.antlr.antlr4test.CaseInsensitiveType;
import com.khubla.antlr.antlr4test.Scenario;
import com.khubla.antlr.antlr4test.ScenarioExecutor;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, requiresProject=true, threadSafe=false)
public class GrammarTestMojo
extends AbstractMojo {
    protected static final String ERRORS_SUFFIX = ".errors";
    protected static final String TREE_SUFFIX = ".tree";
    @Parameter
    private String grammarName;
    @Parameter
    private CaseInsensitiveType caseInsensitiveType = CaseInsensitiveType.None;
    @Parameter
    private boolean binary = false;
    @Parameter
    private String entryPoint;
    @Parameter
    private boolean enabled = true;
    @Parameter
    private boolean verbose = false;
    @Parameter
    private boolean showTree = true;
    @Parameter(defaultValue="/src/test/resources/examples")
    private String exampleFiles = "/src/test/resources/examples";
    @Parameter
    private String packageName;
    @Parameter
    private String testFileExtension = null;
    @Parameter(defaultValue="${basedir}")
    private File baseDir;
    @Parameter(defaultValue="UTF-8")
    private String fileEncoding = "UTF-8";
    @Parameter
    private String grammarInitializer = null;
    @Parameter
    private List<Scenario> scenarios = null;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private String outputDirectory = "/target/classes";
    @Parameter(defaultValue="${project.build.testOutputDirectory}", readonly=true)
    private String testOutputDirectory = "/target/test-classes";

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.scenarios == null) {
                this.scenarios = new ArrayList<Scenario>();
            }
            if (this.grammarName != null && !"".equals(this.grammarName)) {
                Scenario defaultScenario = new Scenario();
                defaultScenario.setScenarioName("Default Scenario");
                defaultScenario.setGrammarName(this.grammarName);
                defaultScenario.setCaseInsensitiveType(this.caseInsensitiveType);
                defaultScenario.setBaseDir(this.baseDir);
                defaultScenario.setEnabled(this.enabled);
                defaultScenario.setEntryPoint(this.entryPoint);
                defaultScenario.setTestFileExtension(this.testFileExtension);
                defaultScenario.setExampleFiles(this.exampleFiles);
                defaultScenario.setPackageName(this.packageName);
                defaultScenario.setFileEncoding(this.fileEncoding);
                defaultScenario.setGrammarInitializer(this.grammarInitializer);
                defaultScenario.setShowTree(this.showTree);
                defaultScenario.setVerbose(this.verbose);
                defaultScenario.setBinary(this.binary);
                this.scenarios.add(defaultScenario);
            }
            this.testScenarios();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Unable execute mojo", e);
        }
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public boolean getBinary() {
        return this.binary;
    }

    public CaseInsensitiveType getCaseInsensitiveType() {
        return this.caseInsensitiveType;
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }

    public String getExampleFiles() {
        return this.exampleFiles;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public String getGrammarInitializer() {
        return this.grammarInitializer;
    }

    public String getGrammarName() {
        return this.grammarName;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public List<Scenario> getScenarios() {
        return Collections.unmodifiableList(this.scenarios);
    }

    public String getTestFileExtension() {
        return this.testFileExtension;
    }

    public String getTestOutputDirectory() {
        return this.testOutputDirectory;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isShowTree() {
        return this.showTree;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public void setCaseInsensitiveType(CaseInsensitiveType caseInsensitiveType) {
        this.caseInsensitiveType = caseInsensitiveType;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEntryPoint(String entryPoint) {
        this.entryPoint = entryPoint;
    }

    public void setExampleFiles(String exampleFiles) {
        this.exampleFiles = exampleFiles;
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public void setGrammarInitializer(String grammarInitializer) {
        this.grammarInitializer = grammarInitializer;
    }

    public void setGrammarName(String grammarName) {
        this.grammarName = grammarName;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setScenarios(List<Scenario> scenarios) {
        this.scenarios = scenarios;
    }

    public void setShowTree(boolean showTree) {
        this.showTree = showTree;
    }

    public void setTestFileExtension(String testFileExtension) {
        this.testFileExtension = testFileExtension;
    }

    public void setTestOutputDirectory(String testOutputDirectory) {
        this.testOutputDirectory = testOutputDirectory;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private void testScenarios() throws Exception {
        Log mojoLogger = this.getLog();
        if (this.baseDir == null) {
            this.baseDir = new File(".");
        }
        for (Scenario scenario : this.scenarios) {
            mojoLogger.info((CharSequence)("Evaluating Scenario: " + scenario.getScenarioName()));
            if (scenario.getBaseDir() == null) {
                scenario.setBaseDir(this.baseDir);
            }
            if (scenario.getExampleFiles() == null) {
                scenario.setExampleFiles(this.exampleFiles);
            }
            if (scenario.isVerbose()) {
                mojoLogger.info((CharSequence)("baseDir: " + scenario.getBaseDir()));
                mojoLogger.info((CharSequence)("exampleFiles: " + scenario.getExampleFiles()));
                mojoLogger.info((CharSequence)("binary: " + this.binary));
                mojoLogger.info((CharSequence)("case: " + this.caseInsensitiveType));
                mojoLogger.info((CharSequence)("encoding: " + this.fileEncoding));
                if (scenario.isEnabled()) {
                    if (!scenario.getBaseDir().exists()) {
                        throw new MojoExecutionException("baseDir '" + this.baseDir.getAbsolutePath() + "' does not exist");
                    }
                    if (!scenario.getExampleFilesDir().exists()) {
                        throw new MojoExecutionException("exampleFiles directory'" + this.exampleFiles + "' does not exist");
                    }
                }
            }
            if (scenario.isEnabled()) {
                ScenarioExecutor executor = new ScenarioExecutor(this, scenario, mojoLogger);
                executor.testGrammars();
                executor = null;
                continue;
            }
            mojoLogger.warn((CharSequence)("Scenario " + scenario.getScenarioName() + " is disabled. Skipping."));
        }
    }
}

