/*
 * Decompiled with CFR 0.152.
 */
package com.khipu.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BankItem {
    @JsonProperty(value="bank_id")
    private String bankId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="message")
    private String message = null;
    @JsonProperty(value="min_amount")
    private Double minAmount = null;
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="parent")
    private String parent = null;

    public BankItem bankId(String bankId) {
        this.bankId = bankId;
        return this;
    }

    @Schema(description="Identificador del banco")
    public String getBankId() {
        return this.bankId;
    }

    public void setBankId(String bankId) {
        this.bankId = bankId;
    }

    public BankItem name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Nombre del banco")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BankItem message(String message) {
        this.message = message;
        return this;
    }

    @Schema(description="Mensaje con particularidades del banco")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public BankItem minAmount(Double minAmount) {
        this.minAmount = minAmount;
        return this;
    }

    @Schema(description="Monto m\u00ednimo que acepta el banco en un pago")
    public Double getMinAmount() {
        return this.minAmount;
    }

    public void setMinAmount(Double minAmount) {
        this.minAmount = minAmount;
    }

    public BankItem type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="Tipo de banco")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public BankItem parent(String parent) {
        this.parent = parent;
        return this;
    }

    @Schema(description="Identificador del banco padre (si un banco tiene banca personas y empresas, el primero ser\u00e1 el padre del segundo)")
    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankItem bankItem = (BankItem)o;
        return Objects.equals(this.bankId, bankItem.bankId) && Objects.equals(this.name, bankItem.name) && Objects.equals(this.message, bankItem.message) && Objects.equals(this.minAmount, bankItem.minAmount) && Objects.equals(this.type, bankItem.type) && Objects.equals(this.parent, bankItem.parent);
    }

    public int hashCode() {
        return Objects.hash(this.bankId, this.name, this.message, this.minAmount, this.type, this.parent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankItem {\n");
        sb.append("    bankId: ").append(this.toIndentedString(this.bankId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    minAmount: ").append(this.toIndentedString(this.minAmount)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    parent: ").append(this.toIndentedString(this.parent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

