/*
 * Decompiled with CFR 0.152.
 */
package com.khipu;

import com.khipu.ApiException;
import com.khipu.JSON;
import com.khipu.Pair;
import com.khipu.StringUtil;
import com.khipu.auth.ApiKeyAuth;
import com.khipu.auth.Authentication;
import com.khipu.auth.HttpBasicAuth;
import com.khipu.auth.KhipuAuth;
import com.khipu.auth.OAuth;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ApiClient {
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private String basePath = "https://khipu.com/api/2.0";
    private boolean debugging = false;
    private Client httpClient;
    private JSON json = new JSON();
    private String tempFolderPath = null;
    protected String userAgent = "";
    private Map<String, Authentication> authentications;
    private int statusCode;
    private Map<String, List<String>> responseHeaders;
    private DateFormat dateFormat;

    public ApiClient() {
        this.httpClient = this.buildHttpClient(this.debugging);
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.json.setDateFormat((DateFormat)this.dateFormat.clone());
        this.setUserAgent("Swagger-Codegen/2.9.1-resteasy/java");
        this.authentications = new HashMap<String, Authentication>();
        this.authentications.put("khipu", new KhipuAuth());
        this.authentications = Collections.unmodifiableMap(this.authentications);
    }

    public JSON getJSON() {
        return this.json;
    }

    public Client getHttpClient() {
        return this.httpClient;
    }

    public ApiClient setHttpClient(Client httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }

    public void setUsername(String username) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setUsername(username);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setPassword(String password) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setPassword(password);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setApiKey(String apiKey) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKey(apiKey);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setKhipuCredentials(long receiverId, String secret) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof KhipuAuth)) continue;
            ((KhipuAuth)auth).setReceiverId(receiverId);
            ((KhipuAuth)auth).setSecret(secret);
            return;
        }
        throw new RuntimeException("No khipu authentication configured!");
    }

    public void setPlatform(String name, String version) {
        this.userAgent = this.userAgent;
        this.addDefaultHeader("User-Agent", this.userAgent);
    }

    public void setApiKeyPrefix(String apiKeyPrefix) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKeyPrefix(apiKeyPrefix);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setAccessToken(String accessToken) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).setAccessToken(accessToken);
            return;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public ApiClient setUserAgent(String userAgent) {
        this.addDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public ApiClient addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
        return this;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean debugging) {
        this.debugging = debugging;
        this.httpClient = this.buildHttpClient(debugging);
        return this;
    }

    public String getTempFolderPath() {
        return this.tempFolderPath;
    }

    public ApiClient setTempFolderPath(String tempFolderPath) {
        this.tempFolderPath = tempFolderPath;
        return this;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.json.setDateFormat((DateFormat)dateFormat.clone());
        return this;
    }

    public Date parseDate(String str) {
        try {
            return this.dateFormat.parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            return this.formatDate((Date)param);
        }
        if (param instanceof Double) {
            return BigDecimal.valueOf((Double)param).toString();
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Object value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null) {
            return params;
        }
        Collection valueCollection = null;
        if (!(value instanceof Collection)) {
            params.add(new Pair(name, this.parameterToString(value)));
            return params;
        }
        valueCollection = (Collection)value;
        if (valueCollection.isEmpty()) {
            return params;
        }
        String string = collectionFormat = collectionFormat == null || collectionFormat.isEmpty() ? "csv" : collectionFormat;
        if (collectionFormat.equals("multi")) {
            for (Object item : valueCollection) {
                params.add(new Pair(name, this.parameterToString(item)));
            }
            return params;
        }
        String delimiter = ",";
        if (collectionFormat.equals("csv")) {
            delimiter = ",";
        } else if (collectionFormat.equals("ssv")) {
            delimiter = " ";
        } else if (collectionFormat.equals("tsv")) {
            delimiter = "\t";
        } else if (collectionFormat.equals("pipes")) {
            delimiter = "|";
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : valueCollection) {
            sb.append(delimiter);
            sb.append(this.parameterToString(item));
        }
        params.add(new Pair(name, sb.substring(1)));
        return params;
    }

    public boolean isJsonMime(String mime) {
        String jsonMime = "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$";
        return mime != null && (mime.matches(jsonMime) || mime.equals("*/*"));
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return "application/json";
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public Entity<?> serialize(Object obj, Map<String, Object> formParams, String contentType) throws ApiException {
        Entity entity = null;
        if (contentType.startsWith("multipart/form-data")) {
            MultipartFormDataOutput multipart = new MultipartFormDataOutput();
            for (Map.Entry<String, Object> param : formParams.entrySet()) {
                if (param.getValue() instanceof File) {
                    File file = (File)param.getValue();
                    try {
                        multipart.addFormData(param.getValue().toString(), (Object)new FileInputStream(file), MediaType.APPLICATION_OCTET_STREAM_TYPE);
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        throw new ApiException("Could not serialize multipart/form-data " + e.getMessage());
                    }
                }
                multipart.addFormData(param.getValue().toString(), (Object)param.getValue().toString(), MediaType.APPLICATION_OCTET_STREAM_TYPE);
            }
            entity = Entity.entity((Object)multipart.getFormData(), (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE);
        } else if (contentType.startsWith("application/x-www-form-urlencoded")) {
            Form form = new Form();
            for (Map.Entry<String, Object> param : formParams.entrySet()) {
                form.param(param.getKey(), this.parameterToString(param.getValue()));
            }
            entity = Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        } else {
            entity = Entity.entity((Object)obj, (String)contentType);
        }
        return entity;
    }

    public <T> T deserialize(Response response, GenericType<T> returnType) throws ApiException {
        String contentType = null;
        List contentTypes = (List)response.getHeaders().get((Object)"Content-Type");
        if (contentTypes != null && !contentTypes.isEmpty()) {
            contentType = (String)contentTypes.get(0);
        }
        if (contentType == null) {
            throw new ApiException(500, "missing Content-Type in response");
        }
        String body = response.hasEntity() ? String.valueOf(response.readEntity(String.class)) : "";
        if (contentType.startsWith("application/json")) {
            return this.json.deserialize(body, returnType);
        }
        if (returnType.getType().equals(String.class)) {
            return (T)body;
        }
        throw new ApiException(500, "Content type \"" + contentType + "\" is not supported for type: " + returnType.getType());
    }

    public File downloadFileFromResponse(Response response) throws ApiException {
        try {
            File file = this.prepareDownloadFile(response);
            Files.copy((InputStream)response.readEntity(InputStream.class), file.toPath(), new CopyOption[0]);
            return file;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    public File prepareDownloadFile(Response response) throws IOException {
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        String contentDisposition = (String)response.getHeaders().getFirst((Object)"Content-Disposition");
        if (contentDisposition != null && !"".equals(contentDisposition) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition)).find()) {
            filename = matcher.group(1);
        }
        String prefix = null;
        String suffix = null;
        if (filename == null) {
            prefix = "download-";
            suffix = "";
        } else {
            int pos = filename.lastIndexOf(".");
            if (pos == -1) {
                prefix = filename + "-";
            } else {
                prefix = filename.substring(0, pos) + "-";
                suffix = filename.substring(pos);
            }
            if (prefix.length() < 3) {
                prefix = "download-";
            }
        }
        if (this.tempFolderPath == null) {
            return File.createTempFile(prefix, suffix);
        }
        return File.createTempFile(prefix, suffix, new File(this.tempFolderPath));
    }

    public <T> T invokeAPI(String path, String method, List<Pair> queryParams, Object body, Map<String, String> headerParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames, GenericType<T> returnType) throws ApiException {
        String value;
        this.updateParamsForAuth(this.basePath, path, method, authNames, queryParams, headerParams, formParams, body);
        WebTarget target = this.httpClient.target(this.basePath + path);
        if (queryParams != null) {
            for (Pair pair : queryParams) {
                if (pair.getValue() == null) continue;
                target = target.queryParam(pair.getName(), new Object[]{pair.getValue()});
            }
        }
        Invocation.Builder invocationBuilder = target.request();
        if (accept != null) {
            invocationBuilder = invocationBuilder.accept(new String[]{accept});
        }
        for (String key : headerParams.keySet()) {
            value = headerParams.get(key);
            if (value == null) continue;
            invocationBuilder = invocationBuilder.header(key, (Object)value);
        }
        for (String key : this.defaultHeaderMap.keySet()) {
            if (headerParams.containsKey(key) || (value = this.defaultHeaderMap.get(key)) == null) continue;
            invocationBuilder = invocationBuilder.header(key, (Object)value);
        }
        Entity<?> entity = this.serialize(body, formParams, contentType);
        Response response = null;
        if ("GET".equals(method)) {
            response = invocationBuilder.get();
        } else if ("POST".equals(method)) {
            response = invocationBuilder.post(entity);
        } else if ("PUT".equals(method)) {
            response = invocationBuilder.put(entity);
        } else if ("DELETE".equals(method)) {
            response = invocationBuilder.delete();
        } else if ("PATCH".equals(method)) {
            response = invocationBuilder.header("X-HTTP-Method-Override", (Object)"PATCH").post(entity);
        } else if ("HEAD".equals(method)) {
            response = invocationBuilder.head();
        } else {
            throw new ApiException(500, "unknown method type " + method);
        }
        this.statusCode = response.getStatusInfo().getStatusCode();
        this.responseHeaders = this.buildResponseHeaders(response);
        if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
            return null;
        }
        if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
            if (returnType == null) {
                return null;
            }
            return this.deserialize(response, returnType);
        }
        String message = "error";
        String respBody = null;
        if (response.hasEntity()) {
            try {
                message = respBody = String.valueOf(response.readEntity(String.class));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        throw new ApiException(response.getStatus(), message, this.buildResponseHeaders(response), respBody);
    }

    private Client buildHttpClient(boolean debugging) {
        ClientConfiguration clientConfig = new ClientConfiguration(ResteasyProviderFactory.getInstance());
        clientConfig.register((Object)this.json);
        if (debugging) {
            clientConfig.register(Logger.class);
        }
        return ClientBuilder.newClient((Configuration)clientConfig);
    }

    private Map<String, List<String>> buildResponseHeaders(Response response) {
        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        for (Map.Entry entry : response.getHeaders().entrySet()) {
            List values = (List)entry.getValue();
            ArrayList<String> headers = new ArrayList<String>();
            for (Object o : values) {
                headers.add(String.valueOf(o));
            }
            responseHeaders.put((String)entry.getKey(), (List<String>)headers);
        }
        return responseHeaders;
    }

    protected ApiClient updateParamsForAuth(String basePath, String path, String method, String[] authNames, List<Pair> queryParams, Map<String, String> headerParams, Map<String, Object> formParams, Object body) {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) {
                throw new RuntimeException("Authentication undefined: " + authName);
            }
            auth.applyToParams(this, basePath, path, method, queryParams, headerParams, formParams, body);
        }
        return this;
    }
}

