/*
 * Decompiled with CFR 0.152.
 */
package com.keyholesoftware.troublemaker.client.codeblock;

import com.keyholesoftware.troublemaker.client.codeblock.BaseCodeBlock;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryBlock
extends BaseCodeBlock {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryBlock.class);

    public MemoryBlock() {
        this(0L);
    }

    public MemoryBlock(long timeout) {
        super(timeout);
    }

    @Override
    public void eval() {
        long memory = Runtime.getRuntime().freeMemory();
        LOG.info("TroubleMaker client: Memory requested.");
        LOG.info("Eating Memory - started at: " + memory);
        ArrayList<char[]> buffer = new ArrayList<char[]>();
        while (true) {
            try {
                block5: while (true) {
                    char[] c = new char[0x1FFFFFFF];
                    int i = 0;
                    while (true) {
                        if (i >= 0x1FFFFFFF) continue block5;
                        c[i] = (char)i;
                        if (i % 1000000 == 0) {
                            LOG.info("Memory Eaten -" + (Runtime.getRuntime().freeMemory() - memory));
                        }
                        buffer.add(c);
                        ++i;
                    }
                    break;
                }
            }
            catch (OutOfMemoryError e) {
                long start = System.currentTimeMillis();
                String msg = this.timeout == 0L ? "NEVER" : "" + this.timeout / 60000L + " minute(s)";
                LOG.info("Heap MEMORY limit reached...will stay in low memory condition for " + msg);
                block7: while (true) {
                    try {
                        while (true) {
                            long sleep = 1000L;
                            if (System.currentTimeMillis() - start >= this.timeout && this.timeout > 0L) {
                                buffer = null;
                                break block7;
                            }
                            Thread.sleep(sleep);
                        }
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                        continue;
                    }
                    break;
                }
                buffer = null;
                LOG.info("Memory Consumption stopped");
                Thread.currentThread().stop();
                continue;
            }
            break;
        }
    }
}

