/*
 * Decompiled with CFR 0.152.
 */
package com.kevinomyonga.pesapaldroid.util;

import com.kevinomyonga.pesapaldroid.exception.IpnRequestException;
import com.kevinomyonga.pesapaldroid.ipn.DefaultIpnRequest;
import java.util.HashMap;
import java.util.Map;
import oauth.signpost.OAuth;
import oauth.signpost.http.HttpParameters;

public class IpnUtil {
    public static DefaultIpnRequest createFromCallback(String callback) throws IpnRequestException {
        String paramUrl;
        if (callback == null || callback.isEmpty()) {
            throw new IpnRequestException("Callback is Empty");
        }
        int pos = callback.indexOf("=");
        if (pos == -1) {
            throw new IpnRequestException("Invalid Callback or Parameter absents");
        }
        callback = OAuth.percentDecode((String)callback);
        try {
            paramUrl = callback.substring(pos + 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IpnRequestException("Invalid Callback or Parameter absents", e);
        }
        return new DefaultIpnRequest(paramUrl);
    }

    public static Map<String, String> getIpnParamsFromUrl(String url) throws IpnRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (url == null || url.isEmpty()) {
            throw new IpnRequestException("Callback is Empty");
        }
        int pos = url.indexOf(63);
        if (pos == -1 || pos + 1 > url.length()) {
            throw new IpnRequestException("Invalid Callback or Parameter absents");
        }
        HttpParameters params = OAuth.decodeForm((String)(url = url.substring(pos + 1)));
        if (params == null || params.isEmpty()) {
            throw new IpnRequestException("Invalid Callback or Parameter absents");
        }
        if (params.containsKey((Object)"pesapal_transaction_tracking_id")) {
            map.put("pesapal_transaction_tracking_id", params.getFirst((Object)"pesapal_transaction_tracking_id"));
        }
        if (params.containsKey((Object)"pesapal_merchant_reference")) {
            map.put("pesapal_merchant_reference", params.getFirst((Object)"pesapal_merchant_reference"));
        }
        return map;
    }
}

