/*
 * Decompiled with CFR 0.152.
 */
package com.kevinomyonga.pesapaldroid.post;

import com.kevinomyonga.pesapaldroid.IRequest;
import com.kevinomyonga.pesapaldroid.Pesapal;
import com.kevinomyonga.pesapaldroid.exception.PostRequestException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import oauth.signpost.OAuth;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.http.HttpParameters;

public class PostRequest
implements IRequest {
    protected final String callback;
    protected final String form;
    protected final String baseUrl;

    private PostRequest(String baseUrl, String form, String callback) {
        this.form = form;
        this.callback = callback;
        this.baseUrl = baseUrl;
    }

    @Override
    public String getURL() throws PostRequestException {
        String query;
        OAuthConsumer consumer = Pesapal.getConsumer();
        String url = OAuth.addQueryParameters((String)this.baseUrl, (String[])new String[]{"pesapal_request_data", this.form, "oauth_callback", this.callback});
        try {
            url = consumer.sign(url);
        }
        catch (OAuthMessageSignerException e) {
            throw new PostRequestException("Can't sign message", e);
        }
        catch (OAuthExpectationFailedException e) {
            throw new PostRequestException("Failed to sign message", e);
        }
        catch (OAuthCommunicationException e) {
            throw new PostRequestException("Communication failed while sign message", e);
        }
        try {
            query = url.split("\\?")[1];
        }
        catch (IndexOutOfBoundsException e) {
            throw new PostRequestException("Invalid query parameters");
        }
        HttpParameters params = OAuth.decodeForm((String)query);
        url = this.baseUrl;
        Set keyset = params.keySet();
        for (String key : keyset) {
            SortedSet values = params.get((Object)key);
            for (String value : values) {
                url = OAuth.addQueryParameters((String)url, (String[])new String[]{key, value});
            }
        }
        return url;
    }

    @Override
    public URL get() throws PostRequestException {
        try {
            return new URL(this.getURL());
        }
        catch (MalformedURLException e) {
            throw new PostRequestException("Malformed url. base is " + this.baseUrl, e);
        }
    }

    public String getCallback() {
        return this.callback;
    }

    public String getForm() {
        return this.form;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public static class Builder {
        protected static final String url_demo = "http://demo.pesapal.com/api/PostPesapalDirectOrderV4";
        protected static final String url_demo_mobile = "http://demo.pesapal.com/api/PostPesapalDirectOrderMobile";
        protected static final String url_live = "https://www.pesapal.com/api/PostPesapalDirectOrderV4";
        protected static final String url_live_mobile = "https://www.pesapal.com/api/PostPesapalDirectOrderMobile";
        protected static final String callback_live = "https://www.pesapal.com/api/querypaymentstatus";
        protected static final String callback_demo = "http://demo.pesapal.com/api/querypaymentstatus";
        private final String POST_XML = "<?xml version=\"1.0\" encoding=\"utf-8\"?><PesapalDirectOrderInfo xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" Amount=\"%s\" Description=\"%s\" Type=\"%s\" Reference=\"%s\" FirstName=\"%s\" LastName=\"%s\" Email=\"%s\" PhoneNumber=\"%s\" xmlns=\"http://www.pesapal.com\" />";
        private String amount;
        private String description;
        private String type = TYPE.MERCHANT;
        private String reference;
        private String fName;
        private String lName;
        private String mail;
        private String phone;
        private String callback = Pesapal.getDefaultCallback();
        private boolean isMobile = true;

        public Builder() {
            this.reference = UUID.randomUUID().toString();
        }

        public PostRequest build() {
            String form = String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?><PesapalDirectOrderInfo xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" Amount=\"%s\" Description=\"%s\" Type=\"%s\" Reference=\"%s\" FirstName=\"%s\" LastName=\"%s\" Email=\"%s\" PhoneNumber=\"%s\" xmlns=\"http://www.pesapal.com\" />", this.amount, this.description, this.type, this.reference, this.fName, this.lName, this.mail, this.phone);
            return new PostRequest(this.getBaseUrl(), form, this.callback);
        }

        public Builder amount(String amount) {
            this.amount = amount;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder reference(String reference) {
            this.reference = reference;
            return this;
        }

        public Builder name(String fName, String lName) {
            this.fName = fName;
            this.lName = lName;
            return this;
        }

        public Builder mail(String mail) {
            this.mail = mail;
            return this;
        }

        public Builder phone(String phone) {
            this.phone = phone;
            return this;
        }

        public Builder isMobile(boolean isMobile) {
            this.isMobile = isMobile;
            return this;
        }

        public Builder callback(String calback) {
            this.callback = calback;
            return this;
        }

        private String getBaseUrl() {
            if (Pesapal.isDEMO()) {
                return this.isMobile ? url_demo_mobile : url_demo;
            }
            return this.isMobile ? url_live_mobile : url_live;
        }

        public static class TYPE {
            public static String MERCHANT = "MERCHANT";
            public static String ORDER = "ORDER";
        }
    }
}

