/*
 * Decompiled with CFR 0.152.
 */
package com.kevinomyonga.pesapaldroid.ipn;

import com.kevinomyonga.pesapaldroid.Pesapal;
import com.kevinomyonga.pesapaldroid.exception.IpnRequestException;
import com.kevinomyonga.pesapaldroid.exception.PesapalException;
import com.kevinomyonga.pesapaldroid.ipn.AbIpnRequest;
import oauth.signpost.OAuth;

public class IpnRequestStatusDetail
extends AbIpnRequest {
    private final String id;
    private final String reference;

    public IpnRequestStatusDetail(String id, String reference) {
        this.id = id;
        this.reference = reference;
    }

    @Override
    public String getURL() throws PesapalException {
        if (this.id == null || this.id.isEmpty() || this.reference == null || this.reference.isEmpty()) {
            throw new IpnRequestException("ID or Refence not set");
        }
        String baseUrl = this.getBaseUrl();
        String url = OAuth.addQueryParameters((String)baseUrl, (String[])new String[]{"pesapal_transaction_tracking_id", this.id, "pesapal_merchant_reference", this.reference});
        return this.getURL(url);
    }

    private String getBaseUrl() {
        return Pesapal.isDEMO() ? "http://demo.pesapal.com/api/querypaymentdetails" : "https://www.pesapal.com/api/querypaymentdetails";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getReference() {
        return this.reference;
    }
}

