/*
 * Decompiled with CFR 0.152.
 */
package com.kevinomyonga.pesapaldroid.ipn;

import com.kevinomyonga.pesapaldroid.Pesapal;
import com.kevinomyonga.pesapaldroid.exception.IpnRequestException;
import com.kevinomyonga.pesapaldroid.exception.PesapalException;
import com.kevinomyonga.pesapaldroid.ipn.AbIpnRequest;

public class DefaultIpnRequest
extends AbIpnRequest {
    private final String url;
    private final String id;
    private final String reference;

    public DefaultIpnRequest(String url) throws IpnRequestException {
        this.url = url;
        this.id = this.getId(url);
        this.reference = this.getReference(url);
    }

    @Override
    public String getURL() throws PesapalException {
        if (this.url == null || this.url.isEmpty()) {
            throw new IpnRequestException("DefaultIpnRequest URL can't be empty");
        }
        String baseUrl = Pesapal.getDefaultCallback();
        if (!this.url.startsWith(baseUrl)) {
            throw new IpnRequestException("callback not match.Leave default callback.");
        }
        if (this.id == null || this.id.isEmpty() || this.reference == null || this.reference.isEmpty()) {
            throw new IpnRequestException("ID or Refence not set");
        }
        return this.getURL(this.url);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getReference() {
        return this.reference;
    }
}

