/*
 * Decompiled with CFR 0.152.
 */
package com.kevinomyonga.pesapaldroid.ipn;

import com.kevinomyonga.pesapaldroid.IRequest;
import com.kevinomyonga.pesapaldroid.Pesapal;
import com.kevinomyonga.pesapaldroid.exception.IpnRequestException;
import com.kevinomyonga.pesapaldroid.exception.PesapalException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.NoSuchElementException;
import oauth.signpost.OAuth;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.http.HttpParameters;

public abstract class AbIpnRequest
implements IRequest {
    public static final String PARAM_TARCK_ID = "pesapal_transaction_tracking_id";
    public static final String PARAM_MERCHANT_REFERECE = "pesapal_merchant_reference";

    public String getURL(String url) throws PesapalException {
        OAuthConsumer consumer = Pesapal.getConsumer();
        try {
            url = consumer.sign(url);
            return url;
        }
        catch (OAuthMessageSignerException e) {
            throw new IpnRequestException("AbIpnRequest Can't sign the message", e);
        }
        catch (OAuthExpectationFailedException e) {
            throw new IpnRequestException("AbIpnRequest Failed to sign message", e);
        }
        catch (OAuthCommunicationException e) {
            throw new IpnRequestException("AbIpnRequest Communication failed while sign message", e);
        }
    }

    @Override
    public URL get() throws PesapalException {
        try {
            return new URL(this.getURL());
        }
        catch (MalformedURLException e) {
            throw new IpnRequestException("AbIpnRequest Malformed URL while get()", e);
        }
    }

    public String getParamFromUrl(String url, String param) throws IpnRequestException {
        if (url == null || url.isEmpty()) {
            throw new IpnRequestException("Can't get ID.URL can't be empty.");
        }
        try {
            int pos = url.indexOf(63);
            if (pos == -1) {
                return "";
            }
            String query = url.substring(pos + 1);
            HttpParameters params = OAuth.decodeForm((String)query);
            return params.getFirst((Object)param);
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
        catch (NoSuchElementException e) {
            return "";
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    protected String getId(String url) throws IpnRequestException {
        return this.getParamFromUrl(url, PARAM_TARCK_ID);
    }

    protected String getReference(String url) throws IpnRequestException {
        return this.getParamFromUrl(url, PARAM_MERCHANT_REFERECE);
    }

    public abstract String getId();

    public abstract String getReference();
}

