/*
 * Decompiled with CFR 0.152.
 */
package com.kevinomyonga.pesapaldroid;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.widget.SwipeRefreshLayout;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.TextView;
import com.kevinomyonga.pesapaldroid.Pesapal;
import com.kevinomyonga.pesapaldroid.R;
import com.kevinomyonga.pesapaldroid.exception.PesapalException;
import com.kevinomyonga.pesapaldroid.ipn.DefaultIpnRequest;
import com.kevinomyonga.pesapaldroid.post.PostRequest;

public class PesapalDroidFragment
extends Fragment {
    private static final boolean DEBUG = true;
    private static final String TAG = PesapalDroidFragment.class.getSimpleName();
    private static final String HTTP_ERROR = "<html><body><h1>OOps!!</h1><b><p>%s</p></body></html>";
    private static String mConsumer_key;
    private static String mConsumer_secret;
    private boolean is_demo = true;
    private boolean is_mobile = true;
    String fName;
    String lName;
    String email;
    String phone;
    String desc;
    String amount;
    private PostRequest request;
    private WebViewClient webViewClient = new WebViewClient(){

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            PesapalDroidFragment.this.loadingView.setVisibility(8);
            PesapalDroidFragment.this.errorView.setVisibility(0);
            PesapalDroidFragment.this.txtErrorMsg.setText((CharSequence)("Error: " + description));
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            PesapalDroidFragment.this.portalView.setVisibility(8);
            PesapalDroidFragment.this.loadingView.setVisibility(0);
            PesapalDroidFragment.this.swipeContainer.setRefreshing(false);
            Log.d((String)TAG, (String)("onPageStarted:" + url));
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            Log.d((String)TAG, (String)("override : " + url));
            String callback = PesapalDroidFragment.this.request.getCallback();
            if (url.startsWith(callback)) {
                try {
                    DefaultIpnRequest ipn = new DefaultIpnRequest(url);
                    view.loadUrl(ipn.getURL());
                }
                catch (PesapalException e) {
                    String msg = String.format(PesapalDroidFragment.HTTP_ERROR, e.getMessage());
                    view.loadData(msg, "text/html", null);
                }
                return true;
            }
            return super.shouldOverrideUrlLoading(view, url);
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            if (PesapalDroidFragment.this.errorView.getVisibility() == 0) {
                PesapalDroidFragment.this.portalView.setVisibility(8);
            } else {
                PesapalDroidFragment.this.portalView.setVisibility(0);
            }
            PesapalDroidFragment.this.loadingView.setVisibility(8);
        }
    };
    WebView webView;
    View portalView;
    View loadingView;
    View errorView;
    SwipeRefreshLayout swipeContainer;
    TextView txtErrorMsg;
    Button btnRetry;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        View view = inflater.inflate(R.layout.fragment_main, container, false);
        Pesapal.initialize(this.getConsumerKey(), this.getConsumerSecret());
        Pesapal.setDEMO(this.isDemoEnabled());
        this.portalView = view.findViewById(R.id.portal);
        this.loadingView = view.findViewById(R.id.loading);
        this.errorView = view.findViewById(R.id.error);
        this.loadingView.setVisibility(8);
        this.errorView.setVisibility(8);
        this.txtErrorMsg = (TextView)view.findViewById(R.id.txtErrorMsg);
        this.btnRetry = (Button)view.findViewById(R.id.btnRetry);
        this.webView = (WebView)view.findViewById(R.id.webView);
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.getSettings().setBuiltInZoomControls(true);
        this.webView.setWebViewClient(this.webViewClient);
        this.swipeContainer = (SwipeRefreshLayout)view.findViewById(R.id.portalSwipeContainer);
        this.swipeContainer.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                PesapalDroidFragment.this.loadPortal();
            }
        });
        this.btnRetry.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PesapalDroidFragment.this.errorView.setVisibility(8);
                PesapalDroidFragment.this.loadPortal();
            }
        });
        return view;
    }

    public void onResume() {
        super.onResume();
        this.loadPortal();
    }

    public void loadPortal() {
        this.request = this.createPostRequest();
        try {
            String url = this.request.getURL();
            this.webView.loadUrl(url);
        }
        catch (PesapalException e) {
            String msg = String.format(HTTP_ERROR, e.getMessage());
            this.webView.loadData(msg, "text/html", null);
        }
    }

    public void onInflate(Context context, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(context, attrs, savedInstanceState);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.PesapalDroidFragment);
        mConsumer_key = typedArray.getString(R.styleable.PesapalDroidFragment_consumer_key);
        mConsumer_secret = typedArray.getString(R.styleable.PesapalDroidFragment_consumer_secret);
        this.is_demo = typedArray.getBoolean(R.styleable.PesapalDroidFragment_is_demo, true);
        this.is_mobile = typedArray.getBoolean(R.styleable.PesapalDroidFragment_is_mobile, true);
        typedArray.recycle();
    }

    public void setConsumerKey(String consumer_key) {
        mConsumer_key = consumer_key;
    }

    public String getConsumerKey() {
        return mConsumer_key;
    }

    public void setConsumerSecret(String consumer_secret) {
        mConsumer_secret = consumer_secret;
    }

    public String getConsumerSecret() {
        return mConsumer_secret;
    }

    public void setDemoEnabled(boolean enabled) {
        this.is_demo = enabled;
    }

    public boolean isDemoEnabled() {
        return this.is_demo;
    }

    public void setMobileEnabled(boolean enabled) {
        this.is_mobile = enabled;
    }

    public boolean isMobileEnabled() {
        return this.is_mobile;
    }

    private PostRequest createPostRequest() {
        PostRequest.Builder builder = new PostRequest.Builder();
        builder.isMobile(this.isMobileEnabled()).amount(this.getAmount()).description(this.getDesc()).phone(this.getPhone()).mail(this.getEmail()).name(this.getfName(), this.getlName());
        return builder.build();
    }

    public void setfName(String fName) {
        this.fName = fName;
    }

    public String getfName() {
        return this.fName;
    }

    public void setlName(String lName) {
        this.lName = lName;
    }

    public String getlName() {
        return this.lName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getAmount() {
        return this.amount;
    }
}

