/*
 * Decompiled with CFR 0.152.
 */
package com.kevin.wheelview;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.media.AudioManager;
import android.media.SoundPool;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.OverScroller;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.FloatRange;
import androidx.annotation.RawRes;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.kevin.wheelview.R;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b,\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b>\b\u0016\u0018\u0000 \u00e5\u00012\u00020\u00012\u00020\u0002:\n\u00e5\u0001\u00e6\u0001\u00e7\u0001\u00e8\u0001\u00e9\u0001B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010`\u001a\u00020aJ\u0010\u0010b\u001a\u00020\b2\u0006\u0010_\u001a\u00020\bH\u0002J\u0010\u0010c\u001a\u00020\b2\u0006\u0010d\u001a\u00020\bH\u0002J\b\u0010e\u001a\u00020aH\u0002J\b\u0010f\u001a\u00020aH\u0002J\b\u0010g\u001a\u00020aH\u0002J8\u0010h\u001a\u00020a2\u0006\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020.2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010l\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0002JH\u0010m\u001a\u00020a2\u0006\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020.2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010n\u001a\u00020\u001b2\u0006\u0010o\u001a\u00020\u001b2\u0006\u0010p\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0010\u0010q\u001a\u00020a2\u0006\u0010r\u001a\u00020\bH\u0002J \u0010s\u001a\u00020a2\u0006\u0010i\u001a\u00020j2\u0006\u0010t\u001a\u00020\b2\u0006\u0010u\u001a\u00020\bH\u0002J8\u0010v\u001a\u00020a2\u0006\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020.2\u0006\u0010n\u001a\u00020\u001b2\u0006\u0010o\u001a\u00020\u001b2\u0006\u0010p\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0010\u0010w\u001a\u00020a2\u0006\u0010i\u001a\u00020jH\u0002J \u0010x\u001a\u00020a2\u0006\u0010i\u001a\u00020j2\u0006\u0010t\u001a\u00020\b2\u0006\u0010u\u001a\u00020\bH\u0002J\u0010\u0010y\u001a\u00020a2\u0006\u0010i\u001a\u00020jH\u0002J\u0006\u0010z\u001a\u00020aJ\u0006\u0010{\u001a\u00020\bJ\u0006\u0010|\u001a\u00020\u001bJ\u0006\u0010}\u001a\u00020\u001bJ\u0012\u0010~\u001a\u0004\u0018\u00010.2\u0006\u0010t\u001a\u00020\bH\u0002J\f\u0010\u007f\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\u0014\u0010\u0080\u0001\u001a\u00020.2\t\u0010\u0081\u0001\u001a\u0004\u0018\u00010\u001fH\u0002J\u0007\u0010\u0082\u0001\u001a\u00020!J\u0007\u0010\u0083\u0001\u001a\u00020\bJ\u0007\u0010\u0084\u0001\u001a\u00020\u001bJ\u0007\u0010\u0085\u0001\u001a\u00020\u001bJ\u0007\u0010\u0086\u0001\u001a\u00020\bJ\u0007\u0010\u0087\u0001\u001a\u00020.J\u0012\u0010\u0088\u0001\u001a\u0004\u0018\u00010\u001f2\u0007\u0010\u0089\u0001\u001a\u00020\bJ\u0007\u0010\u008a\u0001\u001a\u00020\u001bJ\u0007\u0010\u008b\u0001\u001a\u00020\bJ\t\u0010\u008c\u0001\u001a\u0004\u0018\u00010FJ\t\u0010\u008d\u0001\u001a\u0004\u0018\u00010HJ\u0007\u0010\u008e\u0001\u001a\u00020\u001bJ\u0007\u0010\u008f\u0001\u001a\u00020\u001fJ\u0007\u0010\u0090\u0001\u001a\u00020\bJ\u0007\u0010\u0091\u0001\u001a\u00020\bJ\u0007\u0010\u0092\u0001\u001a\u00020\bJ\u0007\u0010\u0093\u0001\u001a\u00020\bJ\u0007\u0010\u0094\u0001\u001a\u00020\u001bJ\u0007\u0010\u0095\u0001\u001a\u00020\u001bJ\b\u0010\u0096\u0001\u001a\u00030\u0097\u0001J\u0007\u0010\u0098\u0001\u001a\u00020\bJ\u001b\u0010\u0099\u0001\u001a\u00020a2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0011\u0010\u009a\u0001\u001a\u00020a2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0011\u0010\u009b\u0001\u001a\u00020a2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\t\u0010\u009c\u0001\u001a\u00020aH\u0002J\t\u0010\u009d\u0001\u001a\u00020aH\u0002J\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u000200J\u0006\u00102\u001a\u000200J\u0006\u00103\u001a\u000200J\u0006\u00106\u001a\u000200J\u0010\u0010\u009e\u0001\u001a\u0002002\u0007\u0010\u0089\u0001\u001a\u00020\bJ\u0006\u00107\u001a\u000200J\u0006\u00108\u001a\u000200J\u0006\u0010:\u001a\u000200J\t\u0010\u009f\u0001\u001a\u00020aH\u0002J\t\u0010\u00a0\u0001\u001a\u00020aH\u0014J\u0011\u0010\u00a1\u0001\u001a\u00020a2\u0006\u0010i\u001a\u00020jH\u0014J\u001b\u0010\u00a2\u0001\u001a\u00020a2\u0007\u0010\u00a3\u0001\u001a\u00020\b2\u0007\u0010\u00a4\u0001\u001a\u00020\bH\u0014J-\u0010\u00a5\u0001\u001a\u00020a2\u0007\u0010\u00a6\u0001\u001a\u00020\b2\u0007\u0010\u00a7\u0001\u001a\u00020\b2\u0007\u0010\u00a8\u0001\u001a\u00020\b2\u0007\u0010\u00a9\u0001\u001a\u00020\bH\u0014J\u0013\u0010\u00aa\u0001\u001a\u0002002\b\u0010\u00ab\u0001\u001a\u00030\u00ac\u0001H\u0016J\u0007\u0010\u00ad\u0001\u001a\u00020aJ\t\u0010\u00ae\u0001\u001a\u00020\bH\u0002J\u0012\u0010\u00af\u0001\u001a\u00020a2\u0007\u0010\u00b0\u0001\u001a\u00020\u001bH\u0002J\t\u0010\u00b1\u0001\u001a\u00020aH\u0002J\u0012\u0010\u00b2\u0001\u001a\u00020\b2\u0007\u0010\u00b3\u0001\u001a\u00020.H\u0002J\t\u0010\u00b4\u0001\u001a\u00020aH\u0016J\u000f\u0010\u00b5\u0001\u001a\u00020a2\u0006\u0010/\u001a\u000200J\u000f\u0010\u00b6\u0001\u001a\u00020a2\u0006\u00101\u001a\u000200J\u000f\u0010\u00b7\u0001\u001a\u00020a2\u0006\u0010\u0017\u001a\u00020\bJ\u0011\u0010\u00b8\u0001\u001a\u00020a2\b\b\u0001\u0010\u001a\u001a\u00020\u001bJ\u0011\u0010\u00b9\u0001\u001a\u00020a2\b\b\u0001\u0010\u001c\u001a\u00020\u001bJ\u000f\u0010\u00ba\u0001\u001a\u00020a2\u0006\u00102\u001a\u000200J\u0015\u0010\u00bb\u0001\u001a\u00020a2\f\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001eJ\u000f\u0010\u00bc\u0001\u001a\u00020a2\u0006\u0010 \u001a\u00020!J\u0011\u0010\u00bd\u0001\u001a\u00020a2\b\b\u0001\u0010\"\u001a\u00020\bJ\u0012\u0010\u00be\u0001\u001a\u00020a2\t\b\u0001\u0010\u00bf\u0001\u001a\u00020\bJ\u0010\u0010\u00c0\u0001\u001a\u00020a2\u0007\u0010\u00c1\u0001\u001a\u00020\u001bJ\u0019\u0010\u00c0\u0001\u001a\u00020a2\u0007\u0010\u00c1\u0001\u001a\u00020\u001b2\u0007\u0010\u00c2\u0001\u001a\u000200J\u000f\u0010\u00c3\u0001\u001a\u00020a2\u0006\u0010#\u001a\u00020\u001bJ\u0018\u0010\u00c3\u0001\u001a\u00020a2\u0006\u0010#\u001a\u00020\u001b2\u0007\u0010\u00c2\u0001\u001a\u000200J\u000f\u0010\u00c4\u0001\u001a\u00020a2\u0006\u0010%\u001a\u00020\bJ\u000f\u0010\u00c5\u0001\u001a\u00020a2\u0006\u00103\u001a\u000200J\u000f\u0010\u00c6\u0001\u001a\u00020a2\u0006\u0010-\u001a\u00020.J\u000f\u0010\u00c7\u0001\u001a\u00020a2\u0006\u00106\u001a\u000200J\u000f\u0010\u00c7\u0001\u001a\u00020a2\u0006\u0010-\u001a\u00020.J\u001a\u0010\u00c8\u0001\u001a\u00020a2\u0006\u0010=\u001a\u00020\u001b2\t\b\u0002\u0010\u00c2\u0001\u001a\u000200J\u0011\u0010\u00c9\u0001\u001a\u00020a2\b\b\u0001\u0010[\u001a\u00020\bJ\u0012\u0010\u00ca\u0001\u001a\u00020a2\t\b\u0001\u0010\u00cb\u0001\u001a\u00020\bJ\u000f\u0010\u00cc\u0001\u001a\u00020a2\u0006\u0010E\u001a\u00020FJ\u000f\u0010\u00cd\u0001\u001a\u00020a2\u0006\u0010G\u001a\u00020HJ\u0012\u0010\u00ce\u0001\u001a\u00020a2\t\b\u0001\u0010\u00cf\u0001\u001a\u00020\u001bJ\u000f\u0010\u00d0\u0001\u001a\u00020a2\u0006\u00107\u001a\u000200J\u001a\u0010\u00d1\u0001\u001a\u00020a2\u0007\u0010\u0089\u0001\u001a\u00020\b2\b\b\u0002\u00109\u001a\u000200J!\u0010\u00d1\u0001\u001a\u00020a2\u0007\u0010\u0089\u0001\u001a\u00020\b2\u0006\u00109\u001a\u0002002\u0007\u0010\u00d2\u0001\u001a\u00020\bJ\u0011\u0010\u00d3\u0001\u001a\u00020a2\b\b\u0001\u0010R\u001a\u00020\bJ\u0012\u0010\u00d4\u0001\u001a\u00020a2\t\b\u0001\u0010\u00d5\u0001\u001a\u00020\bJ\u0011\u0010\u00d6\u0001\u001a\u00020a2\b\b\u0001\u0010T\u001a\u00020\bJ\u0012\u0010\u00d7\u0001\u001a\u00020a2\t\b\u0001\u0010\u00d8\u0001\u001a\u00020\bJ\u000f\u0010\u00d9\u0001\u001a\u00020a2\u0006\u00108\u001a\u000200J\u000f\u0010\u00da\u0001\u001a\u00020a2\u0006\u0010:\u001a\u000200J\u0012\u0010\u00db\u0001\u001a\u00020a2\t\b\u0001\u0010\u00dc\u0001\u001a\u00020\bJ\u000f\u0010\u00dd\u0001\u001a\u00020a2\u0006\u0010X\u001a\u00020\bJ\u000f\u0010\u00de\u0001\u001a\u00020a2\u0006\u0010Z\u001a\u00020\u001bJ\u0018\u0010\u00de\u0001\u001a\u00020a2\u0006\u0010Z\u001a\u00020\u001b2\u0007\u0010\u00c2\u0001\u001a\u000200J\u001a\u0010\u00df\u0001\u001a\u00020a2\u0006\u0010\\\u001a\u00020\u001b2\t\b\u0002\u0010\u00e0\u0001\u001a\u000200J\u0011\u0010\u00e1\u0001\u001a\u00020a2\b\u0010\u00e2\u0001\u001a\u00030\u0097\u0001J\u000f\u0010\u00e3\u0001\u001a\u00020a2\u0006\u0010_\u001a\u00020\bJ\t\u0010\u00e4\u0001\u001a\u00020aH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\bX\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020\bX\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b&\u0010\u0019R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010E\u001a\u0004\u0018\u00010FX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010G\u001a\u0004\u0018\u00010HX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020JX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020LX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010P\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010R\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010S\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010T\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010U\u001a\u00020VX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010W\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010X\u001a\u00020\bX\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\bY\u0010\u0019R\u000e\u0010Z\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010[\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\\\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010]\u001a\u0004\u0018\u00010^X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010_\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00ea\u0001"}, d2={"Lcom/kevin/wheelview/WheelView;", "Landroid/view/View;", "Ljava/lang/Runnable;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "camera", "Landroid/graphics/Camera;", "centerToBaselineY", "centerX", "centerY", "clipBottom", "clipLeft", "clipRight", "clipTop", "currentPosition", "getCurrentPosition", "()I", "currentScrollPosition", "curvedArcDirection", "curvedArcDirection$annotations", "()V", "curvedArcDirectionFactor", "", "curvedRefractRatio", "dataItems", "", "", "dividerCap", "Landroid/graphics/Paint$Cap;", "dividerColor", "dividerPaddingForWrap", "dividerSize", "dividerType", "dividerType$annotations", "downStartTime", "", "drawRect", "Landroid/graphics/Rect;", "fontMetrics", "Landroid/graphics/Paint$FontMetrics;", "integerFormat", "", "isAutoFitTextSize", "", "isCurved", "isCyclic", "isDrawSelectedRect", "isFlingScroll", "isForceFinishScroll", "isIntegerNeedFormat", "isResetSelectedPosition", "isShowDivider", "isSmoothScroll", "isSoundEffect", "itemHeight", "lastTouchY", "lineSpacing", "mMatrix", "Landroid/graphics/Matrix;", "maxFlingVelocity", "maxScrollY", "maxTextWidth", "minFlingVelocity", "minScrollY", "onItemSelectedListener", "Lcom/kevin/wheelview/WheelView$OnItemSelectedListener;", "onWheelChangedListener", "Lcom/kevin/wheelview/WheelView$OnWheelChangedListener;", "overScroller", "Landroid/widget/OverScroller;", "paint", "Landroid/graphics/Paint;", "scrollOffsetY", "scrolledY", "selectItemPosition", "selectedItemBottomLimit", "selectedItemPosition", "selectedItemTextColor", "selectedItemTopLimit", "selectedRectColor", "soundHelper", "Lcom/kevin/wheelview/WheelView$SoundHelper;", "startX", "textAlign", "textAlign$annotations", "textBoundaryMargin", "textColor", "textSize", "velocityTracker", "Landroid/view/VelocityTracker;", "visibleItems", "abortFinishScroll", "", "adjustVisibleItems", "calculateDistanceToEndPoint", "remainder", "calculateDrawStart", "calculateLimitY", "calculateTextSize", "clipAndDraw2DText", "canvas", "Landroid/graphics/Canvas;", "text", "item2CenterOffsetY", "clipAndDraw3DText", "rotateX", "offsetY", "offsetZ", "doScroll", "distance", "draw3DItem", "index", "scrolledOffset", "draw3DText", "drawDivider", "drawItem", "drawSelectedRect", "forceFinishScroll", "getCurvedArcDirection", "getCurvedArcDirectionFactor", "getCurvedRefractRatio", "getDataByIndex", "getDataItems", "getDataText", "item", "getDividerCap", "getDividerColor", "getDividerHeight", "getDividerPaddingForWrap", "getDividerType", "getIntegerFormat", "getItemData", "position", "getLineSpacing", "getNormalItemTextColor", "getOnItemSelectedListener", "getOnWheelChangedListener", "getPlayVolume", "getSelectedItemData", "getSelectedItemPosition", "getSelectedItemTextColor", "getSelectedRectColor", "getTextAlign", "getTextBoundaryMargin", "getTextSize", "getTypeface", "Landroid/graphics/Typeface;", "getVisibleItems", "initAttrsAndDefault", "initDefaultVolume", "initValue", "initVelocityTracker", "invalidateIfYChanged", "isPositionInRange", "observeItemChanged", "onDetachedFromWindow", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSizeChanged", "w", "h", "oldw", "oldh", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "playSoundEffect", "recalculateCenterToBaselineY", "recalculateStartX", "textMargin", "recycleVelocityTracker", "remeasureTextSize", "contentText", "run", "setAutoFitTextSize", "setCurved", "setCurvedArcDirection", "setCurvedArcDirectionFactor", "setCurvedRefractRatio", "setCyclic", "setDataItems", "setDividerCap", "setDividerColor", "setDividerColorRes", "dividerColorRes", "setDividerHeight", "dividerHeight", "isDp", "setDividerPaddingForWrap", "setDividerType", "setDrawSelectedRect", "setIntegerFormat", "setIntegerNeedFormat", "setLineSpacing", "setNormalItemTextColor", "setNormalItemTextColorRes", "textColorRes", "setOnItemSelectedListener", "setOnWheelChangedListener", "setPlayVolume", "playVolume", "setResetSelectedPosition", "setSelectedItemPosition", "smoothDuration", "setSelectedItemTextColor", "setSelectedItemTextColorRes", "selectedItemColorRes", "setSelectedRectColor", "setSelectedRectColorRes", "selectedRectColorRes", "setShowDivider", "setSoundEffect", "setSoundEffectResource", "rawResId", "setTextAlign", "setTextBoundaryMargin", "setTextSize", "isSp", "setTypeface", "typeface", "setVisibleItems", "updateTextAlign", "Companion", "OnItemSelectedListener", "OnWheelChangedListener", "SimpleOnWheelChangedListener", "SoundHelper", "wheelview_release"})
public class WheelView
extends View
implements Runnable {
    private final Paint paint;
    private float textSize;
    private boolean isAutoFitTextSize;
    private Paint.FontMetrics fontMetrics;
    private int itemHeight;
    private int maxTextWidth;
    private int centerToBaselineY;
    private int visibleItems;
    private float lineSpacing;
    private boolean isCyclic;
    private int textAlign;
    private int textColor;
    private int selectedItemTextColor;
    private boolean isShowDivider;
    private int dividerColor;
    private float dividerSize;
    private int dividerType;
    private float dividerPaddingForWrap;
    private Paint.Cap dividerCap;
    private boolean isDrawSelectedRect;
    private int selectedRectColor;
    private int startX;
    private int centerX;
    private int centerY;
    private int selectedItemTopLimit;
    private int selectedItemBottomLimit;
    private int clipLeft;
    private int clipTop;
    private int clipRight;
    private int clipBottom;
    private final Rect drawRect;
    private float textBoundaryMargin;
    private boolean isIntegerNeedFormat;
    private String integerFormat;
    private Camera camera;
    private Matrix mMatrix;
    private boolean isCurved;
    private int curvedArcDirection;
    private float curvedArcDirectionFactor;
    private float curvedRefractRatio;
    private List<Object> dataItems;
    private boolean isResetSelectedPosition;
    private VelocityTracker velocityTracker;
    private int maxFlingVelocity;
    private int minFlingVelocity;
    private OverScroller overScroller;
    private int minScrollY;
    private int maxScrollY;
    private int scrollOffsetY;
    private int scrolledY;
    private float lastTouchY;
    private long downStartTime;
    private boolean isForceFinishScroll;
    private boolean isFlingScroll;
    private int selectedItemPosition;
    private int currentScrollPosition;
    private OnItemSelectedListener onItemSelectedListener;
    private OnWheelChangedListener onWheelChangedListener;
    private SoundHelper soundHelper;
    private boolean isSoundEffect;
    private int selectItemPosition;
    private boolean isSmoothScroll;
    private static final float DEFAULT_LINE_SPACING;
    private static final float DEFAULT_TEXT_SIZE;
    private static final float DEFAULT_TEXT_BOUNDARY_MARGIN;
    private static final float DEFAULT_DIVIDER_HEIGHT;
    private static final int DEFAULT_NORMAL_TEXT_COLOR = -12303292;
    private static final int DEFAULT_SELECTED_TEXT_COLOR = -16777216;
    private static final int DEFAULT_VISIBLE_ITEM = 5;
    private static final int DEFAULT_SCROLL_DURATION = 250;
    private static final long DEFAULT_CLICK_CONFIRM = 120L;
    private static final String DEFAULT_INTEGER_FORMAT = "%02d";
    private static final float DEFAULT_REFRACT_RATIO = 0.9f;
    public static final int TEXT_ALIGN_LEFT = 0;
    public static final int TEXT_ALIGN_CENTER = 1;
    public static final int TEXT_ALIGN_RIGHT = 2;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SCROLLING = 2;
    public static final int CURVED_ARC_DIRECTION_LEFT = 0;
    public static final int CURVED_ARC_DIRECTION_CENTER = 1;
    public static final int CURVED_ARC_DIRECTION_RIGHT = 2;
    public static final float DEFAULT_CURVED_FACTOR = 0.75f;
    public static final int DIVIDER_TYPE_FILL = 0;
    public static final int DIVIDER_TYPE_WRAP = 1;
    public static final Companion Companion;

    private static /* synthetic */ void textAlign$annotations() {
    }

    private static /* synthetic */ void dividerType$annotations() {
    }

    private static /* synthetic */ void curvedArcDirection$annotations() {
    }

    private final void initAttrsAndDefault(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.WheelView);
        this.textSize = ta.getDimension(R.styleable.WheelView_wv_textSize, DEFAULT_TEXT_SIZE);
        this.isAutoFitTextSize = ta.getBoolean(R.styleable.WheelView_wv_autoFitTextSize, false);
        this.textAlign = ta.getInt(R.styleable.WheelView_wv_textAlign, 1);
        this.textBoundaryMargin = ta.getDimension(R.styleable.WheelView_wv_textBoundaryMargin, DEFAULT_TEXT_BOUNDARY_MARGIN);
        this.textColor = ta.getColor(R.styleable.WheelView_wv_normalItemTextColor, -12303292);
        this.selectedItemTextColor = ta.getColor(R.styleable.WheelView_wv_selectedItemTextColor, -16777216);
        this.lineSpacing = ta.getDimension(R.styleable.WheelView_wv_lineSpacing, DEFAULT_LINE_SPACING);
        this.isIntegerNeedFormat = ta.getBoolean(R.styleable.WheelView_wv_integerNeedFormat, false);
        String string = ta.getString(R.styleable.WheelView_wv_integerFormat);
        if (string == null) {
            string = DEFAULT_INTEGER_FORMAT;
        }
        this.integerFormat = string;
        this.visibleItems = ta.getInt(R.styleable.WheelView_wv_visibleItems, 5);
        this.visibleItems = this.adjustVisibleItems(this.visibleItems);
        this.currentScrollPosition = this.selectedItemPosition = ta.getInt(R.styleable.WheelView_wv_selectedItemPosition, 0);
        this.isCyclic = ta.getBoolean(R.styleable.WheelView_wv_cyclic, false);
        this.isShowDivider = ta.getBoolean(R.styleable.WheelView_wv_showDivider, false);
        this.dividerType = ta.getInt(R.styleable.WheelView_wv_dividerType, 0);
        this.dividerSize = ta.getDimension(R.styleable.WheelView_wv_dividerHeight, DEFAULT_DIVIDER_HEIGHT);
        this.dividerColor = ta.getColor(R.styleable.WheelView_wv_dividerColor, -16777216);
        this.dividerPaddingForWrap = ta.getDimension(R.styleable.WheelView_wv_dividerPaddingForWrap, DEFAULT_TEXT_BOUNDARY_MARGIN);
        this.isDrawSelectedRect = ta.getBoolean(R.styleable.WheelView_wv_drawSelectedRect, false);
        this.selectedRectColor = ta.getColor(R.styleable.WheelView_wv_selectedRectColor, 0);
        this.isCurved = ta.getBoolean(R.styleable.WheelView_wv_curved, true);
        this.curvedArcDirection = ta.getInt(R.styleable.WheelView_wv_curvedArcDirection, 1);
        this.curvedArcDirectionFactor = ta.getFloat(R.styleable.WheelView_wv_curvedArcDirectionFactor, 0.75f);
        this.curvedRefractRatio = ta.getFloat(R.styleable.WheelView_wv_curvedRefractRatio, 0.9f);
        if (this.curvedRefractRatio > 1.0f) {
            this.curvedRefractRatio = 1.0f;
        } else if (this.curvedRefractRatio < 0.0f) {
            this.curvedRefractRatio = 0.9f;
        }
        ta.recycle();
    }

    private final void initValue(Context context) {
        ViewConfiguration viewConfiguration;
        ViewConfiguration viewConfiguration2 = viewConfiguration = ViewConfiguration.get((Context)context);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewConfiguration2, (String)"viewConfiguration");
        this.maxFlingVelocity = viewConfiguration2.getScaledMaximumFlingVelocity();
        this.minFlingVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.initDefaultVolume(context);
        this.calculateTextSize();
        this.updateTextAlign();
    }

    public final int getTextAlign() {
        return this.textAlign;
    }

    public final void setTextAlign(int textAlign) {
        if (this.textAlign == textAlign) {
            return;
        }
        this.textAlign = textAlign;
        this.updateTextAlign();
        this.calculateDrawStart();
        this.invalidate();
    }

    public final int getNormalItemTextColor() {
        return this.textColor;
    }

    public final void setNormalItemTextColor(@ColorInt int textColor) {
        if (this.textColor == textColor) {
            return;
        }
        this.textColor = textColor;
        this.invalidate();
    }

    public final void setNormalItemTextColorRes(@ColorRes int textColorRes) {
        this.setNormalItemTextColor(ContextCompat.getColor((Context)this.getContext(), (int)textColorRes));
    }

    public final int getSelectedItemTextColor() {
        return this.selectedItemTextColor;
    }

    public final void setSelectedItemTextColor(@ColorInt int selectedItemTextColor) {
        if (this.selectedItemTextColor == selectedItemTextColor) {
            return;
        }
        this.selectedItemTextColor = selectedItemTextColor;
        this.invalidate();
    }

    public final void setSelectedItemTextColorRes(@ColorRes int selectedItemColorRes) {
        this.setSelectedItemTextColor(ContextCompat.getColor((Context)this.getContext(), (int)selectedItemColorRes));
    }

    public final float getTextBoundaryMargin() {
        return this.textBoundaryMargin;
    }

    public final void setTextBoundaryMargin(float textBoundaryMargin) {
        this.setTextBoundaryMargin(textBoundaryMargin, false);
    }

    public final void setTextBoundaryMargin(float textBoundaryMargin, boolean isDp) {
        float tempTextBoundaryMargin = this.textBoundaryMargin;
        float f = this.textBoundaryMargin = isDp ? WheelView.Companion.dp2px(textBoundaryMargin) : textBoundaryMargin;
        if (tempTextBoundaryMargin == this.textBoundaryMargin) {
            return;
        }
        this.requestLayout();
        this.invalidate();
    }

    @NotNull
    public final String getIntegerFormat() {
        return this.integerFormat;
    }

    public final void setIntegerFormat(@NotNull String integerFormat) {
        Intrinsics.checkParameterIsNotNull((Object)integerFormat, (String)"integerFormat");
        CharSequence charSequence = integerFormat;
        boolean bl = false;
        if (charSequence.length() == 0 || Intrinsics.areEqual((Object)integerFormat, (Object)this.integerFormat)) {
            return;
        }
        this.integerFormat = integerFormat;
        this.calculateTextSize();
        this.requestLayout();
        this.invalidate();
    }

    public final int getVisibleItems() {
        return this.visibleItems;
    }

    public final void setVisibleItems(int visibleItems) {
        if (this.visibleItems == visibleItems) {
            return;
        }
        this.visibleItems = this.adjustVisibleItems(visibleItems);
        this.scrollOffsetY = 0;
        this.requestLayout();
        this.invalidate();
    }

    public final int getSelectedItemPosition() {
        return this.selectedItemPosition;
    }

    public final int getDividerColor() {
        return this.dividerColor;
    }

    public final void setDividerColor(@ColorInt int dividerColor) {
        if (this.dividerColor == dividerColor) {
            return;
        }
        this.dividerColor = dividerColor;
        this.invalidate();
    }

    public final void setDividerColorRes(@ColorRes int dividerColorRes) {
        this.setDividerColor(ContextCompat.getColor((Context)this.getContext(), (int)dividerColorRes));
    }

    public final float getDividerHeight() {
        return this.dividerSize;
    }

    public final void setDividerHeight(float dividerHeight) {
        this.setDividerHeight(dividerHeight, false);
    }

    public final void setDividerHeight(float dividerHeight, boolean isDp) {
        float tempDividerHeight = this.dividerSize;
        float f = this.dividerSize = isDp ? WheelView.Companion.dp2px(dividerHeight) : dividerHeight;
        if (tempDividerHeight == this.dividerSize) {
            return;
        }
        this.invalidate();
    }

    public final int getDividerType() {
        return this.dividerType;
    }

    public final void setDividerType(int dividerType) {
        if (this.dividerType == dividerType) {
            return;
        }
        this.dividerType = dividerType;
        this.invalidate();
    }

    public final float getDividerPaddingForWrap() {
        return this.dividerPaddingForWrap;
    }

    public final void setDividerPaddingForWrap(float dividerPaddingForWrap) {
        this.setDividerPaddingForWrap(dividerPaddingForWrap, false);
    }

    public final void setDividerPaddingForWrap(float dividerPaddingForWrap, boolean isDp) {
        float tempDividerPadding = this.dividerPaddingForWrap;
        float f = this.dividerPaddingForWrap = isDp ? WheelView.Companion.dp2px(dividerPaddingForWrap) : dividerPaddingForWrap;
        if (tempDividerPadding == this.dividerPaddingForWrap) {
            return;
        }
        this.invalidate();
    }

    @NotNull
    public final Paint.Cap getDividerCap() {
        return this.dividerCap;
    }

    public final void setDividerCap(@NotNull Paint.Cap dividerCap) {
        Intrinsics.checkParameterIsNotNull((Object)dividerCap, (String)"dividerCap");
        if (this.dividerCap == dividerCap) {
            return;
        }
        this.dividerCap = dividerCap;
        this.invalidate();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.soundHelper.release();
    }

    private final void initDefaultVolume(Context context) {
        Object audioManager = context.getSystemService("audio");
        if (audioManager != null) {
            AudioManager cfr_ignored_0 = (AudioManager)audioManager;
            int currentVolume = ((AudioManager)audioManager).getStreamVolume(3);
            int maxVolume = ((AudioManager)audioManager).getStreamMaxVolume(3);
            this.soundHelper.setPlayVolume((float)currentVolume * 1.0f / (float)maxVolume);
        } else {
            this.soundHelper.setPlayVolume(0.3f);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateTextSize() {
        this.paint.setTextSize(this.textSize);
        int n = 0;
        int n2 = ((Collection)this.dataItems).size();
        while (n < n2) {
            void i;
            int textWidth = (int)this.paint.measureText(this.getDataText(this.dataItems.get((int)i)));
            this.maxTextWidth = RangesKt.coerceAtLeast((int)textWidth, (int)this.maxTextWidth);
            ++i;
        }
        Paint.FontMetrics fontMetrics = this.fontMetrics = this.paint.getFontMetrics();
        if (fontMetrics == null) {
            Intrinsics.throwNpe();
        }
        float f = fontMetrics.bottom;
        Paint.FontMetrics fontMetrics2 = this.fontMetrics;
        if (fontMetrics2 == null) {
            Intrinsics.throwNpe();
        }
        this.itemHeight = (int)(f - fontMetrics2.top + this.lineSpacing);
    }

    private final void updateTextAlign() {
        switch (this.textAlign) {
            case 0: {
                this.paint.setTextAlign(Paint.Align.LEFT);
                break;
            }
            case 2: {
                this.paint.setTextAlign(Paint.Align.RIGHT);
                break;
            }
            default: {
                this.paint.setTextAlign(Paint.Align.CENTER);
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = this.isCurved ? (int)((double)(this.itemHeight * this.visibleItems * 2) / Math.PI + (double)this.getPaddingTop() + (double)this.getPaddingBottom()) : this.itemHeight * this.visibleItems + this.getPaddingTop() + this.getPaddingBottom();
        int width = (int)((float)this.maxTextWidth + (float)this.getPaddingLeft() + (float)this.getPaddingRight() + this.textBoundaryMargin * (float)2);
        if (this.isCurved) {
            double d = 0.06544984694978735;
            boolean bl = false;
            int towardRange = (int)(Math.sin(d) * (double)height);
            width += towardRange;
        }
        this.setMeasuredDimension(View.resolveSizeAndState((int)width, (int)widthMeasureSpec, (int)0), View.resolveSizeAndState((int)height, (int)heightMeasureSpec, (int)0));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.drawRect.set(this.getPaddingLeft(), this.getPaddingTop(), this.getWidth() - this.getPaddingRight(), this.getHeight() - this.getPaddingBottom());
        this.centerX = this.drawRect.centerX();
        this.centerY = this.drawRect.centerY();
        this.selectedItemTopLimit = this.centerY - this.itemHeight / 2;
        this.selectedItemBottomLimit = this.centerY + this.itemHeight / 2;
        this.clipLeft = this.getPaddingLeft();
        this.clipTop = this.getPaddingTop();
        this.clipRight = this.getWidth() - this.getPaddingRight();
        this.clipBottom = this.getHeight() - this.getPaddingBottom();
        this.calculateDrawStart();
        this.calculateLimitY();
    }

    private final void calculateDrawStart() {
        int n;
        switch (this.textAlign) {
            case 0: {
                n = (int)((float)this.getPaddingLeft() + this.textBoundaryMargin);
                break;
            }
            case 2: {
                n = (int)((float)(this.getWidth() - this.getPaddingRight()) - this.textBoundaryMargin);
                break;
            }
            default: {
                n = this.getWidth() / 2;
            }
        }
        this.startX = n;
        Paint.FontMetrics fontMetrics = this.fontMetrics;
        if (fontMetrics == null) {
            Intrinsics.throwNpe();
        }
        float f = fontMetrics.ascent;
        Paint.FontMetrics fontMetrics2 = this.fontMetrics;
        if (fontMetrics2 == null) {
            Intrinsics.throwNpe();
        }
        float f2 = fontMetrics2.descent;
        Paint.FontMetrics fontMetrics3 = this.fontMetrics;
        if (fontMetrics3 == null) {
            Intrinsics.throwNpe();
        }
        this.centerToBaselineY = (int)(f + (f2 - fontMetrics3.ascent) / (float)2);
    }

    private final void calculateLimitY() {
        this.minScrollY = this.isCyclic ? Integer.MIN_VALUE : 0;
        this.maxScrollY = this.isCyclic ? Integer.MAX_VALUE : (this.dataItems.size() - 1) * this.itemHeight;
    }

    /*
     * WARNING - void declaration
     */
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.drawSelectedRect(canvas);
        this.drawDivider(canvas);
        int scrolledItem = this.scrollOffsetY / this.itemHeight;
        int scrolledOffset = this.scrollOffsetY % this.itemHeight;
        int halfItem = (this.visibleItems + 1) / 2;
        int minIndex = 0;
        int maxIndex = 0;
        if (scrolledOffset < 0) {
            minIndex = scrolledItem - halfItem - 1;
            maxIndex = scrolledItem + halfItem;
        } else if (scrolledOffset > 0) {
            minIndex = scrolledItem - halfItem;
            maxIndex = scrolledItem + halfItem + 1;
        } else {
            minIndex = scrolledItem - halfItem;
            maxIndex = scrolledItem + halfItem;
        }
        int n = minIndex;
        int n2 = maxIndex;
        while (n < n2) {
            void i;
            if (this.isCurved) {
                this.draw3DItem(canvas, (int)i, scrolledOffset);
            } else {
                this.drawItem(canvas, (int)i, scrolledOffset);
            }
            ++i;
        }
    }

    private final void drawSelectedRect(Canvas canvas) {
        if (this.isDrawSelectedRect) {
            this.paint.setColor(this.selectedRectColor);
            canvas.drawRect((float)this.clipLeft, (float)this.selectedItemTopLimit, (float)this.clipRight, (float)this.selectedItemBottomLimit, this.paint);
        }
    }

    private final void drawDivider(Canvas canvas) {
        if (this.isShowDivider) {
            this.paint.setColor(this.dividerColor);
            float originStrokeWidth = this.paint.getStrokeWidth();
            this.paint.setStrokeJoin(Paint.Join.ROUND);
            this.paint.setStrokeCap(Paint.Cap.ROUND);
            this.paint.setStrokeWidth(this.dividerSize);
            if (this.dividerType == 0) {
                canvas.drawLine((float)this.clipLeft, (float)this.selectedItemTopLimit, (float)this.clipRight, (float)this.selectedItemTopLimit, this.paint);
                canvas.drawLine((float)this.clipLeft, (float)this.selectedItemBottomLimit, (float)this.clipRight, (float)this.selectedItemBottomLimit, this.paint);
            } else {
                int startX = (int)((float)this.centerX - (float)(this.maxTextWidth / 2) - this.dividerPaddingForWrap);
                int stopX = (int)((float)this.centerX + (float)(this.maxTextWidth / 2) + this.dividerPaddingForWrap);
                int wrapStartX = startX < this.clipLeft ? this.clipLeft : startX;
                int wrapStopX = stopX > this.clipRight ? this.clipRight : stopX;
                canvas.drawLine((float)wrapStartX, (float)this.selectedItemTopLimit, (float)wrapStopX, (float)this.selectedItemTopLimit, this.paint);
                canvas.drawLine((float)wrapStartX, (float)this.selectedItemBottomLimit, (float)wrapStopX, (float)this.selectedItemBottomLimit, this.paint);
            }
            this.paint.setStrokeWidth(originStrokeWidth);
        }
    }

    private final void drawItem(Canvas canvas, int index, int scrolledOffset) {
        String string = this.getDataByIndex(index);
        if (string == null) {
            return;
        }
        String text = string;
        int item2CenterOffsetY = (index - this.scrollOffsetY / this.itemHeight) * this.itemHeight - scrolledOffset;
        int startX = this.startX;
        int centerToBaselineY = this.isAutoFitTextSize ? this.remeasureTextSize(text) : this.centerToBaselineY;
        boolean bl = false;
        if (Math.abs(item2CenterOffsetY) <= 0) {
            this.paint.setColor(this.selectedItemTextColor);
            this.clipAndDraw2DText(canvas, text, this.selectedItemTopLimit, this.selectedItemBottomLimit, item2CenterOffsetY, centerToBaselineY);
        } else if (item2CenterOffsetY > 0 && item2CenterOffsetY < this.itemHeight) {
            this.paint.setColor(this.selectedItemTextColor);
            this.clipAndDraw2DText(canvas, text, this.selectedItemTopLimit, this.selectedItemBottomLimit, item2CenterOffsetY, centerToBaselineY);
            this.paint.setColor(this.textColor);
            this.clipAndDraw2DText(canvas, text, this.selectedItemBottomLimit, this.clipBottom, item2CenterOffsetY, centerToBaselineY);
        } else if (item2CenterOffsetY < 0 && item2CenterOffsetY > -this.itemHeight) {
            this.paint.setColor(this.selectedItemTextColor);
            this.clipAndDraw2DText(canvas, text, this.selectedItemTopLimit, this.selectedItemBottomLimit, item2CenterOffsetY, centerToBaselineY);
            this.paint.setColor(this.textColor);
            this.clipAndDraw2DText(canvas, text, this.clipTop, this.selectedItemTopLimit, item2CenterOffsetY, centerToBaselineY);
        } else {
            this.paint.setColor(this.textColor);
            this.clipAndDraw2DText(canvas, text, this.clipTop, this.clipBottom, item2CenterOffsetY, centerToBaselineY);
        }
        if (this.isAutoFitTextSize) {
            this.paint.setTextSize(this.textSize);
            this.startX = startX;
        }
    }

    private final void clipAndDraw2DText(Canvas canvas, String text, int clipTop, int clipBottom, int item2CenterOffsetY, int centerToBaselineY) {
        canvas.save();
        canvas.clipRect(this.clipLeft, clipTop, this.clipRight, clipBottom);
        canvas.drawText(text, 0, text.length(), (float)this.startX, (float)(this.centerY + item2CenterOffsetY - centerToBaselineY), this.paint);
        canvas.restore();
    }

    private final int remeasureTextSize(String contentText) {
        float f;
        float textWidth = this.paint.measureText(contentText);
        float textMargin = this.textBoundaryMargin * (float)2;
        float drawWidth = this.getWidth();
        if (textMargin > drawWidth / 10.0f) {
            drawWidth = drawWidth * 9.0f / 10.0f;
            textMargin = drawWidth / 10.0f;
        } else {
            drawWidth -= textMargin;
        }
        if (drawWidth <= 0.0f) {
            return this.centerToBaselineY;
        }
        float textSize = this.textSize;
        while (textWidth > drawWidth && !((textSize = (f = textSize) + -1.0f) <= 0.0f)) {
            this.paint.setTextSize(textSize);
            textWidth = this.paint.measureText(contentText);
        }
        this.recalculateStartX(textMargin / 2.0f);
        return this.recalculateCenterToBaselineY();
    }

    private final void recalculateStartX(float textMargin) {
        int n;
        switch (this.textAlign) {
            case 0: {
                n = (int)textMargin;
                break;
            }
            case 2: {
                n = (int)((float)this.getWidth() - textMargin);
                break;
            }
            default: {
                n = this.getWidth() / 2;
            }
        }
        this.startX = n;
    }

    private final int recalculateCenterToBaselineY() {
        Paint.FontMetrics fontMetrics = this.paint.getFontMetrics();
        return (int)(fontMetrics.ascent + (fontMetrics.descent - fontMetrics.ascent) / (float)2);
    }

    private final void draw3DItem(Canvas canvas, int index, int scrolledOffset) {
        String string = this.getDataByIndex(index);
        if (string == null) {
            return;
        }
        String text = string;
        int radius = (this.getHeight() - this.getPaddingTop() - this.getPaddingBottom()) / 2;
        int item2CenterOffsetY = (index - this.scrollOffsetY / this.itemHeight) * this.itemHeight - scrolledOffset;
        boolean bl = false;
        if ((double)Math.abs(item2CenterOffsetY) > (double)radius * Math.PI / (double)2) {
            return;
        }
        double angle = (double)item2CenterOffsetY / (double)radius;
        float rotateX = (float)Math.toDegrees(-angle);
        boolean bl2 = false;
        float translateY = (float)(Math.sin(angle) * (double)radius);
        double d = 1.0;
        boolean bl3 = false;
        double d2 = Math.cos(angle);
        float translateZ = (float)((d - d2) * (double)radius);
        boolean bl4 = false;
        int alpha = (int)(Math.cos(angle) * (double)255);
        int startX = this.startX;
        int centerToBaselineY = this.isAutoFitTextSize ? this.remeasureTextSize(text) : this.centerToBaselineY;
        int n = 0;
        if (Math.abs(item2CenterOffsetY) <= 0) {
            this.paint.setColor(this.selectedItemTextColor);
            this.paint.setAlpha(255);
            this.clipAndDraw3DText(canvas, text, this.selectedItemTopLimit, this.selectedItemBottomLimit, rotateX, translateY, translateZ, centerToBaselineY);
        } else {
            n = item2CenterOffsetY;
            if (1 <= n && this.itemHeight > n) {
                this.paint.setColor(this.selectedItemTextColor);
                this.paint.setAlpha(255);
                this.clipAndDraw3DText(canvas, text, this.selectedItemTopLimit, this.selectedItemBottomLimit, rotateX, translateY, translateZ, centerToBaselineY);
                this.paint.setColor(this.textColor);
                this.paint.setAlpha(alpha);
                float textSize = this.paint.getTextSize();
                this.paint.setTextSize(textSize * this.curvedRefractRatio);
                int reCenterToBaselineY = this.recalculateCenterToBaselineY();
                this.clipAndDraw3DText(canvas, text, this.selectedItemBottomLimit, this.clipBottom, rotateX, translateY, translateZ, reCenterToBaselineY);
                this.paint.setTextSize(textSize);
            } else if (item2CenterOffsetY < 0 && item2CenterOffsetY > -this.itemHeight) {
                this.paint.setColor(this.selectedItemTextColor);
                this.paint.setAlpha(255);
                this.clipAndDraw3DText(canvas, text, this.selectedItemTopLimit, this.selectedItemBottomLimit, rotateX, translateY, translateZ, centerToBaselineY);
                this.paint.setColor(this.textColor);
                this.paint.setAlpha(alpha);
                float textSize = this.paint.getTextSize();
                this.paint.setTextSize(textSize * this.curvedRefractRatio);
                int reCenterToBaselineY = this.recalculateCenterToBaselineY();
                this.clipAndDraw3DText(canvas, text, this.clipTop, this.selectedItemTopLimit, rotateX, translateY, translateZ, reCenterToBaselineY);
                this.paint.setTextSize(textSize);
            } else {
                this.paint.setColor(this.textColor);
                this.paint.setAlpha(alpha);
                float textSize = this.paint.getTextSize();
                this.paint.setTextSize(textSize * this.curvedRefractRatio);
                int reCenterToBaselineY = this.recalculateCenterToBaselineY();
                this.clipAndDraw3DText(canvas, text, this.clipTop, this.clipBottom, rotateX, translateY, translateZ, reCenterToBaselineY);
                this.paint.setTextSize(textSize);
            }
        }
        if (this.isAutoFitTextSize) {
            this.paint.setTextSize(this.textSize);
            this.startX = startX;
        }
    }

    private final void clipAndDraw3DText(Canvas canvas, String text, int clipTop, int clipBottom, float rotateX, float offsetY, float offsetZ, int centerToBaselineY) {
        canvas.save();
        canvas.clipRect(this.clipLeft, clipTop, this.clipRight, clipBottom);
        this.draw3DText(canvas, text, rotateX, offsetY, offsetZ, centerToBaselineY);
        canvas.restore();
    }

    private final void draw3DText(Canvas canvas, String text, float rotateX, float offsetY, float offsetZ, int centerToBaselineY) {
        this.camera.save();
        this.camera.translate(0.0f, 0.0f, offsetZ);
        this.camera.rotateX(rotateX);
        this.camera.getMatrix(this.mMatrix);
        this.camera.restore();
        float centerX = this.centerX;
        if (this.curvedArcDirection == 0) {
            centerX = (float)this.centerX * (1.0f + this.curvedArcDirectionFactor);
        } else if (this.curvedArcDirection == 2) {
            centerX = (float)this.centerX * (1.0f - this.curvedArcDirectionFactor);
        }
        float centerY = (float)this.centerY + offsetY;
        this.mMatrix.preTranslate(-centerX, -centerY);
        this.mMatrix.postTranslate(centerX, centerY);
        canvas.concat(this.mMatrix);
        canvas.drawText(text, 0, text.length(), (float)this.startX, centerY - (float)centerToBaselineY, this.paint);
    }

    private final String getDataByIndex(int index) {
        int dataSize = this.dataItems.size();
        if (dataSize == 0) {
            return null;
        }
        String itemText = null;
        if (this.isCyclic) {
            int i = index % dataSize;
            if (i < 0) {
                i += dataSize;
            }
            itemText = this.getDataText(this.dataItems.get(i));
        } else {
            int n = index;
            if (0 <= n && dataSize > n) {
                itemText = this.getDataText(this.dataItems.get(index));
            }
        }
        return itemText;
    }

    private final String getDataText(Object item) {
        String string;
        Object object = item;
        if (object == null) {
            string = "";
        } else if (object instanceof Integer) {
            if (this.isIntegerNeedFormat) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Locale locale = Locale.getDefault();
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
                Locale locale2 = locale;
                String string2 = this.integerFormat;
                Object[] objectArray = new Object[]{item};
                boolean bl = false;
                String string3 = String.format(locale2, string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
            } else {
                string = item.toString();
            }
        } else {
            string = object instanceof String ? (String)item : item.toString();
        }
        return string;
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.initVelocityTracker();
        VelocityTracker velocityTracker = this.velocityTracker;
        if (velocityTracker == null) {
            Intrinsics.throwNpe();
        }
        velocityTracker.addMovement(event);
        switch (event.getActionMasked()) {
            case 0: {
                if (this.getParent() != null) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                if (!this.overScroller.isFinished()) {
                    this.overScroller.forceFinished(true);
                    this.isForceFinishScroll = true;
                }
                this.lastTouchY = event.getY();
                this.downStartTime = System.currentTimeMillis();
                break;
            }
            case 2: {
                float moveY = event.getY();
                float deltaY = moveY - this.lastTouchY;
                if (this.onWheelChangedListener != null) {
                    OnWheelChangedListener onWheelChangedListener = this.onWheelChangedListener;
                    if (onWheelChangedListener == null) {
                        Intrinsics.throwNpe();
                    }
                    onWheelChangedListener.onWheelScrollStateChanged(1);
                }
                boolean bl = false;
                if (!(Math.abs(deltaY) >= 1.0f)) break;
                this.doScroll((int)(-deltaY));
                this.lastTouchY = moveY;
                this.invalidateIfYChanged();
                break;
            }
            case 1: {
                this.isForceFinishScroll = false;
                VelocityTracker velocityTracker2 = this.velocityTracker;
                if (velocityTracker2 == null) {
                    Intrinsics.throwNpe();
                }
                velocityTracker2.computeCurrentVelocity(1000, (float)this.maxFlingVelocity);
                VelocityTracker velocityTracker3 = this.velocityTracker;
                if (velocityTracker3 == null) {
                    Intrinsics.throwNpe();
                }
                float velocityY = velocityTracker3.getYVelocity();
                boolean deltaY = false;
                if (Math.abs(velocityY) > (float)this.minFlingVelocity) {
                    this.overScroller.forceFinished(true);
                    this.isFlingScroll = true;
                    this.overScroller.fling(0, this.scrollOffsetY, 0, (int)(-velocityY), 0, 0, this.minScrollY, this.maxScrollY);
                } else {
                    int clickToCenterDistance = 0;
                    if (System.currentTimeMillis() - this.downStartTime <= 120L) {
                        clickToCenterDistance = (int)(event.getY() - (float)this.centerY);
                    }
                    int scrollRange = clickToCenterDistance + this.calculateDistanceToEndPoint((this.scrollOffsetY + clickToCenterDistance) % this.itemHeight);
                    this.overScroller.startScroll(0, this.scrollOffsetY, 0, scrollRange);
                }
                this.invalidateIfYChanged();
                ViewCompat.postOnAnimation((View)this, (Runnable)this);
                this.recycleVelocityTracker();
                break;
            }
            case 3: {
                this.recycleVelocityTracker();
            }
        }
        return true;
    }

    private final void initVelocityTracker() {
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
    }

    private final void recycleVelocityTracker() {
        if (this.velocityTracker != null) {
            VelocityTracker velocityTracker = this.velocityTracker;
            if (velocityTracker == null) {
                Intrinsics.throwNpe();
            }
            velocityTracker.recycle();
            this.velocityTracker = null;
        }
    }

    private final void doScroll(int distance) {
        this.scrollOffsetY += distance;
        if (!this.isCyclic) {
            if (this.scrollOffsetY < this.minScrollY) {
                this.scrollOffsetY = this.minScrollY;
            } else if (this.scrollOffsetY > this.maxScrollY) {
                this.scrollOffsetY = this.maxScrollY;
            }
        }
    }

    private final void invalidateIfYChanged() {
        if (this.scrollOffsetY != this.scrolledY) {
            this.scrolledY = this.scrollOffsetY;
            if (this.onWheelChangedListener != null) {
                OnWheelChangedListener onWheelChangedListener = this.onWheelChangedListener;
                if (onWheelChangedListener == null) {
                    Intrinsics.throwNpe();
                }
                onWheelChangedListener.onWheelScroll(this.scrollOffsetY);
            }
            this.observeItemChanged();
            this.invalidate();
        }
        this.selectedItemPosition = this.currentScrollPosition;
        if (this.onItemSelectedListener != null) {
            OnItemSelectedListener onItemSelectedListener = this.onItemSelectedListener;
            if (onItemSelectedListener == null) {
                Intrinsics.throwNpe();
            }
            onItemSelectedListener.onItemSelected(this, this.dataItems.get(this.currentScrollPosition), this.currentScrollPosition);
        }
    }

    private final void observeItemChanged() {
        int oldPosition = this.currentScrollPosition;
        int newPosition = this.getCurrentPosition();
        if (oldPosition != newPosition) {
            if (this.onWheelChangedListener != null) {
                OnWheelChangedListener onWheelChangedListener = this.onWheelChangedListener;
                if (onWheelChangedListener == null) {
                    Intrinsics.throwNpe();
                }
                onWheelChangedListener.onWheelItemChanged(oldPosition, newPosition);
            }
            this.playSoundEffect();
            this.currentScrollPosition = newPosition;
        }
    }

    public final void playSoundEffect() {
        if (this.isSoundEffect) {
            this.soundHelper.playSoundEffect();
        }
    }

    public final void forceFinishScroll() {
        if (!this.overScroller.isFinished()) {
            this.overScroller.forceFinished(true);
        }
    }

    public final void abortFinishScroll() {
        if (!this.overScroller.isFinished()) {
            this.overScroller.abortAnimation();
        }
    }

    private final int calculateDistanceToEndPoint(int remainder) {
        boolean bl = false;
        return Math.abs(remainder) > this.itemHeight / 2 ? (this.scrollOffsetY < 0 ? -this.itemHeight - remainder : this.itemHeight - remainder) : -remainder;
    }

    @Override
    public void run() {
        if (this.overScroller.isFinished() && !this.isForceFinishScroll && !this.isFlingScroll) {
            int currentItemPosition;
            if (this.itemHeight == 0) {
                return;
            }
            if (this.onWheelChangedListener != null) {
                OnWheelChangedListener onWheelChangedListener = this.onWheelChangedListener;
                if (onWheelChangedListener == null) {
                    Intrinsics.throwNpe();
                }
                onWheelChangedListener.onWheelScrollStateChanged(0);
            }
            if ((currentItemPosition = this.getCurrentPosition()) == this.selectedItemPosition) {
                return;
            }
            this.currentScrollPosition = this.selectedItemPosition = currentItemPosition;
            if (this.onItemSelectedListener != null) {
                OnItemSelectedListener onItemSelectedListener = this.onItemSelectedListener;
                if (onItemSelectedListener == null) {
                    Intrinsics.throwNpe();
                }
                onItemSelectedListener.onItemSelected(this, this.dataItems.get(this.selectedItemPosition), this.selectedItemPosition);
            }
            if (this.onWheelChangedListener != null) {
                OnWheelChangedListener onWheelChangedListener = this.onWheelChangedListener;
                if (onWheelChangedListener == null) {
                    Intrinsics.throwNpe();
                }
                onWheelChangedListener.onWheelSelected(this.selectedItemPosition);
            }
        }
        if (this.overScroller.computeScrollOffset()) {
            int oldY = this.scrollOffsetY;
            this.scrollOffsetY = this.overScroller.getCurrY();
            if (oldY != this.scrollOffsetY && this.onWheelChangedListener != null) {
                OnWheelChangedListener onWheelChangedListener = this.onWheelChangedListener;
                if (onWheelChangedListener == null) {
                    Intrinsics.throwNpe();
                }
                onWheelChangedListener.onWheelScrollStateChanged(2);
            }
            this.invalidateIfYChanged();
            ViewCompat.postOnAnimation((View)this, (Runnable)this);
        } else if (this.isFlingScroll) {
            this.isFlingScroll = false;
            this.overScroller.startScroll(0, this.scrollOffsetY, 0, this.calculateDistanceToEndPoint(this.scrollOffsetY % this.itemHeight));
            this.invalidateIfYChanged();
            ViewCompat.postOnAnimation((View)this, (Runnable)this);
        }
    }

    private final int getCurrentPosition() {
        int itemPosition = this.scrollOffsetY < 0 ? (this.scrollOffsetY - this.itemHeight / 2) / this.itemHeight : (this.scrollOffsetY + this.itemHeight / 2) / this.itemHeight;
        int currentPosition = itemPosition % this.dataItems.size();
        if (currentPosition < 0) {
            currentPosition += this.dataItems.size();
        }
        return currentPosition;
    }

    public final boolean isSoundEffect() {
        return this.isSoundEffect;
    }

    public final void setSoundEffect(boolean isSoundEffect) {
        this.isSoundEffect = isSoundEffect;
    }

    public final void setSoundEffectResource(@RawRes int rawResId) {
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        this.soundHelper.load(context, rawResId);
    }

    public final float getPlayVolume() {
        return this.soundHelper.getPlayVolume();
    }

    public final void setPlayVolume(@FloatRange(from=0.0, to=1.0) float playVolume) {
        this.soundHelper.setPlayVolume(playVolume);
    }

    @Nullable
    public final Object getItemData(int position) {
        if (this.isPositionInRange(position)) {
            return this.dataItems.get(position);
        }
        int n = this.dataItems.size();
        if (1 <= n && position >= n) {
            return this.dataItems.get(this.dataItems.size() - 1);
        }
        if (this.dataItems.size() > 0 && position < 0) {
            return this.dataItems.get(0);
        }
        return null;
    }

    @NotNull
    public final Object getSelectedItemData() {
        Object object = this.getItemData(this.selectedItemPosition);
        if (object == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public final List<Object> getDataItems() {
        return this.dataItems;
    }

    public final void setDataItems(@Nullable List<?> dataItems) {
        if (dataItems == null) {
            return;
        }
        this.dataItems.clear();
        this.dataItems.addAll(CollectionsKt.filterNotNull((Iterable)dataItems));
        if (!this.isResetSelectedPosition && this.dataItems.size() > 0) {
            if (this.selectedItemPosition >= this.dataItems.size()) {
                this.currentScrollPosition = this.selectedItemPosition = this.dataItems.size() - 1;
            }
        } else {
            this.currentScrollPosition = this.selectedItemPosition = 0;
        }
        this.forceFinishScroll();
        this.calculateTextSize();
        this.calculateLimitY();
        this.scrollOffsetY = this.selectedItemPosition * this.itemHeight;
        this.requestLayout();
        this.invalidate();
    }

    public final boolean isResetSelectedPosition() {
        return this.isResetSelectedPosition;
    }

    public final void setResetSelectedPosition(boolean isResetSelectedPosition) {
        this.isResetSelectedPosition = isResetSelectedPosition;
    }

    public final float getTextSize() {
        return this.textSize;
    }

    public final void setTextSize(float textSize, boolean isSp) {
        float tempTextSize = textSize;
        float f = this.textSize = isSp ? WheelView.Companion.sp2px(textSize) : textSize;
        if (tempTextSize == this.textSize) {
            return;
        }
        this.forceFinishScroll();
        this.calculateTextSize();
        this.calculateDrawStart();
        this.calculateLimitY();
        this.scrollOffsetY = this.selectedItemPosition * this.itemHeight;
        this.requestLayout();
        this.invalidate();
    }

    public static /* synthetic */ void setTextSize$default(WheelView wheelView, float f, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setTextSize");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        wheelView.setTextSize(f, bl);
    }

    public final boolean isAutoFitTextSize() {
        return this.isAutoFitTextSize;
    }

    public final void setAutoFitTextSize(boolean isAutoFitTextSize) {
        this.isAutoFitTextSize = isAutoFitTextSize;
        this.invalidate();
    }

    @NotNull
    public final Typeface getTypeface() {
        Typeface typeface = this.paint.getTypeface();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeface, (String)"paint.typeface");
        return typeface;
    }

    public final void setTypeface(@NotNull Typeface typeface) {
        Intrinsics.checkParameterIsNotNull((Object)typeface, (String)"typeface");
        if (this.paint.getTypeface() == typeface) {
            return;
        }
        this.forceFinishScroll();
        this.paint.setTypeface(typeface);
        this.calculateTextSize();
        this.calculateDrawStart();
        this.scrollOffsetY = this.selectedItemPosition * this.itemHeight;
        this.calculateLimitY();
        this.requestLayout();
        this.invalidate();
    }

    public final float getLineSpacing() {
        return this.lineSpacing;
    }

    public final void setLineSpacing(float lineSpacing, boolean isDp) {
        float tempLineSpace = lineSpacing;
        float f = this.lineSpacing = isDp ? WheelView.Companion.dp2px(lineSpacing) : lineSpacing;
        if (tempLineSpace == lineSpacing) {
            return;
        }
        this.scrollOffsetY = 0;
        this.calculateTextSize();
        this.requestLayout();
        this.invalidate();
    }

    public static /* synthetic */ void setLineSpacing$default(WheelView wheelView, float f, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setLineSpacing");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        wheelView.setLineSpacing(f, bl);
    }

    public final boolean isIntegerNeedFormat() {
        return this.isIntegerNeedFormat;
    }

    public final void setIntegerNeedFormat(boolean isIntegerNeedFormat) {
        if (this.isIntegerNeedFormat == isIntegerNeedFormat) {
            return;
        }
        this.isIntegerNeedFormat = isIntegerNeedFormat;
        this.calculateTextSize();
        this.requestLayout();
        this.invalidate();
    }

    public final void setIntegerNeedFormat(@NotNull String integerFormat) {
        Intrinsics.checkParameterIsNotNull((Object)integerFormat, (String)"integerFormat");
        this.isIntegerNeedFormat = true;
        this.integerFormat = integerFormat;
        this.calculateTextSize();
        this.requestLayout();
        this.invalidate();
    }

    private final int adjustVisibleItems(int visibleItems) {
        int n = visibleItems / 2 * 2 + 1;
        boolean bl = false;
        return Math.abs(n);
    }

    public final boolean isCyclic() {
        return this.isCyclic;
    }

    public final void setCyclic(boolean isCyclic) {
        if (this.isCyclic == isCyclic) {
            return;
        }
        this.isCyclic = isCyclic;
        this.forceFinishScroll();
        this.calculateLimitY();
        this.scrollOffsetY = this.selectedItemPosition * this.itemHeight;
        this.invalidate();
    }

    public final void setSelectedItemPosition(int position, boolean isSmoothScroll) {
        this.selectItemPosition = position;
        this.isSmoothScroll = isSmoothScroll;
        this.setSelectedItemPosition(position, isSmoothScroll, 0);
    }

    public static /* synthetic */ void setSelectedItemPosition$default(WheelView wheelView, int n, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setSelectedItemPosition");
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        wheelView.setSelectedItemPosition(n, bl);
    }

    public final void setSelectedItemPosition(int position, boolean isSmoothScroll, int smoothDuration) {
        if (!this.isPositionInRange(position)) {
            return;
        }
        int itemDistance = position * this.itemHeight - this.scrollOffsetY;
        this.abortFinishScroll();
        if (isSmoothScroll) {
            this.overScroller.startScroll(0, this.scrollOffsetY, 0, itemDistance, smoothDuration > 0 ? smoothDuration : 250);
            this.invalidateIfYChanged();
            ViewCompat.postOnAnimation((View)this, (Runnable)this);
        } else {
            this.doScroll(itemDistance);
            this.selectedItemPosition = position;
            if (this.onItemSelectedListener != null) {
                OnItemSelectedListener onItemSelectedListener = this.onItemSelectedListener;
                if (onItemSelectedListener == null) {
                    Intrinsics.throwNpe();
                }
                onItemSelectedListener.onItemSelected(this, this.dataItems.get(this.selectedItemPosition), this.selectedItemPosition);
            }
            if (this.onWheelChangedListener != null) {
                OnWheelChangedListener onWheelChangedListener = this.onWheelChangedListener;
                if (onWheelChangedListener == null) {
                    Intrinsics.throwNpe();
                }
                onWheelChangedListener.onWheelSelected(this.selectedItemPosition);
            }
            this.invalidateIfYChanged();
        }
    }

    public final boolean isPositionInRange(int position) {
        return position >= 0 && position < this.dataItems.size();
    }

    public final boolean isShowDivider() {
        return this.isShowDivider;
    }

    public final void setShowDivider(boolean isShowDivider) {
        if (this.isShowDivider == isShowDivider) {
            return;
        }
        this.isShowDivider = isShowDivider;
        this.invalidate();
    }

    public final boolean isDrawSelectedRect() {
        return this.isDrawSelectedRect;
    }

    public final void setDrawSelectedRect(boolean isDrawSelectedRect) {
        this.isDrawSelectedRect = isDrawSelectedRect;
        this.invalidate();
    }

    public final int getSelectedRectColor() {
        return this.selectedRectColor;
    }

    public final void setSelectedRectColor(@ColorInt int selectedRectColor) {
        this.selectedRectColor = selectedRectColor;
        this.invalidate();
    }

    public final void setSelectedRectColorRes(@ColorRes int selectedRectColorRes) {
        this.setSelectedRectColor(ContextCompat.getColor((Context)this.getContext(), (int)selectedRectColorRes));
    }

    public final boolean isCurved() {
        return this.isCurved;
    }

    public final void setCurved(boolean isCurved) {
        if (this.isCurved == isCurved) {
            return;
        }
        this.isCurved = isCurved;
        this.calculateTextSize();
        this.requestLayout();
        this.invalidate();
    }

    public final int getCurvedArcDirection() {
        return this.curvedArcDirection;
    }

    public final void setCurvedArcDirection(int curvedArcDirection) {
        if (this.curvedArcDirection == curvedArcDirection) {
            return;
        }
        this.curvedArcDirection = curvedArcDirection;
        this.invalidate();
    }

    public final float getCurvedArcDirectionFactor() {
        return this.curvedArcDirectionFactor;
    }

    public final void setCurvedArcDirectionFactor(@FloatRange(from=0.0, to=1.0) float curvedArcDirectionFactor) {
        float tempcurvedArcDirectionFactor = curvedArcDirectionFactor;
        if (this.curvedArcDirectionFactor == tempcurvedArcDirectionFactor) {
            return;
        }
        if (curvedArcDirectionFactor < 0.0f) {
            tempcurvedArcDirectionFactor = 0.0f;
        } else if (curvedArcDirectionFactor > 1.0f) {
            tempcurvedArcDirectionFactor = 1.0f;
        }
        this.curvedArcDirectionFactor = tempcurvedArcDirectionFactor;
        this.invalidate();
    }

    public final float getCurvedRefractRatio() {
        return this.curvedRefractRatio;
    }

    public final void setCurvedRefractRatio(@FloatRange(from=0.0, to=1.0) float curvedRefractRatio) {
        float tempRefractRatio = this.curvedRefractRatio;
        this.curvedRefractRatio = curvedRefractRatio;
        if (this.curvedRefractRatio > 1.0f) {
            this.curvedRefractRatio = 1.0f;
        } else if (this.curvedRefractRatio < 0.0f) {
            this.curvedRefractRatio = 0.9f;
        }
        if (tempRefractRatio == this.curvedRefractRatio) {
            return;
        }
        this.invalidate();
    }

    @Nullable
    public final OnItemSelectedListener getOnItemSelectedListener() {
        return this.onItemSelectedListener;
    }

    public final void setOnItemSelectedListener(@NotNull OnItemSelectedListener onItemSelectedListener) {
        Intrinsics.checkParameterIsNotNull((Object)onItemSelectedListener, (String)"onItemSelectedListener");
        this.onItemSelectedListener = onItemSelectedListener;
        this.setSelectedItemPosition(this.selectedItemPosition, this.isSmoothScroll, 0);
    }

    @Nullable
    public final OnWheelChangedListener getOnWheelChangedListener() {
        return this.onWheelChangedListener;
    }

    public final void setOnWheelChangedListener(@NotNull OnWheelChangedListener onWheelChangedListener) {
        Intrinsics.checkParameterIsNotNull((Object)onWheelChangedListener, (String)"onWheelChangedListener");
        this.onWheelChangedListener = onWheelChangedListener;
    }

    @JvmOverloads
    public WheelView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.paint = new Paint(1);
        this.dividerCap = Paint.Cap.ROUND;
        this.drawRect = new Rect();
        this.integerFormat = DEFAULT_INTEGER_FORMAT;
        this.camera = new Camera();
        this.mMatrix = new Matrix();
        WheelView wheelView = this;
        boolean bl = false;
        wheelView.dataItems = list = (List)new ArrayList();
        this.overScroller = new OverScroller(context);
        this.soundHelper = new SoundHelper();
        this.initAttrsAndDefault(context, attrs);
        this.initValue(context);
    }

    public /* synthetic */ WheelView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public WheelView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public WheelView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_LINE_SPACING = WheelView.Companion.dp2px(2.0f);
        DEFAULT_TEXT_SIZE = WheelView.Companion.sp2px(15.0f);
        DEFAULT_TEXT_BOUNDARY_MARGIN = WheelView.Companion.dp2px(2.0f);
        DEFAULT_DIVIDER_HEIGHT = WheelView.Companion.dp2px(1.0f);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\t"}, d2={"Lcom/kevin/wheelview/WheelView$OnItemSelectedListener;", "", "onItemSelected", "", "wheelView", "Lcom/kevin/wheelview/WheelView;", "data", "position", "", "wheelview_release"})
    public static interface OnItemSelectedListener {
        public void onItemSelected(@NotNull WheelView var1, @NotNull Object var2, int var3);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0005H&J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0005H&J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0005H&\u00a8\u0006\r"}, d2={"Lcom/kevin/wheelview/WheelView$OnWheelChangedListener;", "", "onWheelItemChanged", "", "oldPosition", "", "newPosition", "onWheelScroll", "scrollOffsetY", "onWheelScrollStateChanged", "state", "onWheelSelected", "position", "wheelview_release"})
    public static interface OnWheelChangedListener {
        public void onWheelScroll(int var1);

        public void onWheelItemChanged(int var1, int var2);

        public void onWheelSelected(int var1);

        public void onWheelScrollStateChanged(int var1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/kevin/wheelview/WheelView$SimpleOnWheelChangedListener;", "Lcom/kevin/wheelview/WheelView$OnWheelChangedListener;", "()V", "onWheelItemChanged", "", "oldPosition", "", "newPosition", "onWheelScroll", "scrollOffsetY", "onWheelScrollStateChanged", "state", "onWheelSelected", "position", "wheelview_release"})
    public static class SimpleOnWheelChangedListener
    implements OnWheelChangedListener {
        @Override
        public void onWheelScroll(int scrollOffsetY) {
        }

        @Override
        public void onWheelItemChanged(int oldPosition, int newPosition) {
        }

        @Override
        public void onWheelSelected(int position) {
        }

        @Override
        public void onWheelScrollStateChanged(int state) {
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\nJ\u0006\u0010\u0012\u001a\u00020\u000eJ\u0006\u0010\u0013\u001a\u00020\u000eR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/kevin/wheelview/WheelView$SoundHelper;", "", "()V", "playVolume", "", "getPlayVolume", "()F", "setPlayVolume", "(F)V", "soundId", "", "soundPool", "Landroid/media/SoundPool;", "load", "", "context", "Landroid/content/Context;", "resId", "playSoundEffect", "release", "wheelview_release"})
    private static final class SoundHelper {
        private final SoundPool soundPool;
        private int soundId;
        private float playVolume;

        public final float getPlayVolume() {
            return this.playVolume;
        }

        public final void setPlayVolume(float f) {
            this.playVolume = f;
        }

        public final void load(@NotNull Context context, @RawRes int resId) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.soundId = this.soundPool.load(context, resId, 1);
        }

        public final void playSoundEffect() {
            if (this.soundId != 0) {
                this.soundPool.play(this.soundId, this.playVolume, this.playVolume, 1, 0, 1.0f);
            }
        }

        public final void release() {
            this.soundPool.release();
        }

        public SoundHelper() {
            SoundPool soundPool;
            if (Build.VERSION.SDK_INT >= 21) {
                SoundPool soundPool2 = new SoundPool.Builder().build();
                soundPool = soundPool2;
                Intrinsics.checkExpressionValueIsNotNull((Object)soundPool2, (String)"SoundPool.Builder().build()");
            } else {
                soundPool = new SoundPool(1, 1, 1);
            }
            this.soundPool = soundPool;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0015\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\nH\u0002J\u0010\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/kevin/wheelview/WheelView$Companion;", "", "()V", "CURVED_ARC_DIRECTION_CENTER", "", "CURVED_ARC_DIRECTION_LEFT", "CURVED_ARC_DIRECTION_RIGHT", "DEFAULT_CLICK_CONFIRM", "", "DEFAULT_CURVED_FACTOR", "", "DEFAULT_DIVIDER_HEIGHT", "DEFAULT_INTEGER_FORMAT", "", "DEFAULT_LINE_SPACING", "DEFAULT_NORMAL_TEXT_COLOR", "DEFAULT_REFRACT_RATIO", "DEFAULT_SCROLL_DURATION", "DEFAULT_SELECTED_TEXT_COLOR", "DEFAULT_TEXT_BOUNDARY_MARGIN", "DEFAULT_TEXT_SIZE", "DEFAULT_VISIBLE_ITEM", "DIVIDER_TYPE_FILL", "DIVIDER_TYPE_WRAP", "SCROLL_STATE_DRAGGING", "SCROLL_STATE_IDLE", "SCROLL_STATE_SCROLLING", "TEXT_ALIGN_CENTER", "TEXT_ALIGN_LEFT", "TEXT_ALIGN_RIGHT", "dp2px", "dp", "sp2px", "sp", "wheelview_release"})
    public static final class Companion {
        private final float dp2px(float dp) {
            Resources resources = Resources.getSystem();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
            return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)resources.getDisplayMetrics());
        }

        private final float sp2px(float sp) {
            Resources resources = Resources.getSystem();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
            return TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)resources.getDisplayMetrics());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

