/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.userawarevieoview;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.VideoView;
import com.kevalpatel.userawarevieoview.CameraSourcePreview;
import com.kevalpatel.userawarevieoview.FaceAnalyser;
import com.kevalpatel.userawarevieoview.LightIntensityManager;
import com.kevalpatel.userawarevieoview.UserAwarenessListener;

public class UserAwareVideoView
extends VideoView {
    private FaceAnalyser mFaceAnalyser;
    private int mPauseTime;
    private UserAwarenessListener mUserAwarenessListener;
    private LightIntensityManager mLightIntensityManager;

    public UserAwareVideoView(Context context) {
        super(context);
        this.init(context);
    }

    public UserAwareVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public UserAwareVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @RequiresApi(api=21)
    public UserAwareVideoView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    private void init(@NonNull Context context) {
        if (!(context instanceof Activity)) {
            throw new RuntimeException("Cannot initialize with other than Activity context.");
        }
        Activity activity = (Activity)context;
        this.mFaceAnalyser = new FaceAnalyser(activity, this, this.addPreView(activity));
        this.mLightIntensityManager = new LightIntensityManager((Context)activity);
    }

    public void setUserAwarenessListener(UserAwarenessListener listener) {
        this.mUserAwarenessListener = listener;
    }

    private CameraSourcePreview addPreView(@NonNull Activity activity) {
        View rootView = ((ViewGroup)activity.getWindow().getDecorView().getRootView()).getChildAt(0);
        CameraSourcePreview cameraSourcePreview = new CameraSourcePreview((Context)activity, this);
        cameraSourcePreview.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        if (rootView instanceof LinearLayout) {
            LinearLayout linearLayout = (LinearLayout)rootView;
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(1, 1);
            linearLayout.addView((View)cameraSourcePreview, (ViewGroup.LayoutParams)params);
        } else if (rootView instanceof RelativeLayout) {
            RelativeLayout relativeLayout = (RelativeLayout)rootView;
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(1, 1);
            params.addRule(9, -1);
            params.addRule(12, -1);
            relativeLayout.addView((View)cameraSourcePreview, (ViewGroup.LayoutParams)params);
        } else if (rootView instanceof FrameLayout) {
            FrameLayout frameLayout = (FrameLayout)rootView;
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(1, 1);
            frameLayout.addView((View)cameraSourcePreview, (ViewGroup.LayoutParams)params);
        } else {
            throw new RuntimeException("Root view of the activity/fragment does not have supported view in parent.");
        }
        return cameraSourcePreview;
    }

    public void start() {
        this.startEyeTracking();
        super.start();
        this.mLightIntensityManager.startLightMonitoring();
    }

    public void stopPlayback() {
        this.stopEyeTracking();
        super.stopPlayback();
        this.mLightIntensityManager.stopLightMonitoring();
    }

    public void pause() {
        super.pause();
        this.stopEyeTracking();
        this.mLightIntensityManager.stopLightMonitoring();
    }

    void onUserAttentionGone() {
        if (this.isPlaying()) {
            this.mPauseTime = this.getCurrentPosition();
            super.pause();
        }
    }

    void onUserAttentionAvailable() {
        if (!this.isPlaying()) {
            this.seekTo(this.mPauseTime);
            super.start();
        }
    }

    void onErrorOccurred() {
        this.mUserAwarenessListener.onErrorOccurred(0);
        this.mLightIntensityManager.stopLightMonitoring();
    }

    void onCameraPermissionNotAvailable() {
        super.stopPlayback();
        this.stopEyeTracking();
        this.mLightIntensityManager.stopLightMonitoring();
        this.mUserAwarenessListener.onErrorOccurred(1);
    }

    void onFrontCameraNotFound() {
        this.mUserAwarenessListener.onErrorOccurred(2);
        this.stopEyeTracking();
        this.mLightIntensityManager.stopLightMonitoring();
    }

    void onLowLight() {
        this.mUserAwarenessListener.onErrorOccurred(3);
        this.stopEyeTracking();
    }

    void onEnoughLightAvailable() {
        this.startEyeTracking();
    }

    private void startEyeTracking() {
        if (!this.mFaceAnalyser.isTrackingRunning()) {
            this.mFaceAnalyser.startFaceTracker();
            this.mUserAwarenessListener.onEyeTrackingStarted();
        }
    }

    private void stopEyeTracking() {
        if (this.mFaceAnalyser.isTrackingRunning()) {
            this.mFaceAnalyser.stopEyeTracker();
            this.mUserAwarenessListener.onEyeTrackingStop();
        }
    }
}

