/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.userawarevieoview;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.hardware.Camera;
import android.support.v4.app.ActivityCompat;
import android.util.Log;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.vision.CameraSource;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.MultiProcessor;
import com.google.android.gms.vision.Tracker;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.FaceDetector;
import com.kevalpatel.userawarevieoview.CameraSourcePreview;
import com.kevalpatel.userawarevieoview.UserAwareVideoView;
import java.io.IOException;

class FaceAnalyser {
    private static final int RC_HANDLE_GMS = 4525;
    private final UserAwareVideoView mUserAwareVideoView;
    private FaceDetector mDetector;
    private CameraSource mCameraSource;
    private CameraSourcePreview mPreview;
    private boolean isTrackingRunning = false;
    private Activity mActivity;

    FaceAnalyser(Activity activity, UserAwareVideoView userAwareVideoView, CameraSourcePreview preview) {
        if (activity == null) {
            throw new RuntimeException("Cannot start without callback listener.");
        }
        this.mActivity = activity;
        this.mUserAwareVideoView = userAwareVideoView;
        if (preview == null) {
            throw new RuntimeException("Cannot start without camera source preview.");
        }
        this.mPreview = preview;
    }

    void stopEyeTracker() {
        this.isTrackingRunning = false;
        if (this.mDetector != null) {
            this.mDetector.release();
        }
        if (this.mPreview != null) {
            this.mPreview.release();
        }
    }

    private void creteCameraTracker() {
        this.mDetector = new FaceDetector.Builder((Context)this.mActivity).setTrackingEnabled(false).setClassificationType(1).build();
        this.mDetector.setProcessor((Detector.Processor)new MultiProcessor.Builder((MultiProcessor.Factory)new GraphicFaceTrackerFactory()).build());
        if (!this.mDetector.isOperational()) {
            this.mUserAwareVideoView.onErrorOccurred();
            Log.e((String)"Start Tracking", (String)"Face tracker is not operational.");
        }
        this.mCameraSource = new CameraSource.Builder((Context)this.mActivity, (Detector)this.mDetector).setRequestedPreviewSize(640, 480).setFacing(1).setRequestedFps(30.0f).build();
    }

    void startFaceTracker() {
        if (!this.isFrontCameraAvailable()) {
            this.mUserAwareVideoView.onFrontCameraNotFound();
            Log.e((String)"Start Tracking", (String)"Front camera not found.");
            return;
        }
        if (ActivityCompat.checkSelfPermission((Context)this.mActivity, (String)"android.permission.CAMERA") != 0) {
            this.mUserAwareVideoView.onCameraPermissionNotAvailable();
            Log.e((String)"Start Tracking", (String)"Camera permission not found.");
            return;
        }
        int statusCode = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(this.mActivity.getApplicationContext());
        if (statusCode != 0) {
            Dialog dlg = GoogleApiAvailability.getInstance().getErrorDialog(this.mActivity, statusCode, 4525);
            dlg.show();
            Log.e((String)"Start Tracking", (String)"Google Play Service not found.");
            this.mUserAwareVideoView.onErrorOccurred();
            return;
        }
        this.creteCameraTracker();
        if (this.mCameraSource != null) {
            try {
                this.mPreview.start(this.mCameraSource);
            }
            catch (IOException e) {
                Log.d((String)"startTracking", (String)e.getMessage());
                this.mUserAwareVideoView.onErrorOccurred();
                this.mCameraSource.release();
                this.mCameraSource = null;
                this.mUserAwareVideoView.onErrorOccurred();
            }
        }
        this.isTrackingRunning = true;
    }

    boolean isTrackingRunning() {
        return this.isTrackingRunning;
    }

    private boolean isFrontCameraAvailable() {
        int numCameras = Camera.getNumberOfCameras();
        return numCameras > 0 && this.mActivity.getPackageManager().hasSystemFeature("android.hardware.camera.front");
    }

    private class GraphicFaceTracker
    extends Tracker<Face> {
        int isEyesClosedCount = 0;

        private GraphicFaceTracker() {
        }

        public void onNewItem(int faceId, Face item) {
            Log.d((String)"onNewItem", (String)("" + faceId));
        }

        public void onUpdate(Detector.Detections<Face> detectionResults, Face face) {
            Log.d((String)"FaceTracker", (String)("onUpdate" + face.getIsLeftEyeOpenProbability()));
            if ((double)face.getIsLeftEyeOpenProbability() > 0.1 && (double)face.getIsRightEyeOpenProbability() > 0.1) {
                this.isEyesClosedCount = 0;
                FaceAnalyser.this.mUserAwareVideoView.onUserAttentionAvailable();
            } else {
                ++this.isEyesClosedCount;
                if (this.isEyesClosedCount > 2) {
                    FaceAnalyser.this.mUserAwareVideoView.onUserAttentionGone();
                }
            }
        }

        public void onMissing(Detector.Detections<Face> detectionResults) {
            Log.d((String)"onMissing", (String)"");
        }

        public void onDone() {
            FaceAnalyser.this.mUserAwareVideoView.onUserAttentionGone();
        }
    }

    private class GraphicFaceTrackerFactory
    implements MultiProcessor.Factory<Face> {
        private GraphicFaceTrackerFactory() {
        }

        public Tracker<Face> create(Face face) {
            return new GraphicFaceTracker();
        }
    }
}

