/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.userawarevieoview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.vision.CameraSource;
import com.kevalpatel.userawarevieoview.UserAwareVideoView;
import java.io.IOException;

@SuppressLint(value={"ViewConstructor"})
class CameraSourcePreview
extends ViewGroup {
    private static final String TAG = "CameraSourcePreview";
    private Context mContext;
    private SurfaceView mSurfaceView;
    private boolean mStartRequested;
    private boolean mSurfaceAvailable;
    private CameraSource mCameraSource;
    private UserAwareVideoView mUserAwareVideoView;

    CameraSourcePreview(Context context, UserAwareVideoView videoView) {
        super(context);
        this.mContext = context;
        this.mUserAwareVideoView = videoView;
        this.mStartRequested = false;
        this.mSurfaceAvailable = false;
        this.mSurfaceView = new SurfaceView(context);
        this.mSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)new SurfaceCallback());
        this.addView((View)this.mSurfaceView);
    }

    public void start(CameraSource cameraSource) throws IOException {
        if (cameraSource == null) {
            this.stop();
        }
        this.mCameraSource = cameraSource;
        if (this.mCameraSource != null) {
            this.mStartRequested = true;
            this.startIfReady();
        }
    }

    public void stop() {
        if (this.mCameraSource != null) {
            this.mCameraSource.stop();
        }
    }

    public void release() {
        if (this.mCameraSource != null) {
            this.mCameraSource.release();
            this.mCameraSource = null;
        }
    }

    private void startIfReady() throws IOException {
        if (this.mStartRequested && this.mSurfaceAvailable) {
            this.mCameraSource.start(this.mSurfaceView.getHolder());
            this.mStartRequested = false;
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        boolean width = true;
        boolean height = true;
        if (this.isPortraitMode()) {
            boolean tmp = width;
            width = height;
            height = tmp;
        }
        int layoutWidth = right - left;
        int layoutHeight = bottom - top;
        int childWidth = layoutWidth;
        int childHeight = (int)((float)layoutWidth / (float)width * (float)height);
        if (childHeight > layoutHeight) {
            childHeight = layoutHeight;
            childWidth = (int)((float)layoutHeight / (float)height * (float)width);
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).layout(0, 0, childWidth, childHeight);
        }
        try {
            this.startIfReady();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Could not start camera source.", (Throwable)e);
        }
    }

    private boolean isPortraitMode() {
        int orientation = this.mContext.getResources().getConfiguration().orientation;
        if (orientation == 2) {
            return false;
        }
        if (orientation == 1) {
            return true;
        }
        Log.d((String)TAG, (String)"isPortraitMode returning false by default");
        return false;
    }

    private class SurfaceCallback
    implements SurfaceHolder.Callback {
        private SurfaceCallback() {
        }

        public void surfaceCreated(SurfaceHolder surface) {
            CameraSourcePreview.this.mSurfaceAvailable = true;
            try {
                CameraSourcePreview.this.startIfReady();
            }
            catch (IOException e) {
                CameraSourcePreview.this.mUserAwareVideoView.onErrorOccurred();
                Log.e((String)CameraSourcePreview.TAG, (String)"Could not start camera source.", (Throwable)e);
            }
        }

        public void surfaceDestroyed(SurfaceHolder surface) {
            CameraSourcePreview.this.mSurfaceAvailable = false;
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        }
    }
}

