/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.ringtonepicker;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.Cursor;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.provider.MediaStore;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.support.v4.app.ActivityCompat;
import java.util.LinkedHashMap;

public final class RingtoneUtils {
    @NonNull
    @CheckResult
    static LinkedHashMap<String, Uri> getRingTone(@NonNull Context context) {
        return RingtoneUtils.getTone(context, 1);
    }

    @NonNull
    @CheckResult
    static LinkedHashMap<String, Uri> getNotificationTones(@NonNull Context context) {
        return RingtoneUtils.getTone(context, 2);
    }

    @NonNull
    @CheckResult
    static LinkedHashMap<String, Uri> getAlarmTones(@NonNull Context context) {
        return RingtoneUtils.getTone(context, 4);
    }

    @CheckResult
    @NonNull
    private static LinkedHashMap<String, Uri> getTone(@NonNull Context context, int type) {
        LinkedHashMap<String, Uri> ringToneList = new LinkedHashMap<String, Uri>();
        RingtoneManager ringtoneManager = new RingtoneManager(context);
        ringtoneManager.setType(type);
        Cursor ringsCursor = ringtoneManager.getCursor();
        while (ringsCursor.moveToNext()) {
            ringToneList.put(ringsCursor.getString(1), Uri.parse((String)(ringsCursor.getString(2) + "/" + ringsCursor.getString(0))));
        }
        ringsCursor.close();
        return ringToneList;
    }

    @NonNull
    @CheckResult
    @SuppressLint(value={"InlinedApi"})
    @RequiresPermission(anyOf={"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"})
    static LinkedHashMap<String, Uri> getMusic(@NonNull Context context) {
        LinkedHashMap<String, Uri> ringToneList = new LinkedHashMap<String, Uri>();
        if (!RingtoneUtils.checkForStorageReadPermission(context)) {
            throw new IllegalStateException("Storage permission is not available.");
        }
        Cursor mediaCursor = context.getContentResolver().query(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, new String[]{"title", "_id"}, "is_music!= 0", null, "title ASC");
        if (mediaCursor != null) {
            while (mediaCursor.moveToNext()) {
                ringToneList.put(mediaCursor.getString(mediaCursor.getColumnIndex("title")), Uri.parse((String)(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI + "/" + mediaCursor.getString(mediaCursor.getColumnIndex("_id")))));
            }
            mediaCursor.close();
        }
        return ringToneList;
    }

    @Nullable
    public static Uri getSystemRingtoneTone() {
        return RingtoneManager.getDefaultUri((int)1);
    }

    @Nullable
    public static Uri getSystemAlarmTone() {
        return RingtoneManager.getDefaultUri((int)4);
    }

    @Nullable
    public static Uri getSystemNotificationTone() {
        return RingtoneManager.getDefaultUri((int)2);
    }

    @Nullable
    public static String getRingtoneName(@NonNull Context context, @NonNull Uri uri) {
        Ringtone ringtone = RingtoneManager.getRingtone((Context)context, (Uri)uri);
        if (ringtone != null) {
            return ringtone.getTitle(context);
        }
        Cursor cur = context.getContentResolver().query(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, new String[]{"title"}, "_id =?", new String[]{uri.getLastPathSegment()}, null);
        String title = null;
        if (cur != null) {
            title = cur.getString(cur.getColumnIndex("title"));
            cur.close();
        }
        return title;
    }

    static boolean checkForStorageReadPermission(@NonNull Context context) {
        return ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }
}

