/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.ringtonepicker;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.AlertDialog;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ViewFlipper;
import com.kevalpatel.ringtonepicker.R;
import com.kevalpatel.ringtonepicker.RingTonePlayer;
import com.kevalpatel.ringtonepicker.RingtoneLoaderTask;
import com.kevalpatel.ringtonepicker.RingtonePickerListener;
import com.kevalpatel.ringtonepicker.RingtoneUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;

public final class RingtonePickerDialog
extends DialogFragment
implements RingtoneLoaderTask.LoadCompleteListener {
    private static final String ARG_DIALOG_TITLE = "arg_dialog_title";
    private static final String ARG_DIALOG_POSITIVE = "arg_dialog_positive";
    private static final String ARG_DIALOG_NEGATIVE = "arg_dialog_negative";
    private static final String ARG_RINGTONE_TYPES = "arg_dialog_types";
    private static final String ARG_CURRENT_URI = "arg_content_uri";
    private static final String ARG_LISTENER = "arg_listener";
    private static final String ARG_IS_PLAY = "arg_is_play";
    private static final String ARG_IS_DISPLAY_DEFAULT = "arg_is_display_default";
    private static final String ARG_IS_DISPLAY_SILENT = "arg_is_display_silent";
    private Context mContext;
    private RingtonePickerListener mListener;
    private LinkedHashMap<String, Uri> mRingTones;
    private RingTonePlayer mRingTonePlayer;
    private boolean isPlaySample;
    private boolean isDisplayDefault;
    private boolean isDisplaySilent;
    @NonNull
    private Pair<String, Uri> mCurrentRingTone = new Pair(null, (Object)Uri.EMPTY);
    private ArrayList<Integer> mRingtoneTypes;
    @Nullable
    private RingtoneLoaderTask mLoaderTask;
    private String mDialogTitle;
    private String mPositiveButtonTitle;
    private String mNegativeButtonTitle;
    private ListView mListView;
    private ViewFlipper mViewFlipper;

    private static void launchRingtonePicker(@NonNull FragmentManager fragmentManager, @Nullable String title, @NonNull String positiveButtonText, @Nullable String negativeButtonText, @NonNull ArrayList<Integer> ringtoneTypes, @Nullable String currentUri, @NonNull RingtonePickerListener listener, boolean isPlaySample, boolean isDisplayDefault, boolean isDisplaySilent) {
        Bundle bundle = new Bundle();
        bundle.putString(ARG_DIALOG_TITLE, title);
        bundle.putString(ARG_DIALOG_POSITIVE, positiveButtonText);
        bundle.putString(ARG_DIALOG_NEGATIVE, negativeButtonText);
        bundle.putIntegerArrayList(ARG_RINGTONE_TYPES, ringtoneTypes);
        bundle.putString(ARG_CURRENT_URI, currentUri);
        bundle.putBoolean(ARG_IS_PLAY, isPlaySample);
        bundle.putBoolean(ARG_IS_DISPLAY_DEFAULT, isDisplayDefault);
        bundle.putBoolean(ARG_IS_DISPLAY_SILENT, isDisplaySilent);
        bundle.putSerializable(ARG_LISTENER, (Serializable)listener);
        RingtonePickerDialog ringtonePickerDialog = new RingtonePickerDialog();
        ringtonePickerDialog.setRetainInstance(true);
        ringtonePickerDialog.setArguments(bundle);
        ringtonePickerDialog.show(fragmentManager, RingtonePickerDialog.class.getSimpleName());
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.mContext = context;
    }

    public void onSaveInstanceState(Bundle outState) {
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() == null) {
            throw new IllegalArgumentException("Arguments cannot be null.");
        }
        this.mListener = (RingtonePickerListener)this.getArguments().getSerializable(ARG_LISTENER);
        this.getArguments().remove(ARG_LISTENER);
        if (this.mListener == null) {
            throw new IllegalArgumentException("Callback listener cannot be null.");
        }
        if (this.getArguments().getString(ARG_CURRENT_URI) != null) {
            Uri currentToneUri = Uri.parse((String)this.getArguments().getString(ARG_CURRENT_URI));
            this.mCurrentRingTone = new Pair((Object)RingtoneUtils.getRingtoneName(this.mContext, currentToneUri), (Object)currentToneUri);
        }
        if (this.getArguments().getString(ARG_DIALOG_TITLE) == null) {
            throw new IllegalArgumentException("Title of the dialog is not provided.");
        }
        this.mDialogTitle = this.getArguments().getString(ARG_DIALOG_TITLE);
        if (this.getArguments().getString(ARG_DIALOG_NEGATIVE) == null) {
            throw new IllegalArgumentException("Title of the negative dialog button is not provided.");
        }
        this.mNegativeButtonTitle = this.getArguments().getString(ARG_DIALOG_NEGATIVE);
        if (this.getArguments().getString(ARG_DIALOG_POSITIVE) == null) {
            throw new IllegalArgumentException("Title of the positive dialog button is not provided.");
        }
        this.mPositiveButtonTitle = this.getArguments().getString(ARG_DIALOG_POSITIVE);
        this.isPlaySample = this.getArguments().getBoolean(ARG_IS_PLAY, false);
        this.isDisplayDefault = this.getArguments().getBoolean(ARG_IS_DISPLAY_DEFAULT, false);
        this.isDisplaySilent = this.getArguments().getBoolean(ARG_IS_DISPLAY_SILENT, false);
        this.mRingtoneTypes = this.getArguments().getIntegerArrayList(ARG_RINGTONE_TYPES);
        this.mRingTonePlayer = new RingTonePlayer(this.mContext);
    }

    @SuppressLint(value={"MissingPermission"})
    private void prepareRingtoneList(ArrayList<Integer> types) {
        if (types == null || types.isEmpty()) {
            throw new IllegalArgumentException("At least one ringtone type must be added.");
        }
        this.mRingTones = new LinkedHashMap();
        if (this.isDisplayDefault) {
            this.mRingTones.put(this.getString(R.string.title_default_list_item), RingtoneUtils.getSystemRingtoneTone());
        }
        if (this.isDisplaySilent) {
            this.mRingTones.put(this.getString(R.string.title_silent_list_item), null);
        }
        this.mLoaderTask = new RingtoneLoaderTask(this.mContext.getApplicationContext(), this);
        this.mLoaderTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new ArrayList[]{types});
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        int currentSelectionPos = this.getUriPosition(this.mRingTones, (Uri)this.mCurrentRingTone.second);
        View customView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_ringtone_dialog, null);
        this.mListView = (ListView)customView.findViewById(R.id.ringtone_list);
        this.mListView.setSelection(currentSelectionPos);
        this.mListView.setChoiceMode(1);
        this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                String currentToneTitle = (String)RingtonePickerDialog.this.mListView.getAdapter().getItem(position);
                RingtonePickerDialog.this.mCurrentRingTone = new Pair((Object)currentToneTitle, RingtonePickerDialog.this.mRingTones.get(currentToneTitle));
                if (RingtonePickerDialog.this.isPlaySample) {
                    try {
                        RingtonePickerDialog.this.mRingTonePlayer.playRingtone((Uri)((RingtonePickerDialog)RingtonePickerDialog.this).mCurrentRingTone.second);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.mViewFlipper = (ViewFlipper)customView.findViewById(R.id.view_flipper);
        this.mViewFlipper.setDisplayedChild(0);
        this.prepareRingtoneList(this.mRingtoneTypes);
        return new AlertDialog.Builder(this.mContext).setTitle((CharSequence)this.mDialogTitle).setView(customView).setPositiveButton((CharSequence)this.mPositiveButtonTitle, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                RingtonePickerDialog.this.mListener.OnRingtoneSelected((String)((RingtonePickerDialog)RingtonePickerDialog.this).mCurrentRingTone.first, (Uri)((RingtonePickerDialog)RingtonePickerDialog.this).mCurrentRingTone.second);
            }
        }).setNegativeButton((CharSequence)this.mNegativeButtonTitle, null).create();
    }

    private int getUriPosition(@NonNull HashMap<String, Uri> ringTones, @Nullable Uri uri) {
        if (uri != null && uri != Uri.EMPTY) {
            Uri[] values = ringTones.values().toArray(new Uri[ringTones.size()]);
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].toString().equals(uri.toString())) continue;
                return i;
            }
        }
        return -1;
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mLoaderTask != null && !this.mLoaderTask.isCancelled()) {
            this.mLoaderTask.cancel(true);
        }
        this.mRingTonePlayer.close();
    }

    @Override
    public void onLoadComplete(@NonNull HashMap<String, Uri> ringtone) {
        this.mViewFlipper.setDisplayedChild(1);
        this.mRingTones.putAll(ringtone);
        Object[] itemTitles = this.mRingTones.keySet().toArray(new String[this.mRingTones.size()]);
        this.mListView.setAdapter((ListAdapter)new ArrayAdapter(this.mContext, 17367058, itemTitles));
    }

    public static class Builder {
        public static final int TYPE_RINGTONE = 1;
        public static final int TYPE_NOTIFICATION = 2;
        public static final int TYPE_ALARM = 4;
        public static final int TYPE_MUSIC = 3746;
        private String mTitle;
        private String mPositiveButtonText;
        private String mCancelButtonText;
        @NonNull
        private ArrayList<Integer> mRingtoneType = new ArrayList();
        private boolean isPlaySample = false;
        private boolean isDisplayDefault = false;
        private boolean isDisplaySilent = false;
        @Nullable
        private String mCurrentRingtoneUri = null;
        private RingtonePickerListener mListener;
        private Context mContext;
        private FragmentManager mFragmentManager;

        public Builder(@NonNull Context context, @NonNull FragmentManager fragmentManager) {
            this.mContext = context;
            this.mFragmentManager = fragmentManager;
            this.mTitle = this.mContext.getString(R.string.ringtone_picker_default_title);
            this.mPositiveButtonText = this.mContext.getString(17039370);
            this.mCancelButtonText = this.mContext.getString(0x1040000);
        }

        public Builder setTitle(@Nullable String title) {
            this.mTitle = title;
            return this;
        }

        public Builder setTitle(@StringRes int title) {
            return this.setPositiveButtonText(this.mContext.getString(title));
        }

        public Builder setPositiveButtonText(@NonNull String positiveButtonText) {
            if (positiveButtonText != null) {
                this.mPositiveButtonText = positiveButtonText;
            }
            return this;
        }

        public Builder setPositiveButtonText(@StringRes int positiveButtonText) {
            return this.setPositiveButtonText(this.mContext.getString(positiveButtonText));
        }

        public Builder setCancelButtonText(@Nullable String cancelButtonText) {
            this.mCancelButtonText = cancelButtonText;
            return this;
        }

        public Builder setCancelButtonText(@StringRes int cancelButtonText) {
            return this.setCancelButtonText(this.mContext.getString(cancelButtonText));
        }

        public Builder addRingtoneType(int ringtoneType) {
            if (ringtoneType == 3746 && !RingtoneUtils.checkForStorageReadPermission(this.mContext)) {
                throw new IllegalStateException("android.permission.READ_EXTERNAL_STORAGE is required for TYPE_MUSIC.");
            }
            this.mRingtoneType.add(ringtoneType);
            return this;
        }

        public Builder setPlaySampleWhileSelection(boolean playSample) {
            this.isPlaySample = playSample;
            return this;
        }

        public Builder setCurrentRingtoneUri(@Nullable Uri currentRingtoneUri) {
            if (currentRingtoneUri != null && currentRingtoneUri != Uri.EMPTY) {
                this.mCurrentRingtoneUri = currentRingtoneUri.toString();
            }
            return this;
        }

        public Builder setListener(@NonNull RingtonePickerListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("RingtonePickerListener cannot be null.");
            }
            this.mListener = listener;
            return this;
        }

        public Builder displayDefaultRingtone(boolean display) {
            this.isDisplayDefault = display;
            return this;
        }

        public Builder displaySilentRingtone(boolean display) {
            this.isDisplaySilent = display;
            return this;
        }

        public void show() {
            if (this.mRingtoneType.size() == 0) {
                throw new IllegalArgumentException("Select at least one ringtone.");
            }
            RingtonePickerDialog.launchRingtonePicker(this.mFragmentManager, this.mTitle, this.mPositiveButtonText, this.mCancelButtonText, this.mRingtoneType, this.mCurrentRingtoneUri, this.mListener, this.isPlaySample, this.isDisplayDefault, this.isDisplaySilent);
        }
    }
}

