/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.ringtonepicker;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import com.kevalpatel.ringtonepicker.RingtoneUtils;
import java.util.ArrayList;
import java.util.HashMap;

class RingtoneLoaderTask
extends AsyncTask<ArrayList<Integer>, Void, HashMap<String, Uri>> {
    @NonNull
    private final LoadCompleteListener mListener;
    @SuppressLint(value={"StaticFieldLeak"})
    @NonNull
    private final Context mApplication;

    RingtoneLoaderTask(@NonNull Context application, @NonNull LoadCompleteListener loadCompleteListener) {
        this.mListener = loadCompleteListener;
        this.mApplication = application;
    }

    protected void onPreExecute() {
        super.onPreExecute();
    }

    @SafeVarargs
    @SuppressLint(value={"MissingPermission"})
    @NonNull
    protected final HashMap<String, Uri> doInBackground(ArrayList<Integer> ... voids) {
        HashMap<String, Uri> ringTones = new HashMap<String, Uri>();
        block6: for (int type : voids[0]) {
            switch (type) {
                case 1: {
                    ringTones.putAll(RingtoneUtils.getRingTone(this.mApplication));
                    continue block6;
                }
                case 4: {
                    ringTones.putAll(RingtoneUtils.getAlarmTones(this.mApplication));
                    continue block6;
                }
                case 3746: {
                    ringTones.putAll(RingtoneUtils.getMusic(this.mApplication));
                    continue block6;
                }
                case 2: {
                    ringTones.putAll(RingtoneUtils.getNotificationTones(this.mApplication));
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Invalid ringtone type.");
        }
        return ringTones;
    }

    protected void onPostExecute(HashMap<String, Uri> ringtone) {
        super.onPostExecute(ringtone);
        this.mListener.onLoadComplete(ringtone);
    }

    static interface LoadCompleteListener {
        public void onLoadComplete(@NonNull HashMap<String, Uri> var1);
    }
}

