/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.ringtonepicker;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import java.io.Closeable;
import java.io.IOException;

final class RingTonePlayer
implements Closeable {
    @NonNull
    private final Context mContext;
    @NonNull
    private final MediaPlayer mMediaPlayer;

    RingTonePlayer(@NonNull Context context) {
        this.mContext = context;
        this.mMediaPlayer = new MediaPlayer();
    }

    void playRingtone(@Nullable Uri uri) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        if (this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.stop();
        }
        this.mMediaPlayer.reset();
        if (uri == null || uri == Uri.EMPTY) {
            Log.w((String)RingTonePlayer.class.getName(), (String)"playRingtone: Uri is null or empty.");
            return;
        }
        this.mMediaPlayer.setDataSource(this.mContext, uri);
        this.mMediaPlayer.prepare();
        this.mMediaPlayer.start();
    }

    @Override
    public void close() {
        if (this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.stop();
        }
        this.mMediaPlayer.release();
    }
}

