/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.ringtonepicker;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.AlertDialog;
import com.kevalpatel.ringtonepicker.RingTonePlayer;
import com.kevalpatel.ringtonepicker.RingtonePickerListener;
import com.kevalpatel.ringtonepicker.RingtoneUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public final class RingtonePickerDialog
extends DialogFragment {
    private static final String ARG_DIALOG_TITLE = "arg_dialog_title";
    private static final String ARG_DIALOG_POSITIVE = "arg_dialog_positive";
    private static final String ARG_DIALOG_NEGATIVE = "arg_dialog_negative";
    private static final String ARG_RINGTONE_TYPES = "arg_dialog_types";
    private static final String ARG_CURRENT_URI = "arg_content_uri";
    private static final String ARG_LISTENER = "arg_listener";
    private static final String ARG_IS_PLAY = "arg_is_play";
    private RingtonePickerListener mListener;
    private HashMap<String, Uri> mRingTones;
    private String mCurrentToneTitle;
    private Uri mCurrentToneUri;
    private RingTonePlayer mRingTonePlayer;

    private static void launchRingtonePicker(@NonNull FragmentManager fragmentManager, @Nullable String title, @NonNull String positiveButtonText, @Nullable String negativeButtonText, @NonNull ArrayList<Integer> ringtoneTypes, @Nullable String currentUri, @NonNull RingtonePickerListener listener, boolean isPlaySample) {
        Bundle bundle = new Bundle();
        bundle.putString(ARG_DIALOG_TITLE, title);
        bundle.putString(ARG_DIALOG_POSITIVE, positiveButtonText);
        bundle.putString(ARG_DIALOG_NEGATIVE, negativeButtonText);
        bundle.putIntegerArrayList(ARG_RINGTONE_TYPES, ringtoneTypes);
        bundle.putString(ARG_CURRENT_URI, currentUri);
        bundle.putBoolean(ARG_IS_PLAY, isPlaySample);
        bundle.putSerializable(ARG_LISTENER, (Serializable)listener);
        RingtonePickerDialog ringtonePickerDialog = new RingtonePickerDialog();
        ringtonePickerDialog.setRetainInstance(true);
        ringtonePickerDialog.setArguments(bundle);
        ringtonePickerDialog.show(fragmentManager, RingtonePickerDialog.class.getSimpleName());
    }

    public void onSaveInstanceState(Bundle outState) {
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mListener = (RingtonePickerListener)this.getArguments().getSerializable(ARG_LISTENER);
        this.getArguments().remove(ARG_LISTENER);
        this.mRingTonePlayer = new RingTonePlayer((Context)this.getActivity());
        ArrayList types = this.getArguments().getIntegerArrayList(ARG_RINGTONE_TYPES);
        this.mRingTones = new HashMap();
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            int type = (Integer)iterator.next();
            switch (type) {
                case 1: {
                    RingtoneUtils.getRingTone((Context)this.getActivity(), this.mRingTones);
                    break;
                }
                case 4: {
                    RingtoneUtils.getAlarmTones((Context)this.getActivity(), this.mRingTones);
                    break;
                }
                case 3746: {
                    if (ActivityCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.READ_EXTERNAL_STORAGE") != 0) break;
                    RingtoneUtils.getMusic((Context)this.getActivity(), this.mRingTones);
                    break;
                }
                case 2: {
                    RingtoneUtils.getNotificationTones((Context)this.getActivity(), this.mRingTones);
                }
            }
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        int currentSelectionPos = -1;
        if (this.getArguments().getString(ARG_CURRENT_URI) != null) {
            this.mCurrentToneUri = Uri.parse((String)this.getArguments().getString(ARG_CURRENT_URI));
            this.mCurrentToneTitle = RingtoneUtils.getRingtoneName((Context)this.getActivity(), this.mCurrentToneUri);
            if (this.mCurrentToneTitle != null) {
                currentSelectionPos = this.getUriPosition(this.mCurrentToneUri);
            } else {
                this.mCurrentToneUri = null;
            }
        }
        CharSequence[] titles = this.mRingTones.keySet().toArray(new String[this.mRingTones.size()]);
        boolean isPlaySample = this.getArguments().getBoolean(ARG_IS_PLAY);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity()).setSingleChoiceItems(titles, currentSelectionPos, new DialogInterface.OnClickListener((String[])titles, isPlaySample){
            final /* synthetic */ String[] val$titles;
            final /* synthetic */ boolean val$isPlaySample;
            {
                this.val$titles = stringArray;
                this.val$isPlaySample = bl;
            }

            public void onClick(DialogInterface dialog, int which) {
                RingtonePickerDialog.this.mCurrentToneTitle = this.val$titles[which];
                RingtonePickerDialog.this.mCurrentToneUri = (Uri)RingtonePickerDialog.this.mRingTones.get(RingtonePickerDialog.this.mCurrentToneTitle);
                if (this.val$isPlaySample) {
                    try {
                        RingtonePickerDialog.this.mRingTonePlayer.playRingtone(RingtonePickerDialog.this.mCurrentToneUri);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).setPositiveButton((CharSequence)this.getArguments().getString(ARG_DIALOG_POSITIVE), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                RingtonePickerDialog.this.mListener.OnRingtoneSelected(RingtonePickerDialog.this.mCurrentToneTitle, RingtonePickerDialog.this.mCurrentToneUri);
            }
        });
        if (this.getArguments().getString(ARG_DIALOG_TITLE) != null) {
            builder.setTitle((CharSequence)this.getArguments().getString(ARG_DIALOG_TITLE));
        }
        if (this.getArguments().getString(ARG_DIALOG_NEGATIVE) != null) {
            builder.setNegativeButton((CharSequence)this.getArguments().getString(ARG_DIALOG_NEGATIVE), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            });
        }
        return builder.create();
    }

    private int getUriPosition(@NonNull Uri uri) {
        Uri[] values = this.mRingTones.values().toArray(new Uri[this.mRingTones.size()]);
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].toString().equals(uri.toString())) continue;
            return i;
        }
        return -1;
    }

    public void onDestroy() {
        super.onDestroy();
        this.mRingTonePlayer.release();
    }

    public static class Builder {
        public static final int TYPE_RINGTONE = 1;
        public static final int TYPE_NOTIFICATION = 2;
        public static final int TYPE_ALARM = 4;
        public static final int TYPE_MUSIC = 3746;
        private String mTitle = "Select ringtone";
        private String mPositiveButtonText = "Ok";
        private String mCancelButtonText = "Cancel";
        private ArrayList<Integer> mRingtoneType = new ArrayList();
        private boolean isPlaySample = false;
        private String mCurrentRingtoneUri;
        private RingtonePickerListener mListener;
        private Context mContext;
        private FragmentManager mFragmentManager;

        public Builder(@NonNull Context context, @NonNull FragmentManager fragmentManager) {
            this.mContext = context;
            this.mFragmentManager = fragmentManager;
        }

        public Builder setTitle(@Nullable String title) {
            this.mTitle = title;
            return this;
        }

        public Builder setPositiveButtonText(@NonNull String positiveButtonText) {
            if (positiveButtonText == null) {
                throw new IllegalArgumentException("Positive button text cannot be null.");
            }
            this.mPositiveButtonText = positiveButtonText;
            return this;
        }

        public Builder setPositiveButtonText(@StringRes int positiveButtonText) {
            return this.setPositiveButtonText(this.mContext.getString(positiveButtonText));
        }

        public Builder setCancelButtonText(@Nullable String cancelButtonText) {
            this.mCancelButtonText = cancelButtonText;
            return this;
        }

        public Builder setCancelButtonText(@StringRes int cancelButtonText) {
            return this.setCancelButtonText(this.mContext.getString(cancelButtonText));
        }

        public Builder addRingtoneType(int ringtoneType) {
            if (ringtoneType == 3746 && ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.READ_EXTERNAL_STORAGE") != 0) {
                throw new IllegalStateException("android.permission.READ_EXTERNAL_STORAGE is required for TYPE_MUSIC.");
            }
            this.mRingtoneType.add(ringtoneType);
            return this;
        }

        public Builder setPlaySampleWhileSelection(boolean playSample) {
            this.isPlaySample = playSample;
            return this;
        }

        public Builder setCurrentRingtoneUri(@Nullable Uri currentRingtoneUri) {
            if (currentRingtoneUri != null) {
                this.mCurrentRingtoneUri = currentRingtoneUri.toString();
            }
            return this;
        }

        public Builder setListener(@NonNull RingtonePickerListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("RingtonePickerListener cannot be null.");
            }
            this.mListener = listener;
            return this;
        }

        public void show() {
            if (this.mRingtoneType.size() == 0) {
                throw new IllegalArgumentException("Select at least one ringtone.");
            }
            RingtonePickerDialog.launchRingtonePicker(this.mFragmentManager, this.mTitle, this.mPositiveButtonText, this.mCancelButtonText, this.mRingtoneType, this.mCurrentRingtoneUri, this.mListener, this.isPlaySample);
        }
    }
}

