/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.ringtonepicker;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.Cursor;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import java.util.HashMap;

public final class RingtoneUtils {
    static void getRingTone(Context context, @NonNull HashMap<String, Uri> ringTonesList) {
        RingtoneUtils.getTone(context, 1, ringTonesList);
    }

    static void getNotificationTones(Context context, @NonNull HashMap<String, Uri> ringTonesList) {
        RingtoneUtils.getTone(context, 2, ringTonesList);
    }

    static void getAlarmTones(Context context, @NonNull HashMap<String, Uri> ringTonesList) {
        RingtoneUtils.getTone(context, 4, ringTonesList);
    }

    private static void getTone(Context context, int type, @NonNull HashMap<String, Uri> ringTonesList) {
        RingtoneManager mRingtoneMgr = new RingtoneManager(context);
        mRingtoneMgr.setType(type);
        Cursor ringsCursor = mRingtoneMgr.getCursor();
        while (ringsCursor.moveToNext()) {
            ringTonesList.put(ringsCursor.getString(1), Uri.parse((String)(ringsCursor.getString(2) + "/" + ringsCursor.getString(0))));
        }
        ringsCursor.close();
    }

    @SuppressLint(value={"InlinedApi"})
    @RequiresPermission(allOf={"android.permission.READ_EXTERNAL_STORAGE"})
    static void getMusic(@NonNull Context context, @NonNull HashMap<String, Uri> ringTonesList) {
        Cursor mediaCursor = context.getContentResolver().query(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, new String[]{"title", "_id"}, "is_music!= 0", null, "title ASC");
        if (mediaCursor != null) {
            while (mediaCursor.moveToNext()) {
                ringTonesList.put(mediaCursor.getString(mediaCursor.getColumnIndex("title")), Uri.parse((String)(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI + "/" + mediaCursor.getString(mediaCursor.getColumnIndex("_id")))));
            }
            mediaCursor.close();
        }
    }

    @Nullable
    public static Uri getSystemRingtoneTone() {
        return RingtoneManager.getDefaultUri((int)1);
    }

    @Nullable
    public static Uri getSystemAlarmTone() {
        return RingtoneManager.getDefaultUri((int)4);
    }

    @Nullable
    public static Uri getSystemNotificationTone() {
        return RingtoneManager.getDefaultUri((int)2);
    }

    @Nullable
    public static String getRingtoneName(@NonNull Context context, @NonNull Uri uri) {
        Ringtone ringtone = RingtoneManager.getRingtone((Context)context, (Uri)uri);
        if (ringtone != null) {
            return ringtone.getTitle(context);
        }
        Cursor cur = context.getContentResolver().query(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, new String[]{"title"}, "_id =?", new String[]{uri.getLastPathSegment()}, null);
        String title = null;
        if (cur != null) {
            title = cur.getString(cur.getColumnIndex("title"));
            cur.close();
        }
        return title;
    }
}

